/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.component;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.Incubating;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ModelMaps;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecIdentifier;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.TransformationFileType;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class BaseComponentSpec
implements ComponentSpecInternal {
    private static ThreadLocal<ComponentInfo> nextComponentInfo = new ThreadLocal();
    private final ComponentSpecIdentifier identifier;
    private final String typeName;
    private final MutableModelNode binaries;
    private final MutableModelNode sources;
    private final MutableModelNode modelNode;

    public static <T extends BaseComponentSpec> T create(Class<? extends ComponentSpec> publicType, Class<T> implementationType, ComponentSpecIdentifier identifier, MutableModelNode modelNode) {
        nextComponentInfo.set(new ComponentInfo(identifier, modelNode, publicType.getSimpleName()));
        try {
            BaseComponentSpec baseComponentSpec = (BaseComponentSpec)DirectInstantiator.INSTANCE.newInstance(implementationType, new Object[0]);
            return (T)baseComponentSpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create component of type %s", publicType.getSimpleName()), e.getCause());
        }
        finally {
            nextComponentInfo.set(null);
        }
    }

    public BaseComponentSpec() {
        this(nextComponentInfo.get());
    }

    private BaseComponentSpec(ComponentInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseComponentSpec is not permitted. Use a ComponentTypeBuilder instead.");
        }
        this.identifier = info.componentIdentifier;
        this.typeName = info.typeName;
        this.modelNode = info.modelNode;
        this.binaries = ModelMaps.addModelMapNode((MutableModelNode)this.modelNode, BinarySpec.class, (String)"binaries");
        this.sources = ModelMaps.addModelMapNode((MutableModelNode)this.modelNode, LanguageSourceSet.class, (String)"sources");
    }

    public String getName() {
        return this.identifier.getName();
    }

    @Override
    public String getProjectPath() {
        return this.identifier.getProjectPath();
    }

    protected String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s '%s'", this.getTypeName(), this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public ModelMap<LanguageSourceSet> getSource() {
        DeprecationLogger.nagUserOfReplacedProperty((String)"source", (String)"sources");
        return this.getSources();
    }

    @Override
    public ModelMap<LanguageSourceSet> getSources() {
        return ModelMaps.toView((MutableModelNode)this.sources, LanguageSourceSet.class);
    }

    @Override
    public ModelMap<BinarySpec> getBinaries() {
        return ModelMaps.toView((MutableModelNode)this.binaries, BinarySpec.class);
    }

    @Override
    public Set<? extends Class<? extends TransformationFileType>> getInputTypes() {
        return Collections.emptySet();
    }

    private static class ComponentInfo {
        final ComponentSpecIdentifier componentIdentifier;
        final MutableModelNode modelNode;
        final String typeName;

        private ComponentInfo(ComponentSpecIdentifier componentIdentifier, MutableModelNode modelNode, String typeName) {
            this.componentIdentifier = componentIdentifier;
            this.modelNode = modelNode;
            this.typeName = typeName;
        }
    }
}

