/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.basic;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ObjectSocketWrapper {
    private Socket socket;
    private final Logger logger = Logging.getLogger(ObjectSocketWrapper.class);

    public ObjectSocketWrapper(Socket socket) {
        this.socket = socket;
    }

    public void setTimeout(int timeoutMilliseconds) {
        try {
            this.socket.setSoTimeout(timeoutMilliseconds);
        }
        catch (SocketException e) {
            this.logger.error("Failed to set timeout", (Throwable)e);
        }
    }

    public Object readObject() {
        ObjectInputStream reader = null;
        try {
            reader = new ObjectInputStream(this.socket.getInputStream());
        }
        catch (SocketException e) {
            if (!this.isIgnorableException(e)) {
                this.logger.error("Reading Object", (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("Reading Object", (Throwable)e);
            return null;
        }
        try {
            return reader.readObject();
        }
        catch (SocketException e) {
            if (!this.isIgnorableException(e)) {
                this.logger.error("Reading Object", (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("Reading Object", (Throwable)e);
            return null;
        }
    }

    private boolean isIgnorableException(SocketException e) {
        return "Connection reset".equalsIgnoreCase(e.getMessage());
    }

    public synchronized boolean sendObject(Object object) {
        ObjectOutputStream writer = null;
        try {
            writer = new ObjectOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.logger.error("Exception when creating writer sending object: " + object, (Throwable)e);
            return false;
        }
        try {
            writer.reset();
            writer.flush();
            writer.writeObject(object);
            writer.flush();
            return true;
        }
        catch (Exception e) {
            this.logger.error("Exception when sending object: " + object, (Throwable)e);
            return false;
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.error("Closing", (Throwable)e);
        }
    }
}

