/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.basic;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.foundation.common.ObserverLord;
import org.gradle.foundation.ipc.basic.ExecutionInfo;
import org.gradle.foundation.ipc.basic.Server;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessLauncherServer
extends Server<Protocol, ServerObserver> {
    private volatile ExecHandle externalProcess;
    private static final Logger LOGGER = Logging.getLogger(ProcessLauncherServer.class);

    public ProcessLauncherServer(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected void communicationsStarted() {
        this.launchExternalProcess();
    }

    private void launchExternalProcess() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ExecutionInfo executionInfo = null;
                ExecHandle execHandle = null;
                ByteArrayOutputStream output = null;
                try {
                    executionInfo = ((Protocol)ProcessLauncherServer.this.protocol).getExecutionInfo(ProcessLauncherServer.this.getPort());
                    ExecHandleBuilder builder = new ExecHandleBuilder();
                    builder.workingDir((Object)executionInfo.getWorkingDirectory());
                    builder.commandLine((Object[])executionInfo.getCommandLineArguments());
                    builder.environment(executionInfo.getEnvironmentVariables());
                    output = new ByteArrayOutputStream();
                    builder.setStandardOutput((OutputStream)output);
                    builder.setErrorOutput((OutputStream)output);
                    execHandle = builder.build();
                    ProcessLauncherServer.this.setExternalProcess(execHandle);
                    execHandle.start();
                }
                catch (Throwable e) {
                    LOGGER.error("Starting external process", e);
                    ProcessLauncherServer.this.notifyClientExited(-1, e.getMessage());
                    ProcessLauncherServer.this.setExternalProcess(null);
                    return;
                }
                ExecResult result = execHandle.waitForFinish();
                LOGGER.debug("External process completed with exit code {}", (Object)result.getExitValue());
                ProcessLauncherServer.this.setExternalProcess(null);
                executionInfo.processExecutionComplete();
                ProcessLauncherServer.this.notifyClientExited(result.getExitValue(), output.toString());
            }
        });
        thread.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.killProcess();
    }

    public void setExternalProcess(ExecHandle externalProcess) {
        this.externalProcess = externalProcess;
    }

    public synchronized void killProcess() {
        if (this.externalProcess != null) {
            this.requestShutdown();
            ((Protocol)this.protocol).aboutToKillProcess();
            this.externalProcess.abort();
            this.setExternalProcess(null);
            this.notifyClientExited(-1, "Process Canceled");
        }
    }

    private void notifyClientExited(final int result, final String output) {
        ((Protocol)this.protocol).clientExited(result, output);
        this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<ServerObserver>(){

            @Override
            public void notify(ServerObserver observer) {
                observer.clientExited(result, output);
            }
        });
    }

    public static interface ServerObserver
    extends Server.ServerObserver {
        public void clientExited(int var1, String var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Protocol
    extends Server.Protocol<ProcessLauncherServer> {
        public void aboutToKillProcess();

        public ExecutionInfo getExecutionInfo(int var1);

        public void clientExited(int var1, String var2);
    }
}

