/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.ListBackedFileSet;
import org.gradle.api.internal.file.collections.MinimalFileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalFileSetSnapshotter
extends DefaultFileCollectionSnapshotter {
    public MinimalFileSetSnapshotter(FileSnapshotter snapshotter, TaskArtifactStateCacheAccess cacheAccess, StringInterner stringInterner, FileResolver fileResolver) {
        super(snapshotter, cacheAccess, stringInterner, fileResolver);
    }

    @Override
    protected void visitFiles(FileCollection input, List<FileVisitDetails> allFileVisitDetails, List<File> missingFiles) {
        this.visitFiles(new ListBackedFileSet(input.getFiles()), allFileVisitDetails, missingFiles);
    }

    private void visitFiles(MinimalFileSet input, List<FileVisitDetails> allFileVisitDetails, List<File> missingFiles) {
        for (File file : input.getFiles()) {
            if (file.exists()) {
                allFileVisitDetails.add(new DefaultFileVisitDetails(file));
                continue;
            }
            missingFiles.add(file);
        }
    }
}

