/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileSystemChangeWaiterFactory;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.internal.filewatch.FileWatcherEventListener;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.FileWatcherListener;

public class DefaultFileSystemChangeWaiterFactory
implements FileSystemChangeWaiterFactory {
    private final FileWatcherFactory fileWatcherFactory;
    private final long quietPeriodMillis;

    public DefaultFileSystemChangeWaiterFactory(FileWatcherFactory fileWatcherFactory) {
        this(fileWatcherFactory, 250L);
    }

    public DefaultFileSystemChangeWaiterFactory(FileWatcherFactory fileWatcherFactory, long quietPeriodMillis) {
        this.fileWatcherFactory = fileWatcherFactory;
        this.quietPeriodMillis = quietPeriodMillis;
    }

    public FileSystemChangeWaiter createChangeWaiter(BuildCancellationToken cancellationToken) {
        return new ChangeWaiter(this.fileWatcherFactory, this.quietPeriodMillis, cancellationToken);
    }

    private static long monotonicClockMillis() {
        return System.nanoTime() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void signal(Lock lock, Condition condition, Runnable runnable) {
        boolean interrupted = Thread.interrupted();
        lock.lock();
        try {
            runnable.run();
            condition.signal();
        }
        finally {
            lock.unlock();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void signal(Lock lock, Condition condition) {
        DefaultFileSystemChangeWaiterFactory.signal(lock, condition, new Runnable(){

            public void run() {
            }
        });
    }

    private static class ChangeWaiter
    implements FileSystemChangeWaiter {
        private final long quietPeriodMillis;
        private final BuildCancellationToken cancellationToken;
        private final AtomicReference<Throwable> error = new AtomicReference();
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private final AtomicLong lastChangeAt = new AtomicLong(0L);
        private final FileWatcher watcher;
        private final Action<Throwable> onError;
        private boolean watching;
        private volatile FileWatcherEventListener eventListener;

        private ChangeWaiter(FileWatcherFactory fileWatcherFactory, long quietPeriodMillis, BuildCancellationToken cancellationToken) {
            this.quietPeriodMillis = quietPeriodMillis;
            this.cancellationToken = cancellationToken;
            this.onError = new Action<Throwable>(){

                public void execute(Throwable throwable) {
                    ChangeWaiter.this.error.set(throwable);
                    DefaultFileSystemChangeWaiterFactory.signal(ChangeWaiter.this.lock, ChangeWaiter.this.condition);
                }
            };
            this.watcher = fileWatcherFactory.watch(this.onError, new FileWatcherListener(){

                public void onChange(FileWatcher watcher, FileWatcherEvent event) {
                    if (event.getType() != FileWatcherEvent.Type.MODIFY || !event.getFile().isDirectory()) {
                        FileWatcherEventListener listener = ChangeWaiter.this.eventListener;
                        if (listener != null) {
                            listener.onChange(event);
                        }
                        DefaultFileSystemChangeWaiterFactory.signal(ChangeWaiter.this.lock, ChangeWaiter.this.condition, new Runnable(){

                            public void run() {
                                ChangeWaiter.this.lastChangeAt.set(DefaultFileSystemChangeWaiterFactory.monotonicClockMillis());
                            }
                        });
                    }
                }
            });
        }

        public void watch(FileSystemSubset fileSystemSubset) {
            try {
                if (!fileSystemSubset.isEmpty()) {
                    this.watching = true;
                    this.watcher.watch(fileSystemSubset);
                }
            }
            catch (IOException e) {
                this.onError.execute((Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wait(Runnable notifier, FileWatcherEventListener eventListener) {
            Runnable cancellationHandler = new Runnable(){

                public void run() {
                    DefaultFileSystemChangeWaiterFactory.signal(ChangeWaiter.this.lock, ChangeWaiter.this.condition);
                }
            };
            try {
                this.eventListener = eventListener;
                if (this.cancellationToken.isCancellationRequested()) {
                    return;
                }
                this.cancellationToken.addCallback(cancellationHandler);
                notifier.run();
                this.lock.lock();
                try {
                    long lastChangeAtValue = this.lastChangeAt.get();
                    while (!this.cancellationToken.isCancellationRequested() && this.error.get() == null && this.shouldKeepWaitingForQuietPeriod(lastChangeAtValue)) {
                        this.condition.await(this.quietPeriodMillis, TimeUnit.MILLISECONDS);
                        lastChangeAtValue = this.lastChangeAt.get();
                    }
                }
                finally {
                    this.lock.unlock();
                }
                Throwable throwable = this.error.get();
                if (throwable != null) {
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            finally {
                this.eventListener = null;
                this.cancellationToken.removeCallback(cancellationHandler);
                this.watcher.stop();
            }
        }

        private boolean shouldKeepWaitingForQuietPeriod(long lastChangeAtValue) {
            long now = DefaultFileSystemChangeWaiterFactory.monotonicClockMillis();
            return lastChangeAtValue == 0L || now < lastChangeAtValue || now - lastChangeAtValue < this.quietPeriodMillis;
        }

        public boolean isWatching() {
            return this.watching;
        }

        public void stop() {
            this.watcher.stop();
        }
    }
}

