/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.typeconversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.testkit.jarjar.org.gradle.api.specs.Spec;
import org.gradle.testkit.jarjar.org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.testkit.jarjar.org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.testkit.jarjar.org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.testkit.jarjar.org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.testkit.jarjar.org.gradle.util.CollectionUtils;
import org.gradle.testkit.jarjar.org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFromCharSequenceNotationParser<T extends Enum>
implements NotationConverter<CharSequence, T> {
    private final Class<? extends T> type;

    public EnumFromCharSequenceNotationParser(Class<? extends T> enumType) {
        assert (enumType.isEnum()) : "resultingType must be enum";
        this.type = enumType;
    }

    @Override
    public void convert(CharSequence notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        final String enumString = notation.toString();
        List<T> enumConstants = Arrays.asList(this.type.getEnumConstants());
        Enum match = (Enum)CollectionUtils.findFirst(enumConstants, new Spec<T>(){

            @Override
            public boolean isSatisfiedBy(T enumValue) {
                return ((Enum)enumValue).name().equalsIgnoreCase(enumString);
            }
        });
        if (match == null) {
            throw new TypeConversionException(String.format("Cannot convert string value '%s' to an enum value of type '%s' (valid case insensitive values: %s)", enumString, this.type.getName(), CollectionUtils.toStringList(Arrays.asList(this.type.getEnumConstants()))));
        }
        result.converted(match);
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        Enum[] enumConstants;
        ArrayList<String> values = new ArrayList<String>();
        for (Enum enumConstant : enumConstants = (Enum[])this.type.getEnumConstants()) {
            values.add(enumConstant.name());
        }
        visitor.candidate(String.format("One of the following values: %s", GUtil.toString(values)));
        visitor.values(values);
    }
}

