/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.rhino.worker;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.GFileUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RhinoWorkerUtils {
    public static String readFile(File file, String encoding) {
        return GFileUtils.readFile((File)file, (String)encoding);
    }

    public static void writeFile(String content, File destination, String encoding) {
        GFileUtils.writeFile((String)content, (File)destination, (String)encoding);
    }

    public static Scriptable parse(File source, String encoding) {
        return RhinoWorkerUtils.parse(source, encoding, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseRhino(File rhinoScript, ScopeOperation<T> operation) {
        Context context = Context.enter();
        try {
            operation.initContext(context);
            ScriptableObject scope = context.initStandardObjects();
            String printFunction = "function print(message) {}";
            context.evaluateString((Scriptable)scope, printFunction, "print", 1, null);
            context.evaluateString((Scriptable)scope, RhinoWorkerUtils.readFile(rhinoScript, "UTF-8"), rhinoScript.getName(), 1, null);
            T t = operation.action((Scriptable)scope, context);
            return t;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scriptable parse(File source, String encoding, Action<Context> contextConfig) {
        Context context = Context.enter();
        if (contextConfig != null) {
            contextConfig.execute((Object)context);
        }
        ScriptableObject scope = context.initStandardObjects();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(source), encoding);
            try {
                context.evaluateReader((Scriptable)scope, (Reader)reader, source.getName(), 0, null);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            Context.exit();
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R childScope(Scriptable parentScope, ScopeOperation<R> operation) {
        Context context = Context.enter();
        try {
            operation.initContext(context);
            Scriptable childScope = context.newObject(parentScope);
            childScope.setParentScope(parentScope);
            R r = operation.action(childScope, context);
            return r;
        }
        finally {
            Context.exit();
        }
    }

    public static Map<String, Object> toMap(Scriptable obj) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Object id : obj.getIds()) {
            Object value;
            String key;
            if (id instanceof String) {
                key = (String)id;
                value = obj.get(key, obj);
            } else if (id instanceof Integer) {
                key = id.toString();
                value = obj.get(((Integer)id).intValue(), obj);
            } else {
                throw new IllegalArgumentException(String.format("Unexpected key type: %s (value: %s)", id.getClass().getName(), id));
            }
            map.put(key, RhinoWorkerUtils.toJavaValue(value));
        }
        return map;
    }

    public static Object toJavaValue(Object object) {
        if (object == null || object.equals(Context.getUndefinedValue())) {
            return null;
        }
        if (object.getClass().getPackage().getName().startsWith("java.")) {
            return object;
        }
        if (object instanceof FunctionObject) {
            throw new IllegalArgumentException(String.format("Cannot convert function object to value (object: %s)", object));
        }
        if (object instanceof Scriptable) {
            return RhinoWorkerUtils.toMap((Scriptable)object);
        }
        throw new IllegalArgumentException(String.format("Can't convert JS object %s (type: %s) to native Java object", object, object.getClass().getName()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultScopeOperation<T>
    implements ScopeOperation<T> {
        @Override
        public void initContext(Context context) {
        }

        @Override
        public T action(Scriptable scope, Context context) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ScopeOperation<T> {
        public void initContext(Context var1);

        public T action(Scriptable var1, Context var2);
    }
}

