/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.plugins;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JvmByteCode;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.WithJvmAssembly;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.JointCompileTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.jvm.plugins.JvmResourcesPlugin;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.language.scala.internal.DefaultScalaLanguageSourceSet;
import org.gradle.language.scala.internal.DefaultScalaPlatform;
import org.gradle.language.scala.internal.ScalaJvmAssembly;
import org.gradle.language.scala.tasks.PlatformScalaCompile;
import org.gradle.language.scala.toolchain.ScalaToolChain;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class ScalaLanguagePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
        project.getPluginManager().apply(JvmResourcesPlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Scala
    implements LanguageTransform<ScalaLanguageSourceSet, JvmByteCode> {
        private Scala() {
        }

        public Class<ScalaLanguageSourceSet> getSourceSetType() {
            return ScalaLanguageSourceSet.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public Class<JvmByteCode> getOutputType() {
            return JvmByteCode.class;
        }

        public JointCompileTaskConfig getTransformTask() {
            return new JointCompileTaskConfig(){

                public String getTaskPrefix() {
                    return "compile";
                }

                public boolean canTransform(LanguageSourceSet candidate) {
                    return candidate instanceof ScalaLanguageSourceSet || candidate instanceof JavaSourceSet;
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return PlatformScalaCompile.class;
                }

                public void configureTask(Task task, BinarySpec binarySpec, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
                    PlatformScalaCompile compile = (PlatformScalaCompile)task;
                    this.configureScalaTask(compile, ((WithJvmAssembly)binarySpec).getAssembly(), String.format("Compiles %s.", sourceSet));
                    this.addSourceSetToCompile(compile, sourceSet);
                    this.addSourceSetClasspath(compile, (ScalaLanguageSourceSet)sourceSet);
                }

                public void configureAdditionalTransform(Task task, LanguageSourceSet sourceSet) {
                    PlatformScalaCompile compile = (PlatformScalaCompile)task;
                    this.addSourceSetToCompile(compile, sourceSet);
                }

                private void configureScalaTask(PlatformScalaCompile compile, JvmAssembly assembly, String description) {
                    assembly.builtBy(new Object[]{compile});
                    compile.setDescription(description);
                    compile.setDestinationDir((File)CollectionUtils.single((Iterable)assembly.getClassDirectories()));
                    File analysisFile = new File(compile.getProject().getBuildDir(), String.format("tmp/scala/compilerAnalysis/%s.analysis", compile.getName()));
                    compile.getScalaCompileOptions().getIncrementalOptions().setAnalysisFile(analysisFile);
                    JavaPlatform javaPlatform = assembly.getTargetPlatform();
                    String targetCompatibility = javaPlatform.getTargetCompatibility().toString();
                    compile.setTargetCompatibility(targetCompatibility);
                    compile.setSourceCompatibility(targetCompatibility);
                    if (assembly instanceof ScalaJvmAssembly) {
                        compile.setPlatform(((ScalaJvmAssembly)assembly).getScalaPlatform());
                    } else {
                        compile.setPlatform(new DefaultScalaPlatform("2.10.4"));
                    }
                }

                private void addSourceSetToCompile(PlatformScalaCompile compile, LanguageSourceSet sourceSet) {
                    compile.dependsOn(new Object[]{sourceSet});
                    compile.source(new Object[]{sourceSet.getSource()});
                }

                private void addSourceSetClasspath(PlatformScalaCompile compile, ScalaLanguageSourceSet scalaLanguageSourceSet) {
                    FileCollection classpath = scalaLanguageSourceSet.getCompileClasspath().getFiles();
                    compile.setClasspath(classpath);
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof WithJvmAssembly;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        ScalaToolChain scalaToolChain(ServiceRegistry serviceRegistry) {
            return (ScalaToolChain)serviceRegistry.get(ScalaToolChain.class);
        }

        @LanguageType
        void registerLanguage(LanguageTypeBuilder<ScalaLanguageSourceSet> builder) {
            builder.setLanguageName("scala");
            builder.defaultImplementation(DefaultScalaLanguageSourceSet.class);
        }

        @Mutate
        void registerLanguageTransform(LanguageTransformContainer languages, ServiceRegistry serviceRegistry) {
            languages.add((Object)new Scala());
        }
    }
}

