/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class MemoryTileCache
implements TileCache {
    protected static final Logger log = Logger.getLogger(MemoryTileCache.class.getName());
    protected int cacheSize;
    protected final Map<String, CacheEntry> hash;
    protected final CacheLinkedListElement lruTiles;

    public MemoryTileCache() {
        this(200);
    }

    public MemoryTileCache(int n) {
        this.cacheSize = n;
        this.hash = new HashMap<String, CacheEntry>(n);
        this.lruTiles = new CacheLinkedListElement();
    }

    @Override
    public synchronized void addTile(Tile tile) {
        CacheEntry cacheEntry = this.createCacheEntry(tile);
        if (this.hash.put(tile.getKey(), cacheEntry) == null) {
            this.lruTiles.addFirst(cacheEntry);
            if (this.hash.size() > this.cacheSize || this.lruTiles.getElementCount() > this.cacheSize) {
                this.removeOldEntries();
            }
        }
    }

    @Override
    public synchronized Tile getTile(TileSource tileSource, int n, int n2, int n3) {
        CacheEntry cacheEntry = this.hash.get(Tile.getTileKey(tileSource, n, n2, n3));
        if (cacheEntry == null) {
            return null;
        }
        this.lruTiles.moveElementToFirstPos(cacheEntry);
        return cacheEntry.tile;
    }

    protected synchronized void removeOldEntries() {
        try {
            while (this.lruTiles.getElementCount() > this.cacheSize) {
                this.removeEntry(this.lruTiles.getLastElement());
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
    }

    protected synchronized void removeEntry(CacheEntry cacheEntry) {
        this.hash.remove(cacheEntry.tile.getKey());
        this.lruTiles.removeEntry(cacheEntry);
    }

    protected CacheEntry createCacheEntry(Tile tile) {
        return new CacheEntry(tile);
    }

    @Override
    public synchronized void clear() {
        this.hash.clear();
        this.lruTiles.clear();
    }

    @Override
    public synchronized int getTileCount() {
        return this.hash.size();
    }

    @Override
    public synchronized int getCacheSize() {
        return this.cacheSize;
    }

    public synchronized void setCacheSize(int n) {
        this.cacheSize = n;
        if (this.hash.size() > n) {
            this.removeOldEntries();
        }
    }

    protected static class CacheLinkedListElement {
        protected CacheEntry firstElement;
        protected CacheEntry lastElement;
        protected int elementCount;

        public CacheLinkedListElement() {
            this.clear();
        }

        public void clear() {
            this.elementCount = 0;
            this.firstElement = null;
            this.lastElement = null;
        }

        public void addFirst(CacheEntry cacheEntry) {
            if (cacheEntry == null) {
                return;
            }
            if (this.elementCount == 0) {
                this.firstElement = cacheEntry;
                this.lastElement = cacheEntry;
                cacheEntry.prev = null;
                cacheEntry.next = null;
            } else {
                cacheEntry.next = this.firstElement;
                this.firstElement.prev = cacheEntry;
                cacheEntry.prev = null;
                this.firstElement = cacheEntry;
            }
            ++this.elementCount;
        }

        public void removeEntry(CacheEntry cacheEntry) {
            if (cacheEntry == null) {
                return;
            }
            if (cacheEntry.next != null) {
                cacheEntry.next.prev = cacheEntry.prev;
            }
            if (cacheEntry.prev != null) {
                cacheEntry.prev.next = cacheEntry.next;
            }
            if (cacheEntry == this.firstElement) {
                this.firstElement = cacheEntry.next;
            }
            if (cacheEntry == this.lastElement) {
                this.lastElement = cacheEntry.prev;
            }
            cacheEntry.next = null;
            cacheEntry.prev = null;
            --this.elementCount;
        }

        public void moveElementToFirstPos(CacheEntry cacheEntry) {
            if (this.firstElement == cacheEntry) {
                return;
            }
            this.removeEntry(cacheEntry);
            this.addFirst(cacheEntry);
        }

        public int getElementCount() {
            return this.elementCount;
        }

        public CacheEntry getLastElement() {
            return this.lastElement;
        }

        public CacheEntry getFirstElement() {
            return this.firstElement;
        }
    }

    protected static class CacheEntry {
        private Tile tile;
        private CacheEntry next;
        private CacheEntry prev;

        protected CacheEntry(Tile tile) {
            this.tile = tile;
        }
    }
}

