/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AutoScaleAction
extends JosmAction {
    public static final Collection<String> MODES = Collections.unmodifiableList(Arrays.asList(I18n.marktr("data"), I18n.marktr("layer"), I18n.marktr("selection"), I18n.marktr("conflict"), I18n.marktr("download"), I18n.marktr("problem"), I18n.marktr("previous"), I18n.marktr("next")));
    private final String mode;
    protected long lastZoomTime = -1L;
    protected int lastZoomArea = -1;

    public static void zoomToSelection() {
        if (Main.main == null || !Main.main.hasEditLayer()) {
            return;
        }
        Collection<OsmPrimitive> collection = Main.main.getEditLayer().data.getSelected();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing selected to zoom to.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        AutoScaleAction.zoomTo(collection);
    }

    public static void zoomTo(Collection<OsmPrimitive> collection) {
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        boundingXYVisitor.computeBoundingBox(collection);
        boundingXYVisitor.enlargeBoundingBox();
        if (boundingXYVisitor.getBounds() != null) {
            Main.map.mapView.zoomTo(boundingXYVisitor);
        }
    }

    public static void autoScale(String string) {
        new AutoScaleAction(string, false).autoScale();
    }

    private static int getModeShortcut(String string) {
        int n = -1;
        if (string.equals("data")) {
            n = 49;
        } else if (string.equals("layer")) {
            n = 50;
        } else if (string.equals("selection")) {
            n = 51;
        } else if (string.equals("conflict")) {
            n = 52;
        } else if (string.equals("download")) {
            n = 53;
        } else if (string.equals("problem")) {
            n = 54;
        } else if (string.equals("previous")) {
            n = 56;
        } else if (string.equals("next")) {
            n = 57;
        }
        return n;
    }

    private AutoScaleAction(String string, boolean bl) {
        super(false);
        this.mode = string;
    }

    public AutoScaleAction(String string) {
        super(I18n.tr("Zoom to {0}", I18n.tr(string, new Object[0])), "dialogs/autoscale/" + string, I18n.tr("Zoom the view to {0}.", I18n.tr(string, new Object[0])), Shortcut.registerShortcut("view:zoom" + string, I18n.tr("View: {0}", I18n.tr("Zoom to {0}", I18n.tr(string, new Object[0]))), AutoScaleAction.getModeShortcut(string), 5003), true, null, false);
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        this.putValue("help", "Action/AutoScale/" + string2);
        this.mode = string;
        switch (string) {
            case "data": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToData"));
                break;
            }
            case "layer": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToLayer"));
                break;
            }
            case "selection": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToSelection"));
                break;
            }
            case "conflict": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToConflict"));
                break;
            }
            case "problem": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToProblem"));
                break;
            }
            case "download": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToDownload"));
                break;
            }
            case "previous": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToPrevious"));
                break;
            }
            case "next": {
                this.putValue("help", HelpUtil.ht("/Action/ZoomToNext"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + string);
            }
        }
        this.installAdapters();
    }

    public void autoScale() {
        if (Main.isDisplayingMapView()) {
            switch (this.mode) {
                case "previous": {
                    Main.map.mapView.zoomPrevious();
                    break;
                }
                case "next": {
                    Main.map.mapView.zoomNext();
                    break;
                }
                default: {
                    BoundingXYVisitor boundingXYVisitor = this.getBoundingBox();
                    if (boundingXYVisitor == null || boundingXYVisitor.getBounds() == null) break;
                    Main.map.mapView.zoomTo(boundingXYVisitor);
                }
            }
        }
        this.putValue("active", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.autoScale();
    }

    protected Layer getFirstSelectedLayer() {
        if (Main.main.getActiveLayer() == null) {
            return null;
        }
        List<Layer> list = LayerListDialog.getInstance().getModel().getSelectedLayers();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private BoundingXYVisitor getBoundingBox() {
        BoundingXYVisitor boundingXYVisitor = "problem".equals(this.mode) ? new ValidatorDialog.ValidatorBoundingXYVisitor() : new BoundingXYVisitor();
        switch (this.mode) {
            case "problem": {
                TestError testError = Main.map.validatorDialog.getSelectedError();
                if (testError == null) {
                    return null;
                }
                ((ValidatorDialog.ValidatorBoundingXYVisitor)boundingXYVisitor).visit(testError);
                if (boundingXYVisitor.getBounds() == null) {
                    return null;
                }
                boundingXYVisitor.enlargeBoundingBox(Main.pref.getDouble("validator.zoom-enlarge-bbox", 2.0E-4));
                break;
            }
            case "data": {
                for (Layer layer : Main.map.mapView.getAllLayers()) {
                    layer.visitBoundingBox(boundingXYVisitor);
                }
                break;
            }
            case "layer": {
                Layer layer = this.getFirstSelectedLayer();
                if (layer == null) {
                    return null;
                }
                layer.visitBoundingBox(boundingXYVisitor);
                break;
            }
            case "selection": 
            case "conflict": {
                Collection<Object> collection = new HashSet();
                if ("selection".equals(this.mode)) {
                    collection = AutoScaleAction.getCurrentDataSet().getSelected();
                } else {
                    Conflict<? extends OsmPrimitive> conflict = Main.map.conflictDialog.getSelectedConflict();
                    if (conflict != null) {
                        collection.add(conflict.getMy());
                    } else if (Main.map.conflictDialog.getConflicts() != null) {
                        collection = Main.map.conflictDialog.getConflicts().getMyConflictParties();
                    }
                }
                if (collection.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, "selection".equals(this.mode) ? I18n.tr("Nothing selected to zoom to.", new Object[0]) : I18n.tr("No conflicts to zoom to", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    return null;
                }
                for (OsmPrimitive osmPrimitive : collection) {
                    osmPrimitive.accept(boundingXYVisitor);
                }
                boundingXYVisitor.enlargeBoundingBoxLogarithmically(100.0);
                boundingXYVisitor.enlargeToMinSize(Main.pref.getDouble("zoom_to_selection_min_size_in_meter", 100.0));
                break;
            }
            case "download": {
                DataSet dataSet;
                if (this.lastZoomTime > 0L && System.currentTimeMillis() - this.lastZoomTime > Main.pref.getLong("zoom.bounds.reset.time", 10000L)) {
                    this.lastZoomTime = -1L;
                }
                if ((dataSet = AutoScaleAction.getCurrentDataSet()) == null) break;
                ArrayList<DataSource> arrayList = new ArrayList<DataSource>(dataSet.getDataSources());
                int n = arrayList.size();
                if (n > 0) {
                    if (this.lastZoomTime == -1L || this.lastZoomArea == -1 || this.lastZoomArea > n) {
                        this.lastZoomArea = n - 1;
                        boundingXYVisitor.visit(((DataSource)arrayList.get((int)this.lastZoomArea)).bounds);
                    } else if (this.lastZoomArea > 0) {
                        --this.lastZoomArea;
                        boundingXYVisitor.visit(((DataSource)arrayList.get((int)this.lastZoomArea)).bounds);
                    } else {
                        this.lastZoomArea = -1;
                        boundingXYVisitor.visit(new Bounds(Main.main.getCurrentDataSet().getDataSourceArea().getBounds2D()));
                    }
                    this.lastZoomTime = System.currentTimeMillis();
                    break;
                }
                this.lastZoomTime = -1L;
                this.lastZoomArea = -1;
            }
        }
        return boundingXYVisitor;
    }

    @Override
    protected void updateEnabledState() {
        switch (this.mode) {
            case "selection": {
                this.setEnabled(AutoScaleAction.getCurrentDataSet() != null && !AutoScaleAction.getCurrentDataSet().getSelected().isEmpty());
                break;
            }
            case "layer": {
                this.setEnabled(this.getFirstSelectedLayer() != null);
                break;
            }
            case "conflict": {
                this.setEnabled(Main.map != null && Main.map.conflictDialog.getSelectedConflict() != null);
                break;
            }
            case "download": {
                this.setEnabled(AutoScaleAction.getCurrentDataSet() != null && !AutoScaleAction.getCurrentDataSet().getDataSources().isEmpty());
                break;
            }
            case "problem": {
                this.setEnabled(Main.map != null && Main.map.validatorDialog.getSelectedError() != null);
                break;
            }
            case "previous": {
                this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasZoomUndoEntries());
                break;
            }
            case "next": {
                this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasZoomRedoEntries());
                break;
            }
            default: {
                this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasLayers());
            }
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if ("selection".equals(this.mode)) {
            this.setEnabled(collection != null && !collection.isEmpty());
        }
    }

    @Override
    protected final void installAdapters() {
        super.installAdapters();
        MapView.addZoomChangeListener(new ZoomChangeAdapter());
        Main.addMapFrameListener(new MapFrameAdapter());
        this.initEnabledState();
    }

    private class MapFrameAdapter
    implements MapFrameListener {
        private ListSelectionListener conflictSelectionListener;
        private TreeSelectionListener validatorSelectionListener;

        MapFrameAdapter() {
            if ("conflict".equals(AutoScaleAction.this.mode)) {
                this.conflictSelectionListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        AutoScaleAction.this.updateEnabledState();
                    }
                };
            } else if ("problem".equals(AutoScaleAction.this.mode)) {
                this.validatorSelectionListener = new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        AutoScaleAction.this.updateEnabledState();
                    }
                };
            }
        }

        @Override
        public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
            if (this.conflictSelectionListener != null) {
                if (mapFrame2 != null) {
                    mapFrame2.conflictDialog.addListSelectionListener(this.conflictSelectionListener);
                } else if (mapFrame != null) {
                    mapFrame.conflictDialog.removeListSelectionListener(this.conflictSelectionListener);
                }
            } else if (this.validatorSelectionListener != null) {
                if (mapFrame2 != null) {
                    mapFrame2.validatorDialog.addTreeSelectionListener(this.validatorSelectionListener);
                } else if (mapFrame != null) {
                    mapFrame.validatorDialog.removeTreeSelectionListener(this.validatorSelectionListener);
                }
            }
            AutoScaleAction.this.updateEnabledState();
        }
    }

    private class ZoomChangeAdapter
    implements NavigatableComponent.ZoomChangeListener {
        private ZoomChangeAdapter() {
        }

        @Override
        public void zoomChanged() {
            AutoScaleAction.this.updateEnabledState();
        }
    }
}

