/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;

public class SelectionTable
extends JTable {
    private final SelectionTableModel model;
    private MemberTableModel memberTableModel;

    protected void build() {
        this.setSelectionMode(0);
        this.addMouseListener(new DoubleClickAdapter());
    }

    public SelectionTable(SelectionTableModel selectionTableModel, SelectionTableColumnModel selectionTableColumnModel) {
        super(selectionTableModel, selectionTableColumnModel);
        this.model = selectionTableModel;
        this.build();
    }

    public void setMemberTableModel(MemberTableModel memberTableModel) {
        this.memberTableModel = memberTableModel;
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() <= 1) {
                return;
            }
            int n = SelectionTable.this.rowAtPoint(mouseEvent.getPoint());
            OsmPrimitive osmPrimitive = SelectionTable.this.model.getPrimitive(n);
            SelectionTable.this.memberTableModel.selectMembersReferringTo(Collections.singleton(osmPrimitive));
        }
    }
}

