/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.PleaseWaitDialog;
import org.openstreetmap.josm.gui.progress.AbstractProgressMonitor;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ProgressException;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;

public class PleaseWaitProgressMonitor
extends AbstractProgressMonitor {
    public static final int PROGRESS_BAR_MAX = 10000;
    private final Component dialogParent;
    private int currentProgressValue;
    private String customText;
    private String title;
    private boolean indeterminate;
    private boolean isInBackground;
    private PleaseWaitDialog dialog;
    private String windowTitle;
    protected ProgressTaskId taskId;
    private boolean cancelable;
    private final ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PleaseWaitProgressMonitor.this.cancel();
        }
    };
    private final ActionListener inBackgroundListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PleaseWaitProgressMonitor.this.isInBackground = true;
            ProgressMonitorDialog progressMonitorDialog = PleaseWaitProgressMonitor.this.getDialog();
            if (progressMonitorDialog != null) {
                PleaseWaitProgressMonitor.this.reset();
                progressMonitorDialog.setVisible(true);
            }
        }
    };
    private final WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            PleaseWaitProgressMonitor.this.cancel();
        }
    };

    private static void doInEDT(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    private void setDialogVisible(boolean bl) {
        if (this.dialog.isVisible() != bl) {
            this.dialog.setVisible(bl);
        }
    }

    private ProgressMonitorDialog getDialog() {
        MapStatus.BackgroundProgressMonitor backgroundProgressMonitor = null;
        MapFrame mapFrame = Main.map;
        if (mapFrame != null) {
            backgroundProgressMonitor = mapFrame.statusLine.progressMonitor;
        }
        if (backgroundProgressMonitor != null) {
            backgroundProgressMonitor.setVisible(this.isInBackground);
        }
        if (this.dialog != null) {
            this.setDialogVisible(!this.isInBackground || backgroundProgressMonitor == null);
        }
        if (this.isInBackground && backgroundProgressMonitor != null) {
            backgroundProgressMonitor.setVisible(true);
            if (this.dialog != null) {
                this.setDialogVisible(false);
            }
            return backgroundProgressMonitor;
        }
        if (backgroundProgressMonitor != null) {
            backgroundProgressMonitor.setVisible(false);
            if (this.dialog != null) {
                this.setDialogVisible(true);
            }
            return this.dialog;
        }
        if (this.dialog != null) {
            this.setDialogVisible(true);
            return this.dialog;
        }
        return null;
    }

    public PleaseWaitProgressMonitor() {
        this("");
    }

    public PleaseWaitProgressMonitor(String string) {
        this(Main.parent);
        this.windowTitle = string;
    }

    public PleaseWaitProgressMonitor(Component component) {
        super(new CancelHandler());
        this.dialogParent = GraphicsEnvironment.isHeadless() ? component : JOptionPane.getFrameForComponent(component);
        this.cancelable = true;
    }

    public PleaseWaitProgressMonitor(Component component, String string) {
        this(JOptionPane.getFrameForComponent(component));
        this.windowTitle = string;
    }

    public final boolean isCancelable() {
        return this.cancelable;
    }

    public final void setCancelable(boolean bl) {
        this.cancelable = bl;
    }

    @Override
    public void doBeginTask() {
        PleaseWaitProgressMonitor.doInEDT(new Runnable(){

            @Override
            public void run() {
                Main.currentProgressMonitor = PleaseWaitProgressMonitor.this;
                if (GraphicsEnvironment.isHeadless()) {
                    return;
                }
                if (PleaseWaitProgressMonitor.this.dialogParent == null || PleaseWaitProgressMonitor.this.dialog != null) {
                    throw new ProgressException("PleaseWaitDialog parent must be set", new Object[0]);
                }
                PleaseWaitProgressMonitor.this.dialog = new PleaseWaitDialog(PleaseWaitProgressMonitor.this.dialogParent);
                if (PleaseWaitProgressMonitor.this.windowTitle != null) {
                    PleaseWaitProgressMonitor.this.dialog.setTitle(PleaseWaitProgressMonitor.this.windowTitle);
                }
                PleaseWaitProgressMonitor.this.dialog.setCancelEnabled(PleaseWaitProgressMonitor.this.cancelable);
                PleaseWaitProgressMonitor.this.dialog.setCancelCallback(PleaseWaitProgressMonitor.this.cancelListener);
                PleaseWaitProgressMonitor.this.dialog.setInBackgroundCallback(PleaseWaitProgressMonitor.this.inBackgroundListener);
                PleaseWaitProgressMonitor.this.dialog.setCustomText("");
                PleaseWaitProgressMonitor.this.dialog.addWindowListener(PleaseWaitProgressMonitor.this.windowListener);
                ((PleaseWaitProgressMonitor)PleaseWaitProgressMonitor.this).dialog.progress.setMaximum(10000);
                PleaseWaitProgressMonitor.this.dialog.setVisible(true);
            }
        });
    }

    @Override
    public void doFinishTask() {
    }

    @Override
    protected void updateProgress(double d) {
        int n = (int)(d * 10000.0);
        if (n != this.currentProgressValue) {
            this.currentProgressValue = n;
            PleaseWaitProgressMonitor.doInEDT(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorDialog progressMonitorDialog = PleaseWaitProgressMonitor.this.getDialog();
                    if (progressMonitorDialog != null) {
                        progressMonitorDialog.updateProgress(PleaseWaitProgressMonitor.this.currentProgressValue);
                    }
                }
            });
        }
    }

    @Override
    protected void doSetCustomText(final String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.customText = string;
        PleaseWaitProgressMonitor.doInEDT(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progressMonitorDialog = PleaseWaitProgressMonitor.this.getDialog();
                if (progressMonitorDialog != null) {
                    progressMonitorDialog.setCustomText(string);
                }
            }
        });
    }

    @Override
    protected void doSetTitle(final String string) {
        this.checkState(AbstractProgressMonitor.State.IN_TASK, AbstractProgressMonitor.State.IN_SUBTASK);
        this.title = string;
        PleaseWaitProgressMonitor.doInEDT(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progressMonitorDialog = PleaseWaitProgressMonitor.this.getDialog();
                if (progressMonitorDialog != null) {
                    progressMonitorDialog.setCurrentAction(string);
                }
            }
        });
    }

    @Override
    protected void doSetIntermediate(final boolean bl) {
        this.indeterminate = bl;
        PleaseWaitProgressMonitor.doInEDT(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progressMonitorDialog = PleaseWaitProgressMonitor.this.getDialog();
                if (progressMonitorDialog != null) {
                    progressMonitorDialog.setIndeterminate(bl && PleaseWaitProgressMonitor.this.currentProgressValue == 0);
                }
            }
        });
    }

    @Override
    public void appendLogMessage(final String string) {
        PleaseWaitProgressMonitor.doInEDT(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progressMonitorDialog = PleaseWaitProgressMonitor.this.getDialog();
                if (progressMonitorDialog != null) {
                    progressMonitorDialog.appendLogMessage(string);
                }
            }
        });
    }

    public void reset() {
        if (this.dialog != null) {
            this.dialog.setTitle(this.title);
            this.dialog.setCustomText(this.customText);
            this.dialog.updateProgress(this.currentProgressValue);
            this.dialog.setIndeterminate(this.indeterminate && this.currentProgressValue == 0);
        }
        MapStatus.BackgroundProgressMonitor backgroundProgressMonitor = null;
        MapFrame mapFrame = Main.map;
        if (mapFrame != null) {
            backgroundProgressMonitor = mapFrame.statusLine.progressMonitor;
        }
        if (backgroundProgressMonitor != null) {
            backgroundProgressMonitor.setCurrentAction(this.title);
            backgroundProgressMonitor.setCustomText(this.customText);
            backgroundProgressMonitor.updateProgress(this.currentProgressValue);
            backgroundProgressMonitor.setIndeterminate(this.indeterminate && this.currentProgressValue == 0);
        }
    }

    public void close() {
        PleaseWaitProgressMonitor.doInEDT(new Runnable(){

            @Override
            public void run() {
                if (PleaseWaitProgressMonitor.this.dialog != null) {
                    PleaseWaitProgressMonitor.this.dialog.setVisible(false);
                    PleaseWaitProgressMonitor.this.dialog.setCancelCallback(null);
                    PleaseWaitProgressMonitor.this.dialog.setInBackgroundCallback(null);
                    PleaseWaitProgressMonitor.this.dialog.removeWindowListener(PleaseWaitProgressMonitor.this.windowListener);
                    PleaseWaitProgressMonitor.this.dialog.dispose();
                    PleaseWaitProgressMonitor.this.dialog = null;
                    Main.currentProgressMonitor = null;
                    MapFrame mapFrame = Main.map;
                    if (mapFrame != null) {
                        mapFrame.statusLine.progressMonitor.setVisible(false);
                    }
                }
            }
        });
    }

    public void showForegroundDialog() {
        this.isInBackground = false;
        PleaseWaitProgressMonitor.doInEDT(new Runnable(){

            @Override
            public void run() {
                if (PleaseWaitProgressMonitor.this.dialog != null) {
                    PleaseWaitProgressMonitor.this.dialog.setInBackgroundPossible(PleaseWaitProgressMonitor.this.taskId != null && Main.isDisplayingMapView());
                    PleaseWaitProgressMonitor.this.reset();
                    PleaseWaitProgressMonitor.this.getDialog();
                }
            }
        });
    }

    @Override
    public void setProgressTaskId(ProgressTaskId progressTaskId) {
        this.taskId = progressTaskId;
        PleaseWaitProgressMonitor.doInEDT(new Runnable(){

            @Override
            public void run() {
                if (PleaseWaitProgressMonitor.this.dialog != null) {
                    PleaseWaitProgressMonitor.this.dialog.setInBackgroundPossible(PleaseWaitProgressMonitor.this.taskId != null && Main.isDisplayingMapView());
                }
            }
        });
    }

    @Override
    public ProgressTaskId getProgressTaskId() {
        return this.taskId;
    }

    @Override
    public Component getWindowParent() {
        PleaseWaitDialog pleaseWaitDialog = this.dialog;
        if (this.isInBackground || pleaseWaitDialog == null) {
            return Main.parent;
        }
        return pleaseWaitDialog;
    }

    public static interface ProgressMonitorDialog {
        public void setVisible(boolean var1);

        public void updateProgress(int var1);

        public void setCustomText(String var1);

        public void setCurrentAction(String var1);

        public void setIndeterminate(boolean var1);

        public void appendLogMessage(String var1);
    }
}

