/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.SearchTextResultListPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class TaggingPresetSelector
extends SearchTextResultListPanel<TaggingPreset>
implements SelectionChangedListener {
    private static final int CLASSIFICATION_IN_FAVORITES = 300;
    private static final int CLASSIFICATION_NAME_MATCH = 300;
    private static final int CLASSIFICATION_GROUP_MATCH = 200;
    private static final int CLASSIFICATION_TAGS_MATCH = 100;
    private static final BooleanProperty SEARCH_IN_TAGS = new BooleanProperty("taggingpreset.dialog.search-in-tags", true);
    private static final BooleanProperty ONLY_APPLICABLE = new BooleanProperty("taggingpreset.dialog.only-applicable-to-selection", true);
    private final JCheckBox ckOnlyApplicable;
    private final JCheckBox ckSearchInTags;
    private final Set<TaggingPresetType> typesInSelection = EnumSet.noneOf(TaggingPresetType.class);
    private boolean typesInSelectionDirty = true;
    private final transient PresetClassifications classifications = new PresetClassifications();

    public TaggingPresetSelector(boolean bl, boolean bl2) {
        this.lsResult.setCellRenderer(new ResultListCellRenderer());
        this.classifications.loadPresets(TaggingPresets.getTaggingPresets());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (bl) {
            this.ckOnlyApplicable = new JCheckBox();
            this.ckOnlyApplicable.setText(I18n.tr("Show only applicable to selection", new Object[0]));
            jPanel.add(this.ckOnlyApplicable);
            this.ckOnlyApplicable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    TaggingPresetSelector.this.filterItems();
                }
            });
        } else {
            this.ckOnlyApplicable = null;
        }
        if (bl2) {
            this.ckSearchInTags = new JCheckBox();
            this.ckSearchInTags.setText(I18n.tr("Search in tags", new Object[0]));
            this.ckSearchInTags.setSelected(SEARCH_IN_TAGS.get());
            this.ckSearchInTags.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    TaggingPresetSelector.this.filterItems();
                }
            });
            jPanel.add(this.ckSearchInTags);
        } else {
            this.ckSearchInTags = null;
        }
        this.add((Component)jPanel, "South");
        this.setPreferredSize(new Dimension(400, 300));
        this.filterItems();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new AbstractAction(I18n.tr("Add toolbar button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaggingPreset taggingPreset = TaggingPresetSelector.this.getSelectedPreset();
                if (taggingPreset != null) {
                    Main.toolbar.addCustomButton(taggingPreset.getToolbarString(), -1, false);
                }
            }
        });
        this.lsResult.addMouseListener(new PopupMenuLauncher(jPopupMenu));
    }

    @Override
    protected synchronized void filterItems() {
        String string = this.edSearchText.getText().toLowerCase(Locale.ENGLISH);
        boolean bl = this.ckOnlyApplicable != null && this.ckOnlyApplicable.isSelected();
        boolean bl2 = this.ckSearchInTags != null && this.ckSearchInTags.isSelected();
        DataSet dataSet = Main.main.getCurrentDataSet();
        Collection<Object> collection = dataSet == null ? Collections.emptyList() : dataSet.getSelected();
        List<PresetClassification> list = this.classifications.getMatchingPresets(string, bl, bl2, this.getTypesInSelection(), collection);
        TaggingPreset taggingPreset = this.getSelectedPreset();
        this.lsResultModel.setItems(Utils.transform(list, new Utils.Function<PresetClassification, TaggingPreset>(){

            @Override
            public TaggingPreset apply(PresetClassification presetClassification) {
                return presetClassification.preset;
            }
        }));
        TaggingPreset taggingPreset2 = this.getSelectedPreset();
        if (!Objects.equals(taggingPreset, taggingPreset2)) {
            int[] nArray = this.lsResult.getSelectedIndices();
            for (ListSelectionListener listSelectionListener : this.listSelectionListeners) {
                listSelectionListener.valueChanged(new ListSelectionEvent(this.lsResult, this.lsResult.getSelectedIndex(), nArray.length > 0 ? nArray[nArray.length - 1] : -1, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<TaggingPresetType> getTypesInSelection() {
        if (this.typesInSelectionDirty) {
            Set<TaggingPresetType> set = this.typesInSelection;
            synchronized (set) {
                this.typesInSelectionDirty = false;
                this.typesInSelection.clear();
                if (Main.main == null || Main.main.getCurrentDataSet() == null) {
                    return this.typesInSelection;
                }
                for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getSelected()) {
                    this.typesInSelection.add(TaggingPresetType.forPrimitive(osmPrimitive));
                }
            }
        }
        return this.typesInSelection;
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.typesInSelectionDirty = true;
    }

    @Override
    public synchronized void init() {
        if (this.ckOnlyApplicable != null) {
            this.ckOnlyApplicable.setEnabled(!this.getTypesInSelection().isEmpty());
            this.ckOnlyApplicable.setSelected(!this.getTypesInSelection().isEmpty() && ONLY_APPLICABLE.get() != false);
        }
        super.init();
    }

    public void init(Collection<TaggingPreset> collection) {
        this.classifications.clear();
        this.classifications.loadPresets(collection);
        this.init();
    }

    public void savePreferences() {
        if (this.ckSearchInTags != null) {
            SEARCH_IN_TAGS.put(this.ckSearchInTags.isSelected());
        }
        if (this.ckOnlyApplicable != null && this.ckOnlyApplicable.isEnabled()) {
            ONLY_APPLICABLE.put(this.ckOnlyApplicable.isSelected());
        }
    }

    public synchronized TaggingPreset getSelectedPreset() {
        if (this.lsResultModel.isEmpty()) {
            return null;
        }
        int n = this.lsResult.getSelectedIndex();
        if (n < 0 || n >= this.lsResultModel.getSize()) {
            n = 0;
        }
        return (TaggingPreset)this.lsResultModel.getElementAt(n);
    }

    public synchronized TaggingPreset getSelectedPresetAndUpdateClassification() {
        TaggingPreset taggingPreset = this.getSelectedPreset();
        for (PresetClassification presetClassification : this.classifications) {
            if (presetClassification.preset == taggingPreset) {
                presetClassification.favoriteIndex = 300;
                continue;
            }
            if (presetClassification.favoriteIndex <= 0) continue;
            --presetClassification.favoriteIndex;
        }
        return taggingPreset;
    }

    public synchronized void setSelectedPreset(TaggingPreset taggingPreset) {
        this.lsResult.setSelectedValue(taggingPreset, true);
    }

    public static class PresetClassifications
    implements Iterable<PresetClassification> {
        private final List<PresetClassification> classifications = new ArrayList<PresetClassification>();

        public List<PresetClassification> getMatchingPresets(String string, boolean bl, boolean bl2, Set<TaggingPresetType> set, Collection<? extends OsmPrimitive> collection) {
            String[] stringArray;
            String[] stringArray2;
            if (string.contains("/")) {
                stringArray2 = string.substring(0, string.lastIndexOf(47)).split("[\\s/]");
                stringArray = string.substring(string.indexOf(47) + 1).split("\\s");
            } else {
                stringArray2 = null;
                stringArray = string.split("\\s");
            }
            return this.getMatchingPresets(stringArray2, stringArray, bl, bl2, set, collection);
        }

        public List<PresetClassification> getMatchingPresets(String[] stringArray, String[] stringArray2, boolean bl, boolean bl2, Set<TaggingPresetType> set, final Collection<? extends OsmPrimitive> collection) {
            ArrayList<PresetClassification> arrayList = new ArrayList<PresetClassification>();
            for (PresetClassification presetClassification : this.classifications) {
                int n;
                TaggingPreset taggingPreset = presetClassification.preset;
                presetClassification.classification = 0;
                if (bl) {
                    n = taggingPreset.typeMatches(set);
                    if (n == 0 && taggingPreset.types.contains((Object)TaggingPresetType.RELATION) && taggingPreset.roles != null && !taggingPreset.roles.roles.isEmpty()) {
                        Predicate<Roles.Role> predicate = new Predicate<Roles.Role>(){

                            @Override
                            public boolean evaluate(Roles.Role role) {
                                return role.memberExpression != null && Utils.exists(collection, role.memberExpression);
                            }
                        };
                        n = Utils.exists(taggingPreset.roles.roles, predicate) ? 1 : 0;
                    }
                    if (n == 0) continue;
                }
                if (stringArray != null && presetClassification.isMatchingGroup(stringArray) == 0) continue;
                n = presetClassification.isMatchingName(stringArray2);
                if (n == 0) {
                    int n2;
                    int n3;
                    if (stringArray == null && (n3 = presetClassification.isMatchingGroup(stringArray2)) > 0) {
                        presetClassification.classification = 200 + n3;
                    }
                    if (presetClassification.classification == 0 && bl2 && (n2 = presetClassification.isMatchingTags(stringArray2)) > 0) {
                        presetClassification.classification = 100 + n2;
                    }
                } else {
                    presetClassification.classification = 300 + n;
                }
                if (presetClassification.classification <= 0) continue;
                presetClassification.classification += presetClassification.favoriteIndex;
                arrayList.add(presetClassification);
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        public void clear() {
            this.classifications.clear();
        }

        public void loadPresets(Collection<TaggingPreset> collection) {
            for (TaggingPreset taggingPreset : collection) {
                if (taggingPreset instanceof TaggingPresetSeparator || taggingPreset instanceof TaggingPresetMenu) continue;
                this.classifications.add(new PresetClassification(taggingPreset));
            }
        }

        @Override
        public Iterator<PresetClassification> iterator() {
            return this.classifications.iterator();
        }
    }

    public static class PresetClassification
    implements Comparable<PresetClassification> {
        public final TaggingPreset preset;
        public int classification;
        public int favoriteIndex;
        private final Collection<String> groups = new HashSet<String>();
        private final Collection<String> names = new HashSet<String>();
        private final Collection<String> tags = new HashSet<String>();

        PresetClassification(TaggingPreset taggingPreset) {
            this.preset = taggingPreset;
            TaggingPresetMenu taggingPresetMenu = taggingPreset.group;
            while (taggingPresetMenu != null) {
                Collections.addAll(this.groups, taggingPresetMenu.getLocaleName().toLowerCase(Locale.ENGLISH).split("\\s"));
                taggingPresetMenu = taggingPresetMenu.group;
            }
            Collections.addAll(this.names, taggingPreset.getLocaleName().toLowerCase(Locale.ENGLISH).split("\\s"));
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                if (taggingPresetItem instanceof KeyedItem) {
                    this.tags.add(((KeyedItem)taggingPresetItem).key);
                    if (taggingPresetItem instanceof ComboMultiSelect) {
                        ComboMultiSelect comboMultiSelect = (ComboMultiSelect)taggingPresetItem;
                        if (Boolean.parseBoolean(comboMultiSelect.values_searchable)) {
                            this.tags.addAll(comboMultiSelect.getDisplayValues());
                        }
                    }
                    if (!(taggingPresetItem instanceof Key) || ((Key)taggingPresetItem).value == null) continue;
                    this.tags.add(((Key)taggingPresetItem).value);
                    continue;
                }
                if (!(taggingPresetItem instanceof Roles)) continue;
                for (Roles.Role role : ((Roles)taggingPresetItem).roles) {
                    this.tags.add(role.key);
                }
            }
        }

        private static int isMatching(Collection<String> collection, String[] stringArray) {
            int n = 0;
            for (String string : stringArray) {
                boolean bl = false;
                boolean bl2 = false;
                for (String string2 : collection) {
                    int n2 = string2.toLowerCase(Locale.ENGLISH).indexOf(string);
                    if (n2 == 0) {
                        bl2 = true;
                        break;
                    }
                    if (n2 <= 0) continue;
                    bl = true;
                }
                if (bl2) {
                    n += 2;
                    continue;
                }
                if (bl) {
                    ++n;
                    continue;
                }
                return 0;
            }
            return n;
        }

        int isMatchingGroup(String[] stringArray) {
            return PresetClassification.isMatching(this.groups, stringArray);
        }

        int isMatchingName(String[] stringArray) {
            return PresetClassification.isMatching(this.names, stringArray);
        }

        int isMatchingTags(String[] stringArray) {
            return PresetClassification.isMatching(this.tags, stringArray);
        }

        @Override
        public int compareTo(PresetClassification presetClassification) {
            int n = presetClassification.classification - this.classification;
            if (n == 0) {
                return this.preset.getName().compareTo(presetClassification.preset.getName());
            }
            return n;
        }

        public String toString() {
            return this.classification + " " + this.preset;
        }
    }

    private static class ResultListCellRenderer
    implements ListCellRenderer<TaggingPreset> {
        private final DefaultListCellRenderer def = new DefaultListCellRenderer();

        private ResultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TaggingPreset> jList, TaggingPreset taggingPreset, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.def.getListCellRendererComponent(jList, taggingPreset, n, bl, bl2);
            jLabel.setText(taggingPreset.getName());
            jLabel.setIcon((Icon)taggingPreset.getValue("SmallIcon"));
            return jLabel;
        }
    }
}

