/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.instrument.ASTPrinter;
import com.oracle.truffle.api.instrument.Visualizer;
import com.oracle.truffle.api.instrument.impl.DefaultASTPrinter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;

public class DefaultVisualizer
implements Visualizer {
    private final ASTPrinter astPrinter = new DefaultASTPrinter();

    @Override
    public ASTPrinter getASTPrinter() {
        return this.astPrinter;
    }

    @Override
    public String displaySourceLocation(Node node) {
        if (node == null) {
            return "<unknown>";
        }
        SourceSection section = node.getSourceSection();
        boolean estimated = false;
        if (section == null) {
            section = node.getEncapsulatingSourceSection();
            estimated = true;
        }
        if (section == null) {
            return "<error: source location>";
        }
        return section.getShortDescription() + (estimated ? "~" : "");
    }

    @Override
    public String displayMethodName(Node node) {
        if (node == null) {
            return null;
        }
        RootNode root = node.getRootNode();
        if (root == null) {
            return "unknown";
        }
        return root.getCallTarget().toString();
    }

    @Override
    public String displayCallTargetName(CallTarget callTarget) {
        return callTarget.toString();
    }

    @Override
    public String displayValue(Object value, int trim) {
        if (value == null) {
            return "<empty>";
        }
        return this.trim(value.toString(), trim);
    }

    @Override
    public String displayIdentifier(FrameSlot slot) {
        return slot.getIdentifier().toString();
    }

    protected String trim(String text, int trim) {
        if (trim == 0) {
            return text;
        }
        String[] lines = text.split("\n");
        String result = lines[0];
        if (lines.length == 1) {
            if (result.length() <= trim) {
                return result;
            }
            if (trim <= 3) {
                return result.substring(0, Math.min(result.length() - 1, trim - 1));
            }
            return result.substring(0, trim - 4) + "...";
        }
        return (result.length() < trim - 3 ? result : result.substring(0, trim - 4)) + "...";
    }
}

