/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class ReadBlockNode
extends RubyNode {
    private final ConditionProfile hasBlockProfile = ConditionProfile.createBinaryProfile();
    private final Object valueIfAbsent;

    public ReadBlockNode(RubyContext context, SourceSection sourceSection, Object valueIfAbsent) {
        super(context, sourceSection);
        this.valueIfAbsent = valueIfAbsent;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject block = RubyArguments.getBlock(frame.getArguments());
        if (this.hasBlockProfile.profile(block != null)) {
            return block;
        }
        return this.valueIfAbsent;
    }
}

