/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.BreakID;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.BreakException;
import org.jruby.truffle.runtime.control.FrameOnStackMarker;
import org.jruby.truffle.runtime.control.RaiseException;

public class BreakNode
extends RubyNode {
    private final BreakID breakID;
    @Node.Child
    private RubyNode child;
    private final boolean ignoreMarker;

    public BreakNode(RubyContext context, SourceSection sourceSection, BreakID breakID, RubyNode child, boolean ignoreMarker) {
        super(context, sourceSection);
        this.breakID = breakID;
        this.child = child;
        this.ignoreMarker = ignoreMarker;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        FrameOnStackMarker marker;
        if (!this.ignoreMarker && (marker = RubyArguments.getFrameOnStackMarker(frame.getArguments())) != null && !marker.isOnStack()) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().localJumpError("break from proc-closure", this));
        }
        throw new BreakException(this.breakID, this.child.execute(frame));
    }
}

