/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.NodeArrayToObjectArrayNode;
import org.jruby.truffle.nodes.arguments.ReadAllArgumentsNode;
import org.jruby.truffle.nodes.arguments.ReadBlockNode;
import org.jruby.truffle.nodes.core.MethodNodesFactory;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.rubinius.CallRubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.ReturnID;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class RubiniusPrimitiveCallConstructor
implements RubiniusPrimitiveConstructor {
    private final DynamicObject method;

    public RubiniusPrimitiveCallConstructor(DynamicObject method) {
        assert (RubyGuards.isRubyMethod(method));
        this.method = method;
    }

    @Override
    public int getPrimitiveArity() {
        return Layouts.METHOD.getMethod(this.method).getSharedMethodInfo().getArity().getPreRequired();
    }

    @Override
    public RubyNode createCallPrimitiveNode(RubyContext context, SourceSection sourceSection, ReturnID returnID) {
        return new CallRubiniusPrimitiveNode(context, sourceSection, MethodNodesFactory.CallNodeFactory.create(context, sourceSection, new RubyNode[]{new LiteralNode(context, sourceSection, this.method), new ReadAllArgumentsNode(context, sourceSection), new ReadBlockNode(context, sourceSection, NotProvided.INSTANCE)}), returnID);
    }

    @Override
    public RubyNode createInvokePrimitiveNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
        return MethodNodesFactory.CallNodeFactory.create(context, sourceSection, new RubyNode[]{new LiteralNode(context, sourceSection, this.method), new NodeArrayToObjectArrayNode(context, sourceSection, arguments), new ReadBlockNode(context, sourceSection, NotProvided.INSTANCE)});
    }
}

