/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.io.wait;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap2) {
        RubyClass ioClass = runtime.getIO();
        ioClass.defineAnnotatedMethods(IOWaitLibrary.class);
    }

    @JRubyMethod
    public static IRubyObject nread(ThreadContext context, IRubyObject _io) {
        Ruby runtime = context.runtime;
        RubyIO io2 = (RubyIO)_io;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkReadable(context);
        int len = fptr.readPending();
        if (len > 0) {
            return runtime.newFixnum(len);
        }
        return RubyNumeric.int2fix(runtime, fptr.readyNow(context) ? 1L : 0L);
    }

    @JRubyMethod(name={"ready?"})
    public static IRubyObject ready(ThreadContext context, IRubyObject _io) {
        RubyIO io2 = (RubyIO)_io;
        Ruby runtime = context.runtime;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkReadable(context);
        if (fptr.readPending() != 0) {
            return runtime.getTrue();
        }
        return runtime.newBoolean(fptr.readyNow(context));
    }

    @JRubyMethod(name={"wait", "wait_readable"}, optional=1)
    public static IRubyObject wait_readable(ThreadContext context, IRubyObject _io, IRubyObject[] argv2) {
        long tv;
        IRubyObject timeout2;
        RubyIO io2 = (RubyIO)_io;
        Ruby runtime = context.runtime;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkReadable(context);
        switch (argv2.length) {
            case 1: {
                timeout2 = argv2[0];
                break;
            }
            default: {
                timeout2 = context.nil;
            }
        }
        if (timeout2.isNil()) {
            tv = -1L;
        } else {
            tv = timeout2.convertToInteger().getLongValue() * 1000L;
            if (tv < 0L) {
                throw runtime.newArgumentError("time interval must be positive");
            }
        }
        if (fptr.readPending() != 0) {
            return runtime.getTrue();
        }
        boolean ready2 = fptr.ready(runtime, context.getThread(), 1, tv);
        fptr.checkClosed();
        if (ready2) {
            return io2;
        }
        return context.nil;
    }

    @JRubyMethod(optional=1)
    public static IRubyObject wait_writable(ThreadContext context, IRubyObject _io, IRubyObject[] argv2) {
        long tv;
        IRubyObject timeout2;
        RubyIO io2 = (RubyIO)_io;
        Ruby runtime = context.runtime;
        OpenFile fptr = io2.getOpenFileChecked();
        fptr.checkWritable(context);
        switch (argv2.length) {
            case 1: {
                timeout2 = argv2[0];
                break;
            }
            default: {
                timeout2 = context.nil;
            }
        }
        if (timeout2.isNil()) {
            tv = -1L;
        } else {
            tv = timeout2.convertToInteger().getLongValue() * 1000L;
            if (tv < 0L) {
                throw runtime.newArgumentError("time interval must be positive");
            }
        }
        boolean ready2 = fptr.ready(runtime, context.getThread(), 4, tv);
        fptr.checkClosed();
        if (ready2) {
            return io2;
        }
        return context.nil;
    }
}

