/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ngrams;

import java.util.ArrayList;
import java.util.List;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tools.StringTools;

class GoogleToken {
    String token;
    int startPos;
    int endPos;

    GoogleToken(String token, int startPos, int endPos) {
        this.token = token;
        this.startPos = startPos;
        this.endPos = endPos;
    }

    boolean isWhitespace() {
        return StringTools.isWhitespace(this.token);
    }

    public String toString() {
        return this.token;
    }

    static List<GoogleToken> getGoogleTokens(String sentence, boolean addStartToken, Tokenizer wordTokenizer) {
        ArrayList<GoogleToken> result = new ArrayList<GoogleToken>();
        if (addStartToken) {
            result.add(new GoogleToken("_START_", 0, 0));
        }
        List<String> tokens = wordTokenizer.tokenize(sentence);
        int startPos = 0;
        for (String token : tokens) {
            if (!StringTools.isWhitespace(token)) {
                result.add(new GoogleToken(token, startPos, startPos + token.length()));
            }
            startPos += token.length();
        }
        return result;
    }
}

