/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

public class CodespaceRange {
    private byte[] start;
    private byte[] end;
    private int codeLength = 0;

    public int getCodeLength() {
        return this.codeLength;
    }

    public byte[] getEnd() {
        return this.end;
    }

    void setEnd(byte[] endBytes) {
        this.end = endBytes;
    }

    public byte[] getStart() {
        return this.start;
    }

    void setStart(byte[] startBytes) {
        this.start = startBytes;
        this.codeLength = this.start.length;
    }

    public boolean matches(byte[] code) {
        return this.isFullMatch(code, code.length);
    }

    public boolean isFullMatch(byte[] code, int codeLen) {
        if (codeLen == this.codeLength) {
            for (int i = 0; i < codeLen; ++i) {
                int startNum = this.start[i] & 0xFF;
                int codeNum = code[i] & 0xFF;
                int endNum = this.end[i] & 0xFF;
                if (codeNum <= endNum && codeNum >= startNum) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isPartialMatch(byte b, int index) {
        if (index == this.codeLength) {
            return false;
        }
        int startNum = this.start[index] & 0xFF;
        int codeNum = b & 0xFF;
        int endNum = this.end[index] & 0xFF;
        return codeNum <= endNum && codeNum >= startNum;
    }
}

