/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.community;

import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.PdfsamEdition;
import org.pdfsam.support.RequireUtils;
import org.springframework.core.env.Environment;

public class PdfsamCommunity
implements Pdfsam {
    private Environment env;
    private String name;
    private String shortName;

    public PdfsamCommunity(String name, String shortName, Environment env) {
        RequireUtils.requireNotBlank(name, "Application name cannot be blank");
        RequireUtils.requireNotBlank(shortName, "Application short name cannot be blank");
        RequireUtils.requireNotNull(env, "Environment cannot be null");
        this.env = env;
        this.name = name;
        this.shortName = shortName;
    }

    @Override
    public PdfsamEdition edition() {
        return PdfsamEdition.COMMUNITY;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String property(ConfigurableProperty prop, String defaultValue) {
        return this.env.getProperty(prop.prop, defaultValue);
    }

    @Override
    public String property(ConfigurableProperty prop) {
        return this.env.getProperty(prop.prop, "");
    }
}

