/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.news;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.news.NewsData;
import org.pdfsam.news.NewsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class DefaultNewsService
implements NewsService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNewsService.class);
    private static final String NEWS_PATH = "/org/pdfsam/user/news";
    private static final String LATEST_NEWS_ID = "latest.news.id";
    private Pdfsam pdfsam;

    @Inject
    DefaultNewsService(Pdfsam pdfsam) {
        this.pdfsam = pdfsam;
    }

    @Override
    public List<NewsData> getLatestNews() {
        try {
            return JSON.std.with(JSON.Feature.READ_ONLY, true).listOfFrom(NewsData.class, new URL(this.pdfsam.property(ConfigurableProperty.NEWS_URL)));
        }
        catch (IOException e) {
            LOG.warn(DefaultI18nContext.getInstance().i18n("Unable to retrieve latest news"), e);
            return Collections.emptyList();
        }
    }

    @Override
    public void setLatestNewsSeen(int id) {
        Preferences.userRoot().node(NEWS_PATH).putInt(LATEST_NEWS_ID, id);
        LOG.trace("Latest news id stored");
    }

    @Override
    public int getLatestNewsSeen() {
        return Preferences.userRoot().node(NEWS_PATH).getInt(LATEST_NEWS_ID, -1);
    }

    @Override
    public void clear() {
        Preferences prefs = Preferences.userRoot().node(NEWS_PATH);
        try {
            prefs.removeNode();
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Unable to clear latest news store", e);
        }
    }
}

