/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.splitbysize;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.splitbysize.SizeUnit;
import org.pdfsam.splitbysize.SizeUnitRadio;
import org.pdfsam.splitbysize.SplitBySizeParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.support.validation.Validators;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;

class SplitOptionsPane
extends HBox
implements TaskParametersBuildStep<SplitBySizeParametersBuilder>,
RestorableView {
    private final ValidableTextField field = new ValidableTextField();
    private ToggleGroup group = new ToggleGroup();

    SplitOptionsPane() {
        this.field.setOnEnterValidation(true);
        this.field.setEnableInvalidStyle(true);
        this.field.setPromptText(DefaultI18nContext.getInstance().i18n("Set the size to split at"));
        this.field.setValidator(Validators.positiveInteger());
        this.field.setErrorMessage(DefaultI18nContext.getInstance().i18n("Size must be a number"));
        this.field.setId("sizeField");
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Split at this size:")), this.field});
        Arrays.stream(SizeUnit.values()).map(SizeUnitRadio::new).forEach(r -> {
            r.setToggleGroup(this.group);
            this.getChildren().add(r);
        });
        this.group.getToggles().stream().findFirst().ifPresent(t -> t.setSelected(true));
    }

    @Override
    public void apply(SplitBySizeParametersBuilder builder, Consumer<String> onError) {
        this.field.validate();
        if (this.field.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.size(((SizeUnitRadio)this.group.getSelectedToggle()).unit().toBytes(Integer.valueOf(this.field.getText())));
        } else {
            onError.accept(DefaultI18nContext.getInstance().i18n("Invalid split size"));
        }
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put("size", StringUtils.defaultString(this.field.getText()));
        this.group.getToggles().stream().map(t -> (SizeUnitRadio)t).forEach(s -> s.saveStateTo(data));
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        this.field.setText(Optional.ofNullable(data.get("size")).orElse(""));
        this.group.getToggles().stream().map(t -> (SizeUnitRadio)t).forEach(s -> s.restoreStateFrom(data));
    }
}

