/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.ui.dashboard.DashboardItem;
import org.pdfsam.ui.dashboard.DashboardItemPane;
import org.pdfsam.ui.dashboard.QuickbarDashboardButtonsPane;
import org.pdfsam.ui.event.SetActiveDashboardItemRequest;
import org.pdfsam.ui.event.SetTitleEvent;
import org.pdfsam.ui.quickbar.QuickbarPane;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

@Named
public class Dashboard
extends BorderPane {
    private Map<String, DashboardItemPane> items = new HashMap<String, DashboardItemPane>();
    private StackPane center = new StackPane();
    private FadeTransition fade = new FadeTransition(new Duration(300.0), (Node)this.center);

    @Inject
    public Dashboard(List<DashboardItem> itemsList) {
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.setId("pdfsam-dashboard");
        itemsList.stream().forEach(i -> this.items.put(i.id(), new DashboardItemPane((DashboardItem)i)));
        this.fade.setFromValue(0.0);
        this.fade.setToValue(1.0);
        this.setCenter((Node)this.center);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @Inject
    void setDashboardButtonsPane(QuickbarDashboardButtonsPane dashboardButtons) {
        this.setLeft((Node)new QuickbarPane(dashboardButtons));
    }

    @EventListener
    public void onSetActiveDashboardItem(SetActiveDashboardItemRequest request) {
        DashboardItemPane requested = this.items.get(request.getActiveItemId());
        if (requested != null) {
            this.center.getChildren().setAll((Object[])new Node[]{requested});
            this.fade.play();
            StaticStudio.eventStudio().broadcast(new SetTitleEvent(requested.getItem().name()));
        }
    }
}

