/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple.move;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.pdfsam.ui.selection.multiple.move.SelectionAndFocus;

class MultipleSelectionAndFocus
implements SelectionAndFocus {
    private int focus = -1;
    private int originalFocus = -1;
    private int row = -1;
    private Set<Integer> rows = new HashSet<Integer>();

    MultipleSelectionAndFocus(int originalFocus) {
        this.originalFocus = originalFocus;
    }

    private void move(int row, int newRow) {
        if (this.focus == -1 && this.originalFocus == row) {
            this.focus = newRow;
        }
        if (this.row == -1) {
            this.row = newRow;
        } else {
            this.rows.add(newRow);
        }
    }

    void moveUp(int row) {
        int newRow = row - 1;
        this.move(row, newRow);
    }

    void moveDown(int row) {
        int newRow = row + 1;
        this.move(row, newRow);
    }

    @Override
    public int getFocus() {
        return this.focus;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int[] getRows() {
        return ArrayUtils.toPrimitive(this.rows.toArray(new Integer[this.rows.size()]));
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}

