/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.impl.sambox.component.Annotations;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.CropParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CropTask
extends BaseTask<CropParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CropTask.class);
    private PDDocumentHandler sourceDocumentHandler = null;
    private PDDocumentHandler destinationDocument = null;
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private LookupTable<PDPage> pagesLookup = new LookupTable();

    @Override
    public void before(CropParameters parameters) {
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(CropParameters parameters) throws TaskException {
        int currentStep = 0;
        PdfSource source = parameters.getSource();
        LOG.debug("Opening {}", (Object)source);
        this.sourceDocumentHandler = source.open(this.documentLoader);
        File tmpFile = IOUtils.createTemporaryPdfBuffer();
        LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
        this.destinationDocument = new PDDocumentHandler();
        List cropAreas = parameters.getCropAreas().stream().map(r -> new PDRectangle(r.getLeft(), r.getBottom(), r.getRight() - r.getLeft(), r.getTop() - r.getBottom())).collect(Collectors.toList());
        LOG.debug("Found {} crop boxes to apply", (Object)cropAreas.size());
        int totalSteps = cropAreas.size() * this.sourceDocumentHandler.getNumberOfPages();
        for (PDPage page : this.sourceDocumentHandler.getUnderlyingPDDocument().getPages()) {
            for (PDRectangle box : cropAreas) {
                this.stopTaskIfCancelled();
                PDPage newPage = this.destinationDocument.importPage(page);
                this.pagesLookup.addLookupEntry(page, newPage);
                newPage.setMediaBox(box);
                newPage.setCropBox(box);
                ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(totalSteps);
            }
        }
        LookupTable<PDAnnotation> annotations = Annotations.processAnnotations(this.pagesLookup, this.sourceDocumentHandler.getUnderlyingPDDocument());
        SignatureClipper.clipSignatures(annotations.values());
        this.destinationDocument.setCreatorOnPDDocument();
        this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
        this.destinationDocument.setCompress(parameters.isCompress());
        this.destinationDocument.savePDDocument(tmpFile);
        ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
        this.outputWriter.setOutput(FileOutput.file(tmpFile).name(parameters.getOutputName()));
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Crop areas applied to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
        this.pagesLookup.clear();
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
    }
}

