/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.freehep.graphicsio.emf.Arc;
import org.freehep.graphicsio.emf.BeginPath;
import org.freehep.graphicsio.emf.CreateBrushIndirect;
import org.freehep.graphicsio.emf.CreatePen;
import org.freehep.graphicsio.emf.DeleteObject;
import org.freehep.graphicsio.emf.EMFHeader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EndPath;
import org.freehep.graphicsio.emf.FillPath;
import org.freehep.graphicsio.emf.LineTo;
import org.freehep.graphicsio.emf.LogBrush32;
import org.freehep.graphicsio.emf.LogPen;
import org.freehep.graphicsio.emf.MoveToEx;
import org.freehep.graphicsio.emf.SelectObject;
import org.freehep.util.io.Tag;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class EMF2SVG {
    private EMFInputStream is;
    private Element svg;
    private Element currentPath;
    private Element group;
    private Point currentPosition;
    private Object currentObject;
    private LogPen currentPen;
    private HashMap objects = new HashMap();

    public EMF2SVG(EMFInputStream is) {
        this.is = is;
    }

    public String getSVG() {
        try {
            EMFHeader header = this.is.readHeader();
            System.out.println("header " + header);
            this.svg = new Element("svg");
            this.svg.setAttribute("version", "1.1");
            this.svg.setAttribute("width", "" + header.getBounds().width / 10);
            this.svg.setAttribute("height", "" + header.getBounds().height / 10);
            this.group = new Element("g");
            this.group.setAttribute("transform", "scale(0.1)");
            this.svg.addContent(this.group);
            Element g = new Element("g");
            g.setAttribute("transform", "translate( " + -1 * header.getBounds().x + " " + -1 * header.getBounds().y + ")");
            this.group.addContent(g);
            this.group = g;
            Tag tag = this.is.readTag();
            while (tag != null) {
                System.out.println(tag);
                this.map(tag);
                tag = this.is.readTag();
            }
        }
        catch (IOException ioexp) {
            ioexp.printStackTrace();
        }
        String retval = null;
        try {
            XMLOutputter output = new XMLOutputter();
            output.setIndent("  ");
            output.setNewlines(true);
            retval = output.outputString(this.svg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private void map(Tag tag) {
        if (tag instanceof Arc) {
            Arc arc = (Arc)tag;
            Element path = new Element("path");
            StringBuffer def = new StringBuffer();
            def.append("M" + arc.getStart().x + "," + arc.getStart().y);
            def.append(" ");
            def.append("a" + arc.getBounds().width / 2 + "," + arc.getBounds().height / 2);
            def.append(" 0 ");
            def.append(" 0,0");
            def.append(arc.getEnd().x + "," + arc.getEnd().y);
            path.setAttribute("d", def.toString());
            path.setAttribute("stroke", "blue");
            path.setAttribute("stroke-width", "1");
            this.group.addContent(path);
        } else if (tag instanceof BeginPath) {
            this.beginPath();
        } else if (tag instanceof CreateBrushIndirect) {
            CreateBrushIndirect cbi = (CreateBrushIndirect)tag;
            this.objects.put(new Integer(cbi.getIndex()), cbi.getBrush());
        } else if (tag instanceof CreatePen) {
            CreatePen cpen = (CreatePen)tag;
            this.currentPen = cpen.getPen();
        } else if (tag instanceof DeleteObject) {
            this.objects.remove(new Integer(((DeleteObject)tag).getIndex()));
        } else if (!(tag instanceof EndPath)) {
            if (tag instanceof FillPath) {
                if (this.currentObject instanceof LogBrush32) {
                    LogBrush32 brush = (LogBrush32)this.currentObject;
                    this.currentPath.setAttribute("fill", this.printColor(brush.getColor()));
                    this.currentPath.setAttribute("fill-rule", "evenodd");
                } else {
                    System.out.println("unsupported object " + this.currentObject + " for FillPath");
                }
            } else if (tag instanceof LineTo) {
                LineTo lineTo = (LineTo)tag;
                StringBuffer def = new StringBuffer();
                def.append(this.currentPath.getAttributeValue("d"));
                def.append("L " + lineTo.getPoint().x + " " + lineTo.getPoint().y + " ");
                Attribute attr = this.currentPath.getAttribute("d");
                attr.setValue(def.toString());
            } else if (tag instanceof MoveToEx) {
                if (this.currentPath == null) {
                    this.beginPath();
                }
                MoveToEx mte = (MoveToEx)tag;
                this.currentPosition = mte.getPoint();
                StringBuffer def = new StringBuffer();
                Attribute d = this.currentPath.getAttribute("d");
                def.append(d.getValue());
                def.append("M " + this.currentPosition.x + " " + this.currentPosition.y + " ");
                d.setValue(def.toString());
            } else if (tag instanceof SelectObject) {
                this.currentObject = this.objects.get(new Integer(((SelectObject)tag).getIndex()));
            } else {
                System.out.println("tag " + tag + " not supported");
            }
        }
    }

    private void beginPath() {
        if (this.currentPath != null) {
            this.closePath();
        }
        this.currentPath = new Element("path");
        this.currentPath.setAttribute("d", "");
        if (this.currentPen != null) {
            this.currentPath.setAttribute("stroke", this.printColor(this.currentPen.getColor()));
            this.currentPath.setAttribute("stroke-width", "" + this.currentPen.getWidth());
        }
        this.group.addContent(this.currentPath);
    }

    private void closePath() {
    }

    private String printColor(Color color) {
        StringBuffer buff = new StringBuffer();
        buff.append("#");
        buff.append(Integer.toHexString(color.getRed()));
        buff.append(Integer.toHexString(color.getGreen()));
        buff.append(Integer.toHexString(color.getBlue()));
        String retval = buff.toString();
        if ("#00ff".equals(retval)) {
            retval = "#00f";
        }
        return retval.toString();
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream(args[0]);
            EMFInputStream emf = new EMFInputStream(fis);
            EMF2SVG mapper = new EMF2SVG(emf);
            File f = new File("test.svg");
            PrintWriter out = new PrintWriter(new FileWriter(f));
            out.print(mapper.getSVG());
            out.close();
        }
        catch (IOException ioexp) {
            ioexp.printStackTrace();
        }
    }
}

