/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

public enum LineDescriptionEnum {
    MESSAGE_START("m1", 1, true),
    MESSAGE_END("m2", 2, false),
    ROLE_START("r1", 3, true),
    ROLE_END("r2", 4, false),
    MESSAGE_MIDDLE("", 5, null);

    private final String key;
    private final int index;
    private final Boolean start;

    private LineDescriptionEnum(String key, int index, Boolean start) {
        this.key = key;
        this.index = index;
        this.start = start;
    }

    public int getIndex() {
        return this.index;
    }

    public String getKey() {
        return this.key;
    }

    public Boolean isStart() {
        return this.start;
    }

    public static LineDescriptionEnum forString(String line) {
        for (LineDescriptionEnum ld : LineDescriptionEnum.values()) {
            if (!line.startsWith(ld.key + "=")) continue;
            return ld;
        }
        return MESSAGE_MIDDLE;
    }

    public boolean isMessageStartOrEnd() {
        return this == MESSAGE_START || this == MESSAGE_END;
    }

    public boolean isRoleStartOrEnd() {
        return this == ROLE_START || this == ROLE_END;
    }
}

