/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.osx;

import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.effects.AudioEqualizer;
import com.sun.media.jfxmedia.effects.AudioSpectrum;
import com.sun.media.jfxmedia.effects.EqualizerBand;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.NativeMedia;
import com.sun.media.jfxmediaimpl.NativeMediaPlayer;
import com.sun.media.jfxmediaimpl.platform.osx.OSXMedia;
import java.util.HashMap;
import java.util.Map;

public final class OSXMediaPlayer
extends NativeMediaPlayer {
    private NullAudioEQ audioEq;
    private NullAudioSpectrum audioSpectrum;
    private final Locator mediaLocator;

    OSXMediaPlayer(NativeMedia sourceMedia) {
        super(sourceMedia);
        this.mediaLocator = sourceMedia.getLocator();
        this.audioEq = new NullAudioEQ();
        this.audioSpectrum = new NullAudioSpectrum();
    }

    OSXMediaPlayer(Locator source) {
        this(new OSXMedia(source));
    }

    public AudioEqualizer getEqualizer() {
        return this.audioEq;
    }

    public AudioSpectrum getAudioSpectrum() {
        return this.audioSpectrum;
    }

    void initializePlayer() {
        this.createPlayer(this.mediaLocator.getStringLocation());
    }

    private native void createPlayer(String var1) throws MediaException;

    public native long playerGetAudioSyncDelay() throws MediaException;

    public native void playerSetAudioSyncDelay(long var1) throws MediaException;

    public native void playerPlay() throws MediaException;

    public native void playerStop() throws MediaException;

    public native void playerPause() throws MediaException;

    public native float playerGetRate() throws MediaException;

    public native void playerSetRate(float var1) throws MediaException;

    public native double playerGetPresentationTime() throws MediaException;

    public native boolean playerGetMute() throws MediaException;

    public native void playerSetMute(boolean var1) throws MediaException;

    public native float playerGetVolume() throws MediaException;

    public native void playerSetVolume(float var1) throws MediaException;

    public native float playerGetBalance() throws MediaException;

    public native void playerSetBalance(float var1) throws MediaException;

    public native double playerGetDuration() throws MediaException;

    public native double playerGetStartTime() throws MediaException;

    public native void playerSetStartTime(double var1) throws MediaException;

    public native double playerGetStopTime() throws MediaException;

    public native void playerSetStopTime(double var1) throws MediaException;

    public native void playerSeek(double var1) throws MediaException;

    public native void playerDispose();

    public void playerInit() throws MediaException {
    }

    private final class NullAudioEQ
    implements AudioEqualizer {
        private boolean enabled = false;
        private Map<Double, EqualizerBand> bands = new HashMap<Double, EqualizerBand>();

        private NullAudioEQ() {
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bEnable) {
            this.enabled = bEnable;
        }

        public EqualizerBand addBand(double centerFrequency, double bandwidth, double gain) {
            Double key = new Double(centerFrequency);
            if (this.bands.containsKey(key)) {
                this.removeBand(centerFrequency);
            }
            NullEQBand newBand = new NullEQBand(centerFrequency, bandwidth, gain);
            this.bands.put(key, newBand);
            return newBand;
        }

        public boolean removeBand(double centerFrequency) {
            Double key = new Double(centerFrequency);
            if (this.bands.containsKey(key)) {
                this.bands.remove(key);
                return true;
            }
            return false;
        }
    }

    private final class NullAudioSpectrum
    implements AudioSpectrum {
        private boolean enabled = false;
        private int bandCount = 128;
        private double interval = 0.1;
        private int threshold = 60;
        private float[] fakeData;

        private NullAudioSpectrum() {
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getBandCount() {
            return this.bandCount;
        }

        public void setBandCount(int bands) {
            this.bandCount = bands;
            this.fakeData = new float[this.bandCount];
        }

        public double getInterval() {
            return this.interval;
        }

        public void setInterval(double interval) {
            this.interval = interval;
        }

        public int getSensitivityThreshold() {
            return this.threshold;
        }

        public void setSensitivityThreshold(int threshold) {
            this.threshold = threshold;
        }

        public float[] getMagnitudes() {
            return this.fakeData;
        }

        public float[] getPhases() {
            return this.fakeData;
        }
    }

    private static final class NullEQBand
    implements EqualizerBand {
        private double center;
        private double bandwidth;
        private double gain;

        NullEQBand(double center, double bandwidth, double gain) {
            this.center = center;
            this.bandwidth = bandwidth;
            this.gain = gain;
        }

        public double getCenterFrequency() {
            return this.center;
        }

        public void setCenterFrequency(double centerFrequency) {
            this.center = centerFrequency;
        }

        public double getBandwidth() {
            return this.bandwidth;
        }

        public void setBandwidth(double bandwidth) {
            this.bandwidth = bandwidth;
        }

        public double getGain() {
            return this.gain;
        }

        public void setGain(double gain) {
            this.gain = gain;
        }
    }
}

