/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authorization;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.extension.authorization.BasicAuthorizationDetectionMethod;
import org.zaproxy.zap.network.HttpResponseBody;

@RunWith(value=MockitoJUnitRunner.class)
public class BasicAuthorizationDetectionMethodUnitTest {
    private static final String RESPONSE_TARGET_TEXT = "Unauthorized";
    private static final String LOCATION_URL = "http://www.example.com/login";
    private static final int STATUS_CODE = 302;
    private static final String RESPONSE_HEADER = "HTTP/1.1 302 Found\nContent-Type: text/html; charset=utf-8\nLocation: http://www.example.com/login\nDate: Sun, 18 May 2014 16:16:45 GMT\nServer: Google Frontend\nContent-Length: 0\nAlternate-Protocol: 80:quic,80:quic\n";
    private static final String RESPONSE_BODY = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque auctor nulla id turpis placerat vulputate.Unauthorized Proin tempor bibendum eros rutrum. ";
    private HttpMessage message;
    private BasicAuthorizationDetectionMethod authorizationMethod;

    @Before
    public void setUp() throws Exception {
        this.message = (HttpMessage)Mockito.mock(HttpMessage.class);
        HttpResponseHeader httpResponseHeader = (HttpResponseHeader)Mockito.mock(HttpResponseHeader.class);
        HttpResponseBody httpResponseBody = (HttpResponseBody)Mockito.mock(HttpResponseBody.class);
        Mockito.when((Object)this.message.getResponseHeader()).thenReturn((Object)httpResponseHeader);
        Mockito.when((Object)this.message.getResponseBody()).thenReturn((Object)httpResponseBody);
        Mockito.when((Object)httpResponseBody.toString()).thenReturn((Object)RESPONSE_BODY);
        Mockito.when((Object)httpResponseHeader.getStatusCode()).thenReturn((Object)302);
        Mockito.when((Object)httpResponseHeader.toString()).thenReturn((Object)RESPONSE_HEADER);
    }

    @Test
    public void shouldNotReturnUnauthorizeWhenNothingIsSetWithAnd() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(null, null, null, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
    }

    @Test
    public void shouldNotReturnUnauthorizeWhenNothingIsSetWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(null, "", "", BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
    }

    @Test
    public void shouldReturnUnauthorizeWhenJustStatusCodeIsSetWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)302, "", "", BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
    }

    @Test
    public void shouldReturnUnauthorizeWhenJustBodyIsSetWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(null, "", RESPONSE_TARGET_TEXT, BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
    }

    @Test
    public void shouldReturnUnauthorizeWhenJustHeaderIsSetWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(null, "Location: http://www.example.com/login", null, BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
    }

    @Test
    public void shouldNotReturnUnauthorizeWhenJustStatusCodeIsSetWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)303, "", "", BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
    }

    @Test
    public void shouldNotReturnUnauthorizeWhenJustBodyIsSetWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(null, "", "UnauthorizedRANDOM", BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
    }

    @Test
    public void shouldReturnNotUnauthorizeWhenJustHeaderIsSetWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(null, "Location: http://www.example.com/login/extra", null, BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
    }

    @Test
    public void shouldReturnUnauthorizeWhenJustStatusCodeIsSetWithAnd() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)302, "", "", BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
    }

    @Test
    public void shouldReturnUnauthorizeWhenJustBodyIsSetWithAnd() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(null, "", RESPONSE_TARGET_TEXT, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
    }

    @Test
    public void shouldReturnUnauthorizeWhenJustHeaderIsSetWithAnd() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod(null, "Location: http://www.example.com/login", null, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        Assert.assertEquals((Object)true, (Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message));
    }

    @Test
    public void shouldReturnUnauthorizedWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)303, "", RESPONSE_TARGET_TEXT, BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)302, null, "Unauthorized?TEST", BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)303, LOCATION_URL, "Unauthorized??", BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
    }

    @Test
    public void shouldNotReturnUnauthorizedWithOr() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)303, "", "UnauthorizedEXTRA", BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)303, "Location: wrongUrl", "UnauthorizedEXTRA", BasicAuthorizationDetectionMethod.LogicalOperator.OR);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
    }

    @Test
    public void shouldReturnUnauthorizedWithAnd() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)302, "", RESPONSE_TARGET_TEXT, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)302, LOCATION_URL, RESPONSE_TARGET_TEXT, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)true);
    }

    @Test
    public void shouldNotReturnUnauthorizedWithAnd() {
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)304, null, RESPONSE_TARGET_TEXT, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
        this.authorizationMethod = new BasicAuthorizationDetectionMethod((Integer)302, "No Location", RESPONSE_TARGET_TEXT, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        Assert.assertEquals((Object)this.authorizationMethod.isResponseForUnauthorizedRequest(this.message), (Object)false);
    }
}

