/* arch/arm/mach-exynos/include/mach/regs-clock-exynos5430.h
 *
 * Copyright (c) 2013 Samsung Electronics Co., Ltd.
 *						  http://www.samsung.com
 *
 * EXYNOS5430 - Clock register definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ASM_ARCH_REGS_CLOCK_5430_H
#define __ASM_ARCH_REGS_CLOCK_5430_H __FILE__

#include <plat/cpu.h>
#include <mach/map.h>

#define EXYNOS_CLKREG_TOP(x)		(EXYNOS5430_VA_CMU_TOP + (x))		/* PA : 0x10030000 */
#define EXYNOS_CLKREG_EGL(x)		(EXYNOS5430_VA_CMU_EGL + (x))		/* PA : 0x11800000 */
#define EXYNOS_CLKREG_KFC(x)		(EXYNOS5430_VA_CMU_KFC + (x))		/* PA : 0x11900000 */
#define EXYNOS_CLKREG_AUD(x)		(EXYNOS5430_VA_CMU_AUD + (x))		/* PA : 0x114C0000 */
#define EXYNOS_CLKREG_BUS1(x)		(EXYNOS5430_VA_CMU_BUS1 + (x))		/* PA : 0x14800000 */
#define EXYNOS_CLKREG_BUS2(x)		(EXYNOS5430_VA_CMU_BUS2 + (x))		/* PA : 0x13400000 */
#define EXYNOS_CLKREG_CAM0(x)		(EXYNOS5430_VA_CMU_CAM0 + (x))		/* PA : 0x120D0000 */
#define EXYNOS_CLKREG_CAM0_LOCAL(x)	(EXYNOS5430_VA_CMU_CAM0_LOCAL + (x))	/* PA : 0x121C0000 */
#define EXYNOS_CLKREG_CAM1(x)		(EXYNOS5430_VA_CMU_CAM1 + (x))		/* PA : 0x145D0000 */
#define EXYNOS_CLKREG_CAM1_LOCAL(x)	(EXYNOS5430_VA_CMU_CAM1_LOCAL + (x))	/* PA : 0x142F0000 */
#define EXYNOS_CLKREG_CPIF(x)		(EXYNOS5430_VA_CMU_CPIF + (x))		/* PA : 0x10FC0000 */
#define EXYNOS_CLKREG_DISP(x)		(EXYNOS5430_VA_CMU_DISP + (x))		/* PA : 0x13B90000 */
#define EXYNOS_CLKREG_FSYS(x)		(EXYNOS5430_VA_CMU_FSYS + (x))		/* PA : 0x156E0000 */
#define EXYNOS_CLKREG_G2D(x)		(EXYNOS5430_VA_CMU_G2D + (x))		/* PA : 0x12460000 */
#define EXYNOS_CLKREG_G3D(x)		(EXYNOS5430_VA_CMU_G3D + (x))		/* PA : 0x14AA0000 */
#define EXYNOS_CLKREG_GSCL(x)		(EXYNOS5430_VA_CMU_GSCL + (x))		/* PA : 0x13CF0000 */
#define EXYNOS_CLKREG_HEVC(x)		(EXYNOS5430_VA_CMU_HEVC + (x))		/* PA : 0x14F80000 */
#define EXYNOS_CLKREG_IMEM(x)		(EXYNOS5430_VA_CMU_IMEM + (x))		/* PA : 0x11060000 */
#define EXYNOS_CLKREG_ISP(x)		(EXYNOS5430_VA_CMU_ISP + (x))		/* PA : 0x146D0000 */
#define EXYNOS_CLKREG_ISP_LOCAL(x)	(EXYNOS5430_VA_CMU_ISP_LOCAL + (x))	/* PA : 0x14360000 */
#define EXYNOS_CLKREG_MFC0(x)		(EXYNOS5430_VA_CMU_MFC0 + (x))		/* PA : 0x15280000 */
#define EXYNOS_CLKREG_MFC1(x)		(EXYNOS5430_VA_CMU_MFC1 + (x))		/* PA : 0x15380000 */
#define EXYNOS_CLKREG_MIF(x)		(EXYNOS5430_VA_CMU_MIF + (x))		/* PA : 0x105B0000 */
#define EXYNOS_CLKREG_MSCL(x)		(EXYNOS5430_VA_CMU_MSCL + (x))		/* PA : 0x150D0000 */
#define EXYNOS_CLKREG_PERIC(x)		(EXYNOS5430_VA_CMU_PERIC + (x))		/* PA : 0x14C80000 */
#define EXYNOS_CLKREG_PERIS(x)		(EXYNOS5430_VA_CMU_PERIS + (x))		/* PA : 0x10040000 */

#define EXYNOS5430_EGL_PLL_LOCK				EXYNOS_CLKREG_EGL(0x0000)
#define EXYNOS5430_EGL_PLL_CON0				EXYNOS_CLKREG_EGL(0x0100)
#define EXYNOS5430_EGL_PLL_CON1				EXYNOS_CLKREG_EGL(0x0104)
#define EXYNOS5430_EGL_PLL_FREQ_DET			EXYNOS_CLKREG_EGL(0x010C)
#define EXYNOS5430_EGL_DPLL_LOCK			EXYNOS_CLKREG_EGL(0x0004)
#define EXYNOS5430_EGL_DPLL_CON0			EXYNOS_CLKREG_EGL(0x0110)
#define EXYNOS5430_EGL_DPLL_CON1			EXYNOS_CLKREG_EGL(0x0114)
#define EXYNOS5430_EGL_DPLL_CON2			EXYNOS_CLKREG_EGL(0x0118)
#define EXYNOS5430_EGL_DPLL_FREQ_DET			EXYNOS_CLKREG_EGL(0x011C)
#define EXYNOS5430_KFC_PLL_LOCK				EXYNOS_CLKREG_KFC(0x0000)
#define EXYNOS5430_KFC_PLL_CON0				EXYNOS_CLKREG_KFC(0x0100)
#define EXYNOS5430_KFC_PLL_CON1				EXYNOS_CLKREG_KFC(0x0104)
#define EXYNOS5430_KFC_PLL_FREQ_DET			EXYNOS_CLKREG_KFC(0x010C)

#ifdef CONFIG_SOC_EXYNOS5430_REV_0
#define EXYNOS5430_MEM_PLL_LOCK				EXYNOS_CLKREG_MIF(0x0004)
#define EXYNOS5430_MEM_PLL_CON0				EXYNOS_CLKREG_MIF(0x0110)
#define EXYNOS5430_MEM_PLL_CON1				EXYNOS_CLKREG_MIF(0x0114)
#define EXYNOS5430_MEM_PLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x011C)
#define EXYNOS5430_BUS_PLL_LOCK				EXYNOS_CLKREG_MIF(0x0000)
#define EXYNOS5430_BUS_PLL_CON0				EXYNOS_CLKREG_MIF(0x0100)
#define EXYNOS5430_BUS_PLL_CON1				EXYNOS_CLKREG_MIF(0x0104)
#define EXYNOS5430_BUS_PLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x010C)
#define EXYNOS5430_BUS_DPLL_LOCK			EXYNOS_CLKREG_MIF(0x000C)
#define EXYNOS5430_BUS_DPLL_CON0			EXYNOS_CLKREG_MIF(0x0130)
#define EXYNOS5430_BUS_DPLL_CON1			EXYNOS_CLKREG_MIF(0x0134)
#define EXYNOS5430_BUS_DPLL_CON2			EXYNOS_CLKREG_MIF(0x0138)
#define EXYNOS5430_BUS_DPLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x013C)
#define EXYNOS5430_MFC_PLL_LOCK				EXYNOS_CLKREG_MIF(0x0008)
#define EXYNOS5430_MFC_PLL_CON0				EXYNOS_CLKREG_MIF(0x0120)
#define EXYNOS5430_MFC_PLL_CON1				EXYNOS_CLKREG_MIF(0x0124)
#define EXYNOS5430_MFC_PLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x012C)
#else
#define EXYNOS5430_MEM0_PLL_LOCK			EXYNOS_CLKREG_MIF(0x0000)
#define EXYNOS5430_MEM0_PLL_CON0			EXYNOS_CLKREG_MIF(0x0100)
#define EXYNOS5430_MEM0_PLL_CON1			EXYNOS_CLKREG_MIF(0x0104)
#define EXYNOS5430_MEM0_PLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x010C)
#define EXYNOS5430_MEM1_PLL_LOCK			EXYNOS_CLKREG_MIF(0x0004)
#define EXYNOS5430_MEM1_PLL_CON0			EXYNOS_CLKREG_MIF(0x0110)
#define EXYNOS5430_MEM1_PLL_CON1			EXYNOS_CLKREG_MIF(0x0114)
#define EXYNOS5430_MEM1_PLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x011C)
#define EXYNOS5430_BUS_PLL_LOCK				EXYNOS_CLKREG_MIF(0x0008)
#define EXYNOS5430_BUS_PLL_CON0				EXYNOS_CLKREG_MIF(0x0120)
#define EXYNOS5430_BUS_PLL_CON1				EXYNOS_CLKREG_MIF(0x0124)
#define EXYNOS5430_BUS_PLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x012C)
#define EXYNOS5430_MFC_PLL_LOCK				EXYNOS_CLKREG_MIF(0x000C)
#define EXYNOS5430_MFC_PLL_CON0				EXYNOS_CLKREG_MIF(0x0130)
#define EXYNOS5430_MFC_PLL_CON1				EXYNOS_CLKREG_MIF(0x0134)
#define EXYNOS5430_MFC_PLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x013C)
#endif

#define EXYNOS5430_MPHY_PLL_LOCK			EXYNOS_CLKREG_CPIF(0x0000)
#define EXYNOS5430_MPHY_PLL_CON0			EXYNOS_CLKREG_CPIF(0x0100)
#define EXYNOS5430_MPHY_PLL_CON1			EXYNOS_CLKREG_CPIF(0x0104)
#define EXYNOS5430_MPHY_PLL_FREQ_DET			EXYNOS_CLKREG_CPIF(0x010C)
#define EXYNOS5430_G3D_PLL_LOCK				EXYNOS_CLKREG_G3D(0x0000)
#define EXYNOS5430_G3D_PLL_CON0				EXYNOS_CLKREG_G3D(0x0100)
#define EXYNOS5430_G3D_PLL_CON1				EXYNOS_CLKREG_G3D(0x0104)
#define EXYNOS5430_G3D_PLL_FREQ_DET			EXYNOS_CLKREG_G3D(0x010C)
#define EXYNOS5430_DISP_PLL_LOCK			EXYNOS_CLKREG_DISP(0x0000)
#define EXYNOS5430_DISP_PLL_CON0			EXYNOS_CLKREG_DISP(0x0100)
#define EXYNOS5430_DISP_PLL_CON1			EXYNOS_CLKREG_DISP(0x0104)
#define EXYNOS5430_DISP_PLL_FREQ_DET			EXYNOS_CLKREG_DISP(0x0108)
#define EXYNOS5430_ISP_PLL_LOCK				EXYNOS_CLKREG_TOP(0x0000)
#define EXYNOS5430_ISP_PLL_CON0				EXYNOS_CLKREG_TOP(0x0100)
#define EXYNOS5430_ISP_PLL_CON1				EXYNOS_CLKREG_TOP(0x0104)
#define EXYNOS5430_ISP_PLL_FREQ_DET			EXYNOS_CLKREG_TOP(0x0108)
#define EXYNOS5430_AUD_PLL_LOCK				EXYNOS_CLKREG_TOP(0x0004)
#define EXYNOS5430_AUD_PLL_CON0				EXYNOS_CLKREG_TOP(0x0110)
#define EXYNOS5430_AUD_PLL_CON1				EXYNOS_CLKREG_TOP(0x0114)
#define EXYNOS5430_AUD_PLL_CON2				EXYNOS_CLKREG_TOP(0x0118)
#define EXYNOS5430_AUD_PLL_FREQ_DET			EXYNOS_CLKREG_TOP(0x011C)
#define EXYNOS5430_AUD_DPLL_LOCK			EXYNOS_CLKREG_TOP(0x0008)
#define EXYNOS5430_AUD_DPLL_CON0			EXYNOS_CLKREG_TOP(0x0120)
#define EXYNOS5430_AUD_DPLL_CON1			EXYNOS_CLKREG_TOP(0x0124)
#define EXYNOS5430_AUD_DPLL_CON2			EXYNOS_CLKREG_TOP(0x0128)
#define EXYNOS5430_AUD_DPLL_FREQ_DET			EXYNOS_CLKREG_TOP(0x012C)
#define EXYNOS5430_SRC_SEL_KFC0				EXYNOS_CLKREG_KFC(0x0200)
#define EXYNOS5430_SRC_SEL_KFC1				EXYNOS_CLKREG_KFC(0x0204)
#define EXYNOS5430_SRC_SEL_KFC2				EXYNOS_CLKREG_KFC(0x0208)
#define EXYNOS5430_SRC_ENABLE_KFC0			EXYNOS_CLKREG_KFC(0x0300)
#define EXYNOS5430_SRC_ENABLE_KFC1			EXYNOS_CLKREG_KFC(0x0304)
#define EXYNOS5430_SRC_ENABLE_KFC2			EXYNOS_CLKREG_KFC(0x0308)
#define EXYNOS5430_SRC_STAT_KFC0			EXYNOS_CLKREG_KFC(0x0400)
#define EXYNOS5430_SRC_STAT_KFC1			EXYNOS_CLKREG_KFC(0x0404)
#define EXYNOS5430_SRC_STAT_KFC2			EXYNOS_CLKREG_KFC(0x0408)
#define EXYNOS5430_SRC_SEL_EGL0				EXYNOS_CLKREG_EGL(0x0200)
#define EXYNOS5430_SRC_SEL_EGL1				EXYNOS_CLKREG_EGL(0x0204)
#define EXYNOS5430_SRC_SEL_EGL2				EXYNOS_CLKREG_EGL(0x0208)
#define EXYNOS5430_SRC_ENABLE_EGL0			EXYNOS_CLKREG_EGL(0x0300)
#define EXYNOS5430_SRC_ENABLE_EGL1			EXYNOS_CLKREG_EGL(0x0304)
#define EXYNOS5430_SRC_ENABLE_EGL2			EXYNOS_CLKREG_EGL(0x0308)
#define EXYNOS5430_SRC_STAT_EGL0			EXYNOS_CLKREG_EGL(0x0400)
#define EXYNOS5430_SRC_STAT_EGL1			EXYNOS_CLKREG_EGL(0x0404)
#define EXYNOS5430_SRC_STAT_EGL2			EXYNOS_CLKREG_EGL(0x0408)
#define EXYNOS5430_SRC_SEL_AUD0				EXYNOS_CLKREG_AUD(0x0200)
#define EXYNOS5430_SRC_SEL_AUD1				EXYNOS_CLKREG_AUD(0x0204)
#define EXYNOS5430_SRC_ENABLE_AUD0			EXYNOS_CLKREG_AUD(0x0300)
#define EXYNOS5430_SRC_ENABLE_AUD1			EXYNOS_CLKREG_AUD(0x0304)
#define EXYNOS5430_SRC_STAT_AUD0			EXYNOS_CLKREG_AUD(0x0400)
#define EXYNOS5430_SRC_SEL_BUS1				EXYNOS_CLKREG_BUS1(0x0200)
#define EXYNOS5430_SRC_ENABLE_BUS1			EXYNOS_CLKREG_BUS1(0x0204)
#define EXYNOS5430_SRC_STAT_BUS1			EXYNOS_CLKREG_BUS1(0x0208)
#define EXYNOS5430_SRC_SEL_BUS2				EXYNOS_CLKREG_BUS2(0x0200)

#ifdef CONFIG_SOC_EXYNOS5430_REV_0
#define EXYNOS5430_SRC_ENABLE_BUS2			EXYNOS_CLKREG_BUS2(0x0204)
#define EXYNOS5430_SRC_STAT_BUS2			EXYNOS_CLKREG_BUS2(0x0208)
#else
#define EXYNOS5430_SRC_ENABLE_BUS2			EXYNOS_CLKREG_BUS2(0x0300)
#define EXYNOS5430_SRC_STAT_BUS2			EXYNOS_CLKREG_BUS2(0x0400)
#endif

#define EXYNOS5430_SRC_SEL_CAM00			EXYNOS_CLKREG_CAM0(0x0200)
#define EXYNOS5430_SRC_SEL_CAM01			EXYNOS_CLKREG_CAM0(0x0204)
#define EXYNOS5430_SRC_SEL_CAM02			EXYNOS_CLKREG_CAM0(0x0208)
#define EXYNOS5430_SRC_SEL_CAM03			EXYNOS_CLKREG_CAM0(0x020C)
#define EXYNOS5430_SRC_SEL_CAM04			EXYNOS_CLKREG_CAM0(0x0210)
#define EXYNOS5430_SRC_ENABLE_CAM00			EXYNOS_CLKREG_CAM0(0x0300)
#define EXYNOS5430_SRC_ENABLE_CAM01			EXYNOS_CLKREG_CAM0(0x0304)
#define EXYNOS5430_SRC_ENABLE_CAM02			EXYNOS_CLKREG_CAM0(0x0308)
#define EXYNOS5430_SRC_ENABLE_CAM03			EXYNOS_CLKREG_CAM0(0x030C)
#define EXYNOS5430_SRC_ENABLE_CAM04			EXYNOS_CLKREG_CAM0(0x0310)
#define EXYNOS5430_SRC_STAT_CAM00			EXYNOS_CLKREG_CAM0(0x0400)
#define EXYNOS5430_SRC_STAT_CAM01			EXYNOS_CLKREG_CAM0(0x0404)
#define EXYNOS5430_SRC_STAT_CAM02			EXYNOS_CLKREG_CAM0(0x0408)
#define EXYNOS5430_SRC_STAT_CAM03			EXYNOS_CLKREG_CAM0(0x040C)
#define EXYNOS5430_SRC_STAT_CAM04			EXYNOS_CLKREG_CAM0(0x0410)
#define EXYNOS5430_SRC_IGNORE_CAM01			EXYNOS_CLKREG_CAM0(0x0504)
#define EXYNOS5430_SRC_SEL_CAM10			EXYNOS_CLKREG_CAM1(0x0200)
#define EXYNOS5430_SRC_SEL_CAM11			EXYNOS_CLKREG_CAM1(0x0204)
#define EXYNOS5430_SRC_SEL_CAM12			EXYNOS_CLKREG_CAM1(0x0208)
#define EXYNOS5430_SRC_ENABLE_CAM10			EXYNOS_CLKREG_CAM1(0x0300)
#define EXYNOS5430_SRC_ENABLE_CAM11			EXYNOS_CLKREG_CAM1(0x0304)
#define EXYNOS5430_SRC_ENABLE_CAM12			EXYNOS_CLKREG_CAM1(0x0308)
#define EXYNOS5430_SRC_STAT_CAM10			EXYNOS_CLKREG_CAM1(0x0400)
#define EXYNOS5430_SRC_STAT_CAM11			EXYNOS_CLKREG_CAM1(0x0404)
#define EXYNOS5430_SRC_STAT_CAM12			EXYNOS_CLKREG_CAM1(0x0408)
#define EXYNOS5430_SRC_IGNORE_CAM11			EXYNOS_CLKREG_CAM1(0x0504)
#define EXYNOS5430_SRC_SEL_CPIF0			EXYNOS_CLKREG_CPIF(0x0200)
#define EXYNOS5430_SRC_SEL_CPIF1			EXYNOS_CLKREG_CPIF(0x0204)
#define EXYNOS5430_SRC_SEL_CPIF2			EXYNOS_CLKREG_CPIF(0x0208)
#define EXYNOS5430_SRC_ENABLE_CPIF0			EXYNOS_CLKREG_CPIF(0x0300)
#define EXYNOS5430_SRC_ENABLE_CPIF1			EXYNOS_CLKREG_CPIF(0x0304)
#define EXYNOS5430_SRC_ENABLE_CPIF2			EXYNOS_CLKREG_CPIF(0x0308)
#define EXYNOS5430_SRC_STAT_CPIF0			EXYNOS_CLKREG_CPIF(0x0400)
#define EXYNOS5430_SRC_STAT_CPIF1			EXYNOS_CLKREG_CPIF(0x0404)
#define EXYNOS5430_SRC_STAT_CPIF2			EXYNOS_CLKREG_CPIF(0x0408)
#define EXYNOS5430_SRC_IGNORE_CPIF1			EXYNOS_CLKREG_CPIF(0x0504)
#define EXYNOS5430_SRC_SEL_DISP0			EXYNOS_CLKREG_DISP(0x0200)
#define EXYNOS5430_SRC_SEL_DISP1			EXYNOS_CLKREG_DISP(0x0204)
#define EXYNOS5430_SRC_SEL_DISP2			EXYNOS_CLKREG_DISP(0x0208)
#define EXYNOS5430_SRC_SEL_DISP3			EXYNOS_CLKREG_DISP(0x020C)
#define EXYNOS5430_SRC_ENABLE_DISP0			EXYNOS_CLKREG_DISP(0x0300)
#define EXYNOS5430_SRC_ENABLE_DISP1			EXYNOS_CLKREG_DISP(0x0304)
#define EXYNOS5430_SRC_ENABLE_DISP2			EXYNOS_CLKREG_DISP(0x0308)
#define EXYNOS5430_SRC_ENABLE_DISP3			EXYNOS_CLKREG_DISP(0x030C)
#define EXYNOS5430_SRC_STAT_DISP0			EXYNOS_CLKREG_DISP(0x0400)
#define EXYNOS5430_SRC_STAT_DISP1			EXYNOS_CLKREG_DISP(0x0404)
#define EXYNOS5430_SRC_STAT_DISP2			EXYNOS_CLKREG_DISP(0x0408)
#define EXYNOS5430_SRC_STAT_DISP3			EXYNOS_CLKREG_DISP(0x040C)
#define EXYNOS5430_SRC_IGNORE_DISP2			EXYNOS_CLKREG_DISP(0x0508)
#define EXYNOS5430_SRC_SEL_FSYS0			EXYNOS_CLKREG_FSYS(0x0200)
#define EXYNOS5430_SRC_SEL_FSYS1			EXYNOS_CLKREG_FSYS(0x0204)
#define EXYNOS5430_SRC_SEL_FSYS2			EXYNOS_CLKREG_FSYS(0x0208)
#define EXYNOS5430_SRC_SEL_FSYS3			EXYNOS_CLKREG_FSYS(0x020C)
#define EXYNOS5430_SRC_SEL_FSYS4			EXYNOS_CLKREG_FSYS(0x0210)
#define EXYNOS5430_SRC_ENABLE_FSYS0			EXYNOS_CLKREG_FSYS(0x0300)
#define EXYNOS5430_SRC_ENABLE_FSYS1			EXYNOS_CLKREG_FSYS(0x0304)
#define EXYNOS5430_SRC_ENABLE_FSYS2			EXYNOS_CLKREG_FSYS(0x0308)
#define EXYNOS5430_SRC_ENABLE_FSYS3			EXYNOS_CLKREG_FSYS(0x030C)
#define EXYNOS5430_SRC_ENABLE_FSYS4			EXYNOS_CLKREG_FSYS(0x0310)
#define EXYNOS5430_SRC_STAT_FSYS0			EXYNOS_CLKREG_FSYS(0x0400)
#define EXYNOS5430_SRC_STAT_FSYS1			EXYNOS_CLKREG_FSYS(0x0404)
#define EXYNOS5430_SRC_STAT_FSYS2			EXYNOS_CLKREG_FSYS(0x0408)
#define EXYNOS5430_SRC_STAT_FSYS3			EXYNOS_CLKREG_FSYS(0x040C)
#define EXYNOS5430_SRC_STAT_FSYS4			EXYNOS_CLKREG_FSYS(0x0410)
#define EXYNOS5430_SRC_IGNORE_FSYS2			EXYNOS_CLKREG_FSYS(0x0508)
#define EXYNOS5430_SRC_IGNORE_FSYS3			EXYNOS_CLKREG_FSYS(0x050C)
#define EXYNOS5430_SRC_SEL_G2D				EXYNOS_CLKREG_G2D(0x0200)
#define EXYNOS5430_SRC_ENABLE_G2D			EXYNOS_CLKREG_G2D(0x0300)
#define EXYNOS5430_SRC_STAT_G2D				EXYNOS_CLKREG_G2D(0x0400)
#define EXYNOS5430_SRC_SEL_G3D				EXYNOS_CLKREG_G3D(0x0200)
#define EXYNOS5430_SRC_ENABLE_G3D			EXYNOS_CLKREG_G3D(0x0300)
#define EXYNOS5430_SRC_STAT_G3D				EXYNOS_CLKREG_G3D(0x0400)
#define EXYNOS5430_SRC_SEL_GSCL				EXYNOS_CLKREG_GSCL(0x0200)
#define EXYNOS5430_SRC_ENABLE_GSCL			EXYNOS_CLKREG_GSCL(0x0300)
#define EXYNOS5430_SRC_STAT_GSCL			EXYNOS_CLKREG_GSCL(0x0400)
#define EXYNOS5430_SRC_SEL_HEVC				EXYNOS_CLKREG_HEVC(0x0200)
#define EXYNOS5430_SRC_ENABLE_HEVC			EXYNOS_CLKREG_HEVC(0x0300)
#define EXYNOS5430_SRC_STAT_HEVC			EXYNOS_CLKREG_HEVC(0x0400)
#define EXYNOS5430_SRC_SEL_ISP				EXYNOS_CLKREG_ISP(0x0200)
#define EXYNOS5430_SRC_ENABLE_ISP			EXYNOS_CLKREG_ISP(0x0300)
#define EXYNOS5430_SRC_STAT_ISP				EXYNOS_CLKREG_ISP(0x0400)
#define EXYNOS5430_SRC_SEL_MFC0				EXYNOS_CLKREG_MFC0(0x0200)
#define EXYNOS5430_SRC_ENABLE_MFC0			EXYNOS_CLKREG_MFC0(0x0300)
#define EXYNOS5430_SRC_STAT_MFC0			EXYNOS_CLKREG_MFC0(0x0400)
#define EXYNOS5430_SRC_SEL_MFC1				EXYNOS_CLKREG_MFC1(0x0200)
#define EXYNOS5430_SRC_ENABLE_MFC1			EXYNOS_CLKREG_MFC1(0x0300)
#define EXYNOS5430_SRC_STAT_MFC1			EXYNOS_CLKREG_MFC1(0x0400)
#define EXYNOS5430_SRC_SEL_MIF0				EXYNOS_CLKREG_MIF(0x0200)
#define EXYNOS5430_SRC_SEL_MIF1				EXYNOS_CLKREG_MIF(0x0204)
#define EXYNOS5430_SRC_SEL_MIF2				EXYNOS_CLKREG_MIF(0x0208)
#define EXYNOS5430_SRC_SEL_MIF3				EXYNOS_CLKREG_MIF(0x020C)
#define EXYNOS5430_SRC_SEL_MIF4				EXYNOS_CLKREG_MIF(0x0210)
#define EXYNOS5430_SRC_SEL_MIF5				EXYNOS_CLKREG_MIF(0x0214)
#define EXYNOS5430_SRC_SEL_MIF6				EXYNOS_CLKREG_MIF(0x0218)
#define EXYNOS5430_SRC_ENABLE_MIF0			EXYNOS_CLKREG_MIF(0x0300)
#define EXYNOS5430_SRC_ENABLE_MIF1			EXYNOS_CLKREG_MIF(0x0304)
#define EXYNOS5430_SRC_ENABLE_MIF2			EXYNOS_CLKREG_MIF(0x0308)
#define EXYNOS5430_SRC_ENABLE_MIF3			EXYNOS_CLKREG_MIF(0x030C)
#define EXYNOS5430_SRC_ENABLE_MIF4			EXYNOS_CLKREG_MIF(0x0310)
#define EXYNOS5430_SRC_ENABLE_MIF5			EXYNOS_CLKREG_MIF(0x0314)
#define EXYNOS5430_SRC_STAT_MIF0			EXYNOS_CLKREG_MIF(0x0400)
#define EXYNOS5430_SRC_STAT_MIF1			EXYNOS_CLKREG_MIF(0x0404)
#define EXYNOS5430_SRC_STAT_MIF2			EXYNOS_CLKREG_MIF(0x0408)
#define EXYNOS5430_SRC_STAT_MIF3			EXYNOS_CLKREG_MIF(0x040C)
#define EXYNOS5430_SRC_STAT_MIF4			EXYNOS_CLKREG_MIF(0x0410)
#define EXYNOS5430_SRC_STAT_MIF5			EXYNOS_CLKREG_MIF(0x0414)
#define EXYNOS5430_SRC_STAT_MIF6			EXYNOS_CLKREG_MIF(0x0418)

#ifdef CONFIG_SOC_EXYNOS5430_REV_0
#define EXYNOS5430_SRC_SEL_MSCL				EXYNOS_CLKREG_MSCL(0x0200)
#define EXYNOS5430_SRC_ENABLE_MSCL			EXYNOS_CLKREG_MSCL(0x0300)
#define EXYNOS5430_SRC_STAT_MSCL			EXYNOS_CLKREG_MSCL(0x0400)
#else
#define EXYNOS5430_SRC_SEL_MSCL0			EXYNOS_CLKREG_MSCL(0x0200)
#define EXYNOS5430_SRC_SEL_MSCL1			EXYNOS_CLKREG_MSCL(0x0204)
#define EXYNOS5430_SRC_ENABLE_MSCL0			EXYNOS_CLKREG_MSCL(0x0300)
#define EXYNOS5430_SRC_ENABLE_MSCL1			EXYNOS_CLKREG_MSCL(0x0304)
#define EXYNOS5430_SRC_STAT_MSCL0			EXYNOS_CLKREG_MSCL(0x0400)
#define EXYNOS5430_SRC_STAT_MSCL1			EXYNOS_CLKREG_MSCL(0x0404)
#endif

#define EXYNOS5430_SRC_SEL_TOP0				EXYNOS_CLKREG_TOP(0x0200)
#define EXYNOS5430_SRC_SEL_TOP1				EXYNOS_CLKREG_TOP(0x0204)
#define EXYNOS5430_SRC_SEL_TOP2				EXYNOS_CLKREG_TOP(0x0208)
#define EXYNOS5430_SRC_SEL_TOP3				EXYNOS_CLKREG_TOP(0x020C)

#ifdef CONFIG_SOC_EXYNOS5430_REV_0
#define EXYNOS5430_SRC_SEL_TOP_MSCL			EXYNOS_CLKREG_TOP(0x0210)
#define EXYNOS5430_SRC_SEL_TOP_CAM1			EXYNOS_CLKREG_TOP(0x0214)
#define EXYNOS5430_SRC_SEL_TOP_DISP			EXYNOS_CLKREG_TOP(0x0218)
#define EXYNOS5430_SRC_SEL_TOP_FSYS0			EXYNOS_CLKREG_TOP(0x0220)
#define EXYNOS5430_SRC_SEL_TOP_FSYS1			EXYNOS_CLKREG_TOP(0x0224)
#define EXYNOS5430_SRC_SEL_TOP_PERIC0			EXYNOS_CLKREG_TOP(0x0228)
#define EXYNOS5430_SRC_SEL_TOP_PERIC1			EXYNOS_CLKREG_TOP(0x022C)
#else
#define EXYNOS5430_SRC_SEL_TOP4				EXYNOS_CLKREG_TOP(0x0210)
#define EXYNOS5430_SRC_SEL_TOP_MSCL			EXYNOS_CLKREG_TOP(0x0220)
#define EXYNOS5430_SRC_SEL_TOP_CAM1			EXYNOS_CLKREG_TOP(0x0224)
#define EXYNOS5430_SRC_SEL_TOP_DISP			EXYNOS_CLKREG_TOP(0x0228)
#define EXYNOS5430_SRC_SEL_TOP_FSYS0			EXYNOS_CLKREG_TOP(0x0230)
#define EXYNOS5430_SRC_SEL_TOP_FSYS1			EXYNOS_CLKREG_TOP(0x0234)
#define EXYNOS5430_SRC_SEL_TOP_PERIC0			EXYNOS_CLKREG_TOP(0x0238)
#define EXYNOS5430_SRC_SEL_TOP_PERIC1			EXYNOS_CLKREG_TOP(0x023C)
#endif

#define EXYNOS5430_SRC_ENABLE_TOP0			EXYNOS_CLKREG_TOP(0x0300)
#define EXYNOS5430_SRC_ENABLE_TOP1			EXYNOS_CLKREG_TOP(0x0304)
#define EXYNOS5430_SRC_ENABLE_TOP2			EXYNOS_CLKREG_TOP(0x0308)
#define EXYNOS5430_SRC_ENABLE_TOP3			EXYNOS_CLKREG_TOP(0x030C)

#ifdef CONFIG_SOC_EXYNOS5430_REV_0
#define EXYNOS5430_SRC_ENABLE_TOP_MSCL			EXYNOS_CLKREG_TOP(0x0310)
#define EXYNOS5430_SRC_ENABLE_TOP_CAM1			EXYNOS_CLKREG_TOP(0x0314)
#define EXYNOS5430_SRC_ENABLE_TOP_DISP			EXYNOS_CLKREG_TOP(0x0318)
#define EXYNOS5430_SRC_ENABLE_TOP_FSYS0			EXYNOS_CLKREG_TOP(0x0320)
#define EXYNOS5430_SRC_ENABLE_TOP_FSYS1			EXYNOS_CLKREG_TOP(0x0324)
#define EXYNOS5430_SRC_ENABLE_TOP_PERIC0		EXYNOS_CLKREG_TOP(0x0328)
#define EXYNOS5430_SRC_ENABLE_TOP_PERIC1		EXYNOS_CLKREG_TOP(0x032C)
#else
#define EXYNOS5430_SRC_ENABLE_TOP4			EXYNOS_CLKREG_TOP(0x0310)
#define EXYNOS5430_SRC_ENABLE_TOP_MSCL			EXYNOS_CLKREG_TOP(0x0320)
#define EXYNOS5430_SRC_ENABLE_TOP_CAM1			EXYNOS_CLKREG_TOP(0x0324)
#define EXYNOS5430_SRC_ENABLE_TOP_DISP			EXYNOS_CLKREG_TOP(0x0328)
#define EXYNOS5430_SRC_ENABLE_TOP_FSYS0			EXYNOS_CLKREG_TOP(0x0330)
#define EXYNOS5430_SRC_ENABLE_TOP_FSYS1			EXYNOS_CLKREG_TOP(0x0334)
#define EXYNOS5430_SRC_ENABLE_TOP_PERIC0		EXYNOS_CLKREG_TOP(0x0338)
#define EXYNOS5430_SRC_ENABLE_TOP_PERIC1		EXYNOS_CLKREG_TOP(0x033C)
#endif

#define EXYNOS5430_SRC_STAT_TOP0			EXYNOS_CLKREG_TOP(0x0400)
#define EXYNOS5430_SRC_STAT_TOP1			EXYNOS_CLKREG_TOP(0x0404)
#define EXYNOS5430_SRC_STAT_TOP2			EXYNOS_CLKREG_TOP(0x0408)
#define EXYNOS5430_SRC_STAT_TOP3			EXYNOS_CLKREG_TOP(0x040C)

#ifdef CONFIG_SOC_EXYNOS5430_REV_0
#define EXYNOS5430_SRC_STAT_TOP_MSCL			EXYNOS_CLKREG_TOP(0x0410)
#define EXYNOS5430_SRC_STAT_TOP_CAM1			EXYNOS_CLKREG_TOP(0x0414)
#define EXYNOS5430_SRC_STAT_TOP_FSYS0			EXYNOS_CLKREG_TOP(0x0420)
#define EXYNOS5430_SRC_STAT_TOP_FSYS1			EXYNOS_CLKREG_TOP(0x0424)
#define EXYNOS5430_SRC_STAT_TOP_PERIC0			EXYNOS_CLKREG_TOP(0x0428)
#define EXYNOS5430_SRC_STAT_TOP_PERIC1			EXYNOS_CLKREG_TOP(0x042C)
#else
#define EXYNOS5430_SRC_STAT_TOP4			EXYNOS_CLKREG_TOP(0x0410)
#define EXYNOS5430_SRC_STAT_TOP_MSCL			EXYNOS_CLKREG_TOP(0x0420)
#define EXYNOS5430_SRC_STAT_TOP_CAM1			EXYNOS_CLKREG_TOP(0x0424)
#define EXYNOS5430_SRC_STAT_TOP_FSYS0			EXYNOS_CLKREG_TOP(0x0430)
#define EXYNOS5430_SRC_STAT_TOP_FSYS1			EXYNOS_CLKREG_TOP(0x0434)
#define EXYNOS5430_SRC_STAT_TOP_PERIC0			EXYNOS_CLKREG_TOP(0x0438)
#define EXYNOS5430_SRC_STAT_TOP_PERIC1			EXYNOS_CLKREG_TOP(0x043C)
#endif

#define EXYNOS5430_DIV_KFC0				EXYNOS_CLKREG_KFC(0x0600)
#define EXYNOS5430_DIV_KFC1				EXYNOS_CLKREG_KFC(0x0604)
#define EXYNOS5430_DIV_KFC_PLL_FREQ_DET			EXYNOS_CLKREG_KFC(0x0608)
#define EXYNOS5430_DIV_STAT_KFC0			EXYNOS_CLKREG_KFC(0x0700)
#define EXYNOS5430_DIV_STAT_KFC1			EXYNOS_CLKREG_KFC(0x0704)
#define EXYNOS5430_DIV_STAT_KFC_PLL_FREQ_DET		EXYNOS_CLKREG_KFC(0x0708)
#define EXYNOS5430_DIV_EGL0				EXYNOS_CLKREG_EGL(0x0600)
#define EXYNOS5430_DIV_EGL1				EXYNOS_CLKREG_EGL(0x0604)
#define EXYNOS5430_DIV_EGL_PLL_FREQ_DET			EXYNOS_CLKREG_EGL(0x0608)
#define EXYNOS5430_DIV_STAT_EGL0			EXYNOS_CLKREG_EGL(0x0700)
#define EXYNOS5430_DIV_STAT_EGL1			EXYNOS_CLKREG_EGL(0x0704)
#define EXYNOS5430_DIV_STAT_EGL_PLL_FREQ_DET		EXYNOS_CLKREG_EGL(0x0708)
#define EXYNOS5430_DIV_AUD0				EXYNOS_CLKREG_AUD(0x0600)
#define EXYNOS5430_DIV_AUD1				EXYNOS_CLKREG_AUD(0x0604)
#define EXYNOS5430_DIV_AUD2				EXYNOS_CLKREG_AUD(0x0608)
#define EXYNOS5430_DIV_AUD3				EXYNOS_CLKREG_AUD(0x060C)
#define EXYNOS5430_DIV_AUD4				EXYNOS_CLKREG_AUD(0x0610)
#define EXYNOS5430_DIV_STAT_AUD0			EXYNOS_CLKREG_AUD(0x0700)
#define EXYNOS5430_DIV_STAT_AUD1			EXYNOS_CLKREG_AUD(0x0704)
#define EXYNOS5430_DIV_STAT_AUD2			EXYNOS_CLKREG_AUD(0x0708)
#define EXYNOS5430_DIV_STAT_AUD3			EXYNOS_CLKREG_AUD(0x070C)
#define EXYNOS5430_DIV_STAT_AUD4			EXYNOS_CLKREG_AUD(0x0710)
#define EXYNOS5430_DIV_BUS1				EXYNOS_CLKREG_BUS1(0x0600)
#define EXYNOS5430_DIV_STAT_BUS1			EXYNOS_CLKREG_BUS1(0x0700)
#define EXYNOS5430_DIV_BUS2				EXYNOS_CLKREG_BUS2(0x0600)
#define EXYNOS5430_DIV_STAT_BUS2			EXYNOS_CLKREG_BUS2(0x0700)
#define EXYNOS5430_DIV_CAM00				EXYNOS_CLKREG_CAM0(0x0600)
#define EXYNOS5430_DIV_CAM01				EXYNOS_CLKREG_CAM0(0x0604)
#define EXYNOS5430_DIV_CAM02				EXYNOS_CLKREG_CAM0(0x0608)
#define EXYNOS5430_DIV_CAM03				EXYNOS_CLKREG_CAM0(0x060C)
#define EXYNOS5430_DIV_STAT_CAM00			EXYNOS_CLKREG_CAM0(0x0700)
#define EXYNOS5430_DIV_STAT_CAM01			EXYNOS_CLKREG_CAM0(0x0704)
#define EXYNOS5430_DIV_STAT_CAM02			EXYNOS_CLKREG_CAM0(0x0708)
#define EXYNOS5430_DIV_STAT_CAM03			EXYNOS_CLKREG_CAM0(0x070C)
#define EXYNOS5430_DIV_CAM10				EXYNOS_CLKREG_CAM1(0x0600)
#define EXYNOS5430_DIV_CAM11				EXYNOS_CLKREG_CAM1(0x0604)
#define EXYNOS5430_DIV_STAT_CAM10			EXYNOS_CLKREG_CAM1(0x0700)
#define EXYNOS5430_DIV_STAT_CAM11			EXYNOS_CLKREG_CAM1(0x0704)
#define EXYNOS5430_DIV_CPIF				EXYNOS_CLKREG_CPIF(0x0600)
#define EXYNOS5430_DIV_CPIF_PLL_FREQ_DET		EXYNOS_CLKREG_CPIF(0x0608)
#define EXYNOS5430_DIV_STAT_CPIF			EXYNOS_CLKREG_CPIF(0x0700)
#define EXYNOS5430_DIV_STAT_CPIF_PLL_FREQ_DET		EXYNOS_CLKREG_CPIF(0x0708)
#define EXYNOS5430_DIV_DISP				EXYNOS_CLKREG_DISP(0x0600)
#define EXYNOS5430_DIV_DISP_PLL_FREQ_DET		EXYNOS_CLKREG_DISP(0x0604)
#define EXYNOS5430_DIV_STAT_DISP			EXYNOS_CLKREG_DISP(0x0700)
#define EXYNOS5430_DIV_STAT_DISP_PLL_FREQ_DET		EXYNOS_CLKREG_DISP(0x0704)
#define EXYNOS5430_DIV_G2D				EXYNOS_CLKREG_G2D(0x0600)
#define EXYNOS5430_DIV_STAT_G2D				EXYNOS_CLKREG_G2D(0x0700)
#define EXYNOS5430_DIV_G3D				EXYNOS_CLKREG_G3D(0x0600)
#define EXYNOS5430_DIV_G3D_PLL_FREQ_DET			EXYNOS_CLKREG_G3D(0x0604)
#define EXYNOS5430_DIV_STAT_G3D				EXYNOS_CLKREG_G3D(0x0700)
#define EXYNOS5430_DIV_STAT_G3D_PLL_FREQ_DET		EXYNOS_CLKREG_G3D(0x0704)
#define EXYNOS5430_DIV_HEVC				EXYNOS_CLKREG_HEVC(0x0600)
#define EXYNOS5430_DIV_STAT_HEVC			EXYNOS_CLKREG_HEVC(0x0700)
#define EXYNOS5430_DIV_ISP				EXYNOS_CLKREG_ISP(0x0600)
#define EXYNOS5430_DIV_STAT_ISP				EXYNOS_CLKREG_ISP(0x0700)
#define EXYNOS5430_DIV_MFC0				EXYNOS_CLKREG_MFC0(0x0600)
#define EXYNOS5430_DIV_STAT_MFC0			EXYNOS_CLKREG_MFC0(0x0700)
#define EXYNOS5430_DIV_MFC1				EXYNOS_CLKREG_MFC1(0x0600)
#define EXYNOS5430_DIV_STAT_MFC1			EXYNOS_CLKREG_MFC1(0x0700)
#define EXYNOS5430_DIV_MIF0				EXYNOS_CLKREG_MIF(0x0600)
#define EXYNOS5430_DIV_MIF1				EXYNOS_CLKREG_MIF(0x0604)
#define EXYNOS5430_DIV_MIF2				EXYNOS_CLKREG_MIF(0x0608)
#define EXYNOS5430_DIV_MIF3				EXYNOS_CLKREG_MIF(0x060C)
#define EXYNOS5430_DIV_MIF4				EXYNOS_CLKREG_MIF(0x0610)
#define EXYNOS5430_DIV_MIF5				EXYNOS_CLKREG_MIF(0x0614)
#define EXYNOS5430_DIV_MIF_PLL_FREQ_DET			EXYNOS_CLKREG_MIF(0x0618)
#define EXYNOS5430_DIV_STAT_MIF0			EXYNOS_CLKREG_MIF(0x0700)
#define EXYNOS5430_DIV_STAT_MIF1			EXYNOS_CLKREG_MIF(0x0704)
#define EXYNOS5430_DIV_STAT_MIF2			EXYNOS_CLKREG_MIF(0x0708)
#define EXYNOS5430_DIV_STAT_MIF3			EXYNOS_CLKREG_MIF(0x070C)
#define EXYNOS5430_DIV_STAT_MIF4			EXYNOS_CLKREG_MIF(0x0710)
#define EXYNOS5430_DIV_STAT_MIF5			EXYNOS_CLKREG_MIF(0x0714)
#define EXYNOS5430_DIV_STAT_MIF_PLL_FREQ_DET		EXYNOS_CLKREG_MIF(0x0718)
#define EXYNOS5430_DIV_MSCL				EXYNOS_CLKREG_MSCL(0x0600)
#define EXYNOS5430_DIV_STAT_MSCL			EXYNOS_CLKREG_MSCL(0x0700)
#define EXYNOS5430_DIV_TOP0				EXYNOS_CLKREG_TOP(0x0600)
#define EXYNOS5430_DIV_TOP1				EXYNOS_CLKREG_TOP(0x0604)
#define EXYNOS5430_DIV_TOP2				EXYNOS_CLKREG_TOP(0x0608)
#define EXYNOS5430_DIV_TOP3				EXYNOS_CLKREG_TOP(0x060C)
#define EXYNOS5430_DIV_TOP4				EXYNOS_CLKREG_TOP(0x0610)
#define EXYNOS5430_DIV_TOP_MSCL				EXYNOS_CLKREG_TOP(0x0618)
#define EXYNOS5430_DIV_TOP_CAM10			EXYNOS_CLKREG_TOP(0x061C)
#define EXYNOS5430_DIV_TOP_CAM11			EXYNOS_CLKREG_TOP(0x0620)
#define EXYNOS5430_DIV_TOP_FSYS0			EXYNOS_CLKREG_TOP(0x062C)
#define EXYNOS5430_DIV_TOP_FSYS1			EXYNOS_CLKREG_TOP(0x0630)
#define EXYNOS5430_DIV_TOP_FSYS2			EXYNOS_CLKREG_TOP(0x0634)
#define EXYNOS5430_DIV_TOP_PERIC0			EXYNOS_CLKREG_TOP(0x0638)
#define EXYNOS5430_DIV_TOP_PERIC1			EXYNOS_CLKREG_TOP(0x063C)
#define EXYNOS5430_DIV_TOP_PERIC2			EXYNOS_CLKREG_TOP(0x0640)
#define EXYNOS5430_DIV_TOP_PERIC3			EXYNOS_CLKREG_TOP(0x0644)
#define EXYNOS5430_DIV_TOP_PLL_FREQ_DET			EXYNOS_CLKREG_TOP(0x064C)
#define EXYNOS5430_DIV_STAT_TOP0			EXYNOS_CLKREG_TOP(0x0700)
#define EXYNOS5430_DIV_STAT_TOP1			EXYNOS_CLKREG_TOP(0x0704)
#define EXYNOS5430_DIV_STAT_TOP2			EXYNOS_CLKREG_TOP(0x0708)
#define EXYNOS5430_DIV_STAT_TOP3			EXYNOS_CLKREG_TOP(0x070C)
#define EXYNOS5430_DIV_STAT_TOP_MSCL			EXYNOS_CLKREG_TOP(0x0718)
#define EXYNOS5430_DIV_STAT_TOP_CAM10			EXYNOS_CLKREG_TOP(0x071C)
#define EXYNOS5430_DIV_STAT_TOP_CAM11			EXYNOS_CLKREG_TOP(0x0720)
#define EXYNOS5430_DIV_STAT_TOP_FSYS0			EXYNOS_CLKREG_TOP(0x072C)
#define EXYNOS5430_DIV_STAT_TOP_FSYS1			EXYNOS_CLKREG_TOP(0x0730)
#define EXYNOS5430_DIV_STAT_TOP_FSYS2			EXYNOS_CLKREG_TOP(0x0734)
#define EXYNOS5430_DIV_STAT_TOP_PERIC0			EXYNOS_CLKREG_TOP(0x0738)
#define EXYNOS5430_DIV_STAT_TOP_PERIC1			EXYNOS_CLKREG_TOP(0x073C)
#define EXYNOS5430_DIV_STAT_TOP_PERIC2			EXYNOS_CLKREG_TOP(0x0740)
#define EXYNOS5430_DIV_STAT_TOP_PERIC3			EXYNOS_CLKREG_TOP(0x0744)
#define EXYNOS5430_DIV_STAT_TOP_PLL_FREQ_DET		EXYNOS_CLKREG_TOP(0x074C)

#define EXYNOS5430_ENABLE_ACLK_KFC			EXYNOS_CLKREG_KFC(0x0800)
#define EXYNOS5430_ENABLE_PCLK_KFC			EXYNOS_CLKREG_KFC(0x0900)
#define EXYNOS5430_ENABLE_SCLK_KFC			EXYNOS_CLKREG_KFC(0x0A00)
#define EXYNOS5430_ENABLE_IP_KFC0			EXYNOS_CLKREG_KFC(0x0B00)
#define EXYNOS5430_ENABLE_IP_KFC1			EXYNOS_CLKREG_KFC(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_EGL			EXYNOS_CLKREG_EGL(0x0800)
#define EXYNOS5430_ENABLE_PCLK_EGL			EXYNOS_CLKREG_EGL(0x0900)
#define EXYNOS5430_ENABLE_SCLK_EGL			EXYNOS_CLKREG_EGL(0x0A00)
#define EXYNOS5430_ENABLE_IP_EGL0			EXYNOS_CLKREG_EGL(0x0B00)
#define EXYNOS5430_ENABLE_IP_EGL1			EXYNOS_CLKREG_EGL(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_AUD			EXYNOS_CLKREG_AUD(0x0800)
#define EXYNOS5430_ENABLE_PCLK_AUD			EXYNOS_CLKREG_AUD(0x0900)
#define EXYNOS5430_ENABLE_SCLK_AUD0			EXYNOS_CLKREG_AUD(0x0A00)
#define EXYNOS5430_ENABLE_SCLK_AUD1			EXYNOS_CLKREG_AUD(0x0A04)
#define EXYNOS5430_ENABLE_IP_AUD0			EXYNOS_CLKREG_AUD(0x0B00)
#define EXYNOS5430_ENABLE_IP_AUD1			EXYNOS_CLKREG_AUD(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_BUS1			EXYNOS_CLKREG_BUS1(0x0800)
#define EXYNOS5430_ENABLE_PCLK_BUS1			EXYNOS_CLKREG_BUS1(0x0900)
#define EXYNOS5430_ENABLE_IP_BUS10			EXYNOS_CLKREG_BUS1(0x0B00)
#define EXYNOS5430_ENABLE_IP_BUS11			EXYNOS_CLKREG_BUS1(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_BUS2			EXYNOS_CLKREG_BUS2(0x0800)
#define EXYNOS5430_ENABLE_PCLK_BUS2			EXYNOS_CLKREG_BUS2(0x0900)
#define EXYNOS5430_ENABLE_IP_BUS20			EXYNOS_CLKREG_BUS2(0x0B00)
#define EXYNOS5430_ENABLE_IP_BUS21			EXYNOS_CLKREG_BUS2(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_CAM00			EXYNOS_CLKREG_CAM0(0x0800)
#define EXYNOS5430_ENABLE_ACLK_CAM01			EXYNOS_CLKREG_CAM0(0x0804)
#define EXYNOS5430_ENABLE_ACLK_CAM02			EXYNOS_CLKREG_CAM0(0x0808)
#define EXYNOS5430_ENABLE_PCLK_CAM0			EXYNOS_CLKREG_CAM0(0x0900)
#define EXYNOS5430_ENABLE_SCLK_CAM0			EXYNOS_CLKREG_CAM0(0x0A00)
#define EXYNOS5430_ENABLE_IP_CAM00			EXYNOS_CLKREG_CAM0(0x0B00)
#define EXYNOS5430_ENABLE_IP_CAM01			EXYNOS_CLKREG_CAM0(0x0B04)
#define EXYNOS5430_ENABLE_IP_CAM02			EXYNOS_CLKREG_CAM0(0x0B08)
#define EXYNOS5430_ENABLE_IP_CAM03			EXYNOS_CLKREG_CAM0(0x0B0C)
#define EXYNOS5430_ENABLE_ACLK_CAM0_LOCAL		EXYNOS_CLKREG_CAM0_LOCAL(0x0800)
#define EXYNOS5430_ENABLE_PCLK_CAM0_LOCAL		EXYNOS_CLKREG_CAM0_LOCAL(0x0900)
#define EXYNOS5430_ENABLE_SCLK_CAM0_LOCAL		EXYNOS_CLKREG_CAM0_LOCAL(0x0A00)
#define EXYNOS5430_ENABLE_IP_CAM0_LOCAL0		EXYNOS_CLKREG_CAM0_LOCAL(0x0B00)
#define EXYNOS5430_ENABLE_IP_CAM0_LOCAL1		EXYNOS_CLKREG_CAM0_LOCAL(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_CAM10			EXYNOS_CLKREG_CAM1(0x0800)
#define EXYNOS5430_ENABLE_ACLK_CAM11			EXYNOS_CLKREG_CAM1(0x0804)
#define EXYNOS5430_ENABLE_ACLK_CAM12			EXYNOS_CLKREG_CAM1(0x0808)
#define EXYNOS5430_ENABLE_PCLK_CAM1			EXYNOS_CLKREG_CAM1(0x0900)
#define EXYNOS5430_ENABLE_SCLK_CAM1			EXYNOS_CLKREG_CAM1(0x0A00)
#define EXYNOS5430_ENABLE_IP_CAM10			EXYNOS_CLKREG_CAM1(0x0B00)
#define EXYNOS5430_ENABLE_IP_CAM11			EXYNOS_CLKREG_CAM1(0x0B04)
#define EXYNOS5430_ENABLE_IP_CAM12			EXYNOS_CLKREG_CAM1(0x0B08)
#define EXYNOS5430_ENABLE_ACLK_CAM1_LOCAL		EXYNOS_CLKREG_CAM1_LOCAL(0x0800)
#define EXYNOS5430_ENABLE_PCLK_CAM1_LOCAL		EXYNOS_CLKREG_CAM1_LOCAL(0x0900)
#define EXYNOS5430_ENABLE_SCLK_CAM1_LOCAL		EXYNOS_CLKREG_CAM1_LOCAL(0x0A00)
#define EXYNOS5430_ENABLE_IP_CAM1_LOCAL0		EXYNOS_CLKREG_CAM1_LOCAL(0x0B00)
#define EXYNOS5430_ENABLE_IP_CAM1_LOCAL1		EXYNOS_CLKREG_CAM1_LOCAL(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_CPIF			EXYNOS_CLKREG_CPIF(0x0800)
#define EXYNOS5430_ENABLE_PCLK_CPIF			EXYNOS_CLKREG_CPIF(0x0900)
#define EXYNOS5430_ENABLE_SCLK_CPIF			EXYNOS_CLKREG_CPIF(0x0A00)
#define EXYNOS5430_ENABLE_IP_CPIF0			EXYNOS_CLKREG_CPIF(0x0B00)
#define EXYNOS5430_ENABLE_IP_CPIF1			EXYNOS_CLKREG_CPIF(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_DISP0			EXYNOS_CLKREG_DISP(0x0800)
#define EXYNOS5430_ENABLE_ACLK_DISP1			EXYNOS_CLKREG_DISP(0x0804)
#define EXYNOS5430_ENABLE_PCLK_DISP			EXYNOS_CLKREG_DISP(0x0900)
#define EXYNOS5430_ENABLE_SCLK_DISP			EXYNOS_CLKREG_DISP(0x0A00)
#define EXYNOS5430_ENABLE_IP_DISP0			EXYNOS_CLKREG_DISP(0x0B00)
#define EXYNOS5430_ENABLE_IP_DISP1			EXYNOS_CLKREG_DISP(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_FSYS0			EXYNOS_CLKREG_FSYS(0x0800)
#define EXYNOS5430_ENABLE_ACLK_FSYS1			EXYNOS_CLKREG_FSYS(0x0804)
#define EXYNOS5430_ENABLE_PCLK_FSYS			EXYNOS_CLKREG_FSYS(0x0900)
#define EXYNOS5430_ENABLE_SCLK_FSYS			EXYNOS_CLKREG_FSYS(0x0A00)
#define EXYNOS5430_ENABLE_IP_FSYS0			EXYNOS_CLKREG_FSYS(0x0B00)
#define EXYNOS5430_ENABLE_IP_FSYS1			EXYNOS_CLKREG_FSYS(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_G2D			EXYNOS_CLKREG_G2D(0x0800)
#define EXYNOS5430_ENABLE_ACLK_G2D_SECURE_SMMU_G2D	EXYNOS_CLKREG_G2D(0x0804)
#define EXYNOS5430_ENABLE_PCLK_G2D			EXYNOS_CLKREG_G2D(0x0900)
#define EXYNOS5430_ENABLE_PCLK_G2D_SECURE_SMMU_G2D	EXYNOS_CLKREG_G2D(0x0904)
#define EXYNOS5430_ENABLE_IP_G2D0			EXYNOS_CLKREG_G2D(0x0B00)
#define EXYNOS5430_ENABLE_IP_G2D1			EXYNOS_CLKREG_G2D(0x0B04)
#define EXYNOS5430_ENABLE_IP_G2D_SECURE_SMMU_G2D	EXYNOS_CLKREG_G2D(0x0B08)
#define EXYNOS5430_ENABLE_ACLK_G3D			EXYNOS_CLKREG_G3D(0x0800)
#define EXYNOS5430_ENABLE_PCLK_G3D			EXYNOS_CLKREG_G3D(0x0900)
#define EXYNOS5430_ENABLE_SCLK_G3D			EXYNOS_CLKREG_G3D(0x0A00)
#define EXYNOS5430_ENABLE_IP_G3D0			EXYNOS_CLKREG_G3D(0x0B00)
#define EXYNOS5430_ENABLE_IP_G3D1			EXYNOS_CLKREG_G3D(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_GSCL			EXYNOS_CLKREG_GSCL(0x0800)
#define EXYNOS5430_ENABLE_ACLK_GSCL_SECURE_SMMU_GSCL0	EXYNOS_CLKREG_GSCL(0x0804)
#define EXYNOS5430_ENABLE_ACLK_GSCL_SECURE_SMMU_GSCL1	EXYNOS_CLKREG_GSCL(0x0808)
#define EXYNOS5430_ENABLE_ACLK_GSCL_SECURE_SMMU_GSCL2	EXYNOS_CLKREG_GSCL(0x080C)
#define EXYNOS5430_ENABLE_PCLK_GSCL			EXYNOS_CLKREG_GSCL(0x0900)
#define EXYNOS5430_ENABLE_PCLK_GSCL_SECURE_SMMU_GSCL0	EXYNOS_CLKREG_GSCL(0x0904)
#define EXYNOS5430_ENABLE_PCLK_GSCL_SECURE_SMMU_GSCL1	EXYNOS_CLKREG_GSCL(0x0908)
#define EXYNOS5430_ENABLE_PCLK_GSCL_SECURE_SMMU_GSCL2	EXYNOS_CLKREG_GSCL(0x090C)
#define EXYNOS5430_ENABLE_IP_GSCL0			EXYNOS_CLKREG_GSCL(0x0B00)
#define EXYNOS5430_ENABLE_IP_GSCL1			EXYNOS_CLKREG_GSCL(0x0B04)
#define EXYNOS5430_ENABLE_IP_GSCL_SECURE_SMMU_GSCL0	EXYNOS_CLKREG_GSCL(0x0B08)
#define EXYNOS5430_ENABLE_IP_GSCL_SECURE_SMMU_GSCL1	EXYNOS_CLKREG_GSCL(0x0B0C)
#define EXYNOS5430_ENABLE_IP_GSCL_SECURE_SMMU_GSCL2	EXYNOS_CLKREG_GSCL(0x0B10)
#define EXYNOS5430_ENABLE_ACLK_HEVC			EXYNOS_CLKREG_HEVC(0x0800)
#define EXYNOS5430_ENABLE_ACLK_HEVC_SECURE_SMMU_HEVC	EXYNOS_CLKREG_HEVC(0x0804)
#define EXYNOS5430_ENABLE_PCLK_HEVC			EXYNOS_CLKREG_HEVC(0x0900)
#define EXYNOS5430_ENABLE_PCLK_HEVC_SECURE_SMMU_HEVC	EXYNOS_CLKREG_HEVC(0x0904)
#define EXYNOS5430_ENABLE_IP_HEVC0			EXYNOS_CLKREG_HEVC(0x0B00)
#define EXYNOS5430_ENABLE_IP_HEVC1			EXYNOS_CLKREG_HEVC(0x0B04)
#define EXYNOS5430_ENABLE_IP_HEVC_SECURE_SMMU_HEVC	EXYNOS_CLKREG_HEVC(0x0B08)
#define EXYNOS5430_ENABLE_ACLK_IMEM			EXYNOS_CLKREG_IMEM(0x0800)
#define EXYNOS5430_ENABLE_ACLK_IMEM_SECURE_INT_MEM	EXYNOS_CLKREG_IMEM(0x0804)
#define EXYNOS5430_ENABLE_ACLK_IMEM_SECURE_SSS		EXYNOS_CLKREG_IMEM(0x0808)
#define EXYNOS5430_ENABLE_ACLK_IMEM_SECURE_SLIMSSS	EXYNOS_CLKREG_IMEM(0x080C)
#define EXYNOS5430_ENABLE_ACLK_IMEM_SECURE_RTIC		EXYNOS_CLKREG_IMEM(0x0810)
#define EXYNOS5430_ENABLE_ACLK_IMEM_SECURE_SMMU_SSS	EXYNOS_CLKREG_IMEM(0x0814)
#define EXYNOS5430_ENABLE_ACLK_IMEM_SECURE_SMMU_SLIMSSS	EXYNOS_CLKREG_IMEM(0x0818)
#define EXYNOS5430_ENABLE_ACLK_IMEM_SECURE_SMMU_RTIC	EXYNOS_CLKREG_IMEM(0x081C)
#define EXYNOS5430_ENABLE_PCLK_IMEM			EXYNOS_CLKREG_IMEM(0x0900)
#define EXYNOS5430_ENABLE_PCLK_IMEM_SECURE_SSS		EXYNOS_CLKREG_IMEM(0x0904)
#define EXYNOS5430_ENABLE_PCLK_IMEM_SECURE_SLIMSSS	EXYNOS_CLKREG_IMEM(0x0908)
#define EXYNOS5430_ENABLE_PCLK_IMEM_SECURE_RTIC		EXYNOS_CLKREG_IMEM(0x090C)
#define EXYNOS5430_ENABLE_PCLK_IMEM_SECURE_SMMU_SSS	EXYNOS_CLKREG_IMEM(0x0910)
#define EXYNOS5430_ENABLE_PCLK_IMEM_SECURE_SMMU_SLIMSSS	EXYNOS_CLKREG_IMEM(0x0914)
#define EXYNOS5430_ENABLE_PCLK_IMEM_SECURE_SMMU_RTIC	EXYNOS_CLKREG_IMEM(0x0918)
#define EXYNOS5430_ENABLE_IP_IMEM0			EXYNOS_CLKREG_IMEM(0x0B00)
#define EXYNOS5430_ENABLE_IP_IMEM1			EXYNOS_CLKREG_IMEM(0x0B04)
#define EXYNOS5430_ENABLE_IP_IMEM_SECURE_INT_MEM	EXYNOS_CLKREG_IMEM(0x0B08)
#define EXYNOS5430_ENABLE_IP_IMEM_SECURE_SSS		EXYNOS_CLKREG_IMEM(0x0B0C)
#define EXYNOS5430_ENABLE_IP_IMEM_SECURE_SLIMSSS	EXYNOS_CLKREG_IMEM(0x0B10)
#define EXYNOS5430_ENABLE_IP_IMEM_SECURE_RTIC		EXYNOS_CLKREG_IMEM(0x0B14)
#define EXYNOS5430_ENABLE_IP_IMEM_SECURE_SMMU_SSS	EXYNOS_CLKREG_IMEM(0x0B18)
#define EXYNOS5430_ENABLE_IP_IMEM_SECURE_SMMU_SLIMSSS	EXYNOS_CLKREG_IMEM(0x0B1C)
#define EXYNOS5430_ENABLE_IP_IMEM_SECURE_SMMU_RTIC	EXYNOS_CLKREG_IMEM(0x0B20)
#define EXYNOS5430_ENABLE_ACLK_ISP0			EXYNOS_CLKREG_ISP(0x0800)
#define EXYNOS5430_ENABLE_ACLK_ISP1			EXYNOS_CLKREG_ISP(0x0804)
#define EXYNOS5430_ENABLE_ACLK_ISP2			EXYNOS_CLKREG_ISP(0x0808)
#define EXYNOS5430_ENABLE_PCLK_ISP			EXYNOS_CLKREG_ISP(0x0900)
#define EXYNOS5430_ENABLE_SCLK_ISP			EXYNOS_CLKREG_ISP(0x0A00)
#define EXYNOS5430_ENABLE_IP_ISP0			EXYNOS_CLKREG_ISP(0x0B00)
#define EXYNOS5430_ENABLE_IP_ISP1			EXYNOS_CLKREG_ISP(0x0B04)
#define EXYNOS5430_ENABLE_IP_ISP2			EXYNOS_CLKREG_ISP(0x0B08)
#define EXYNOS5430_ENABLE_IP_ISP3			EXYNOS_CLKREG_ISP(0x0B0C)
#define EXYNOS5430_ENABLE_ACLK_ISP_LOCAL		EXYNOS_CLKREG_ISP_LOCAL(0x0800)
#define EXYNOS5430_ENABLE_PCLK_ISP_LOCAL		EXYNOS_CLKREG_ISP_LOCAL(0x0900)
#define EXYNOS5430_ENABLE_SCLK_ISP_LOCAL		EXYNOS_CLKREG_ISP_LOCAL(0x0A00)
#define EXYNOS5430_ENABLE_IP_ISP_LOCAL0			EXYNOS_CLKREG_ISP_LOCAL(0x0B00)
#define EXYNOS5430_ENABLE_IP_ISP_LOCAL1			EXYNOS_CLKREG_ISP_LOCAL(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_MFC0			EXYNOS_CLKREG_MFC0(0x0800)
#define EXYNOS5430_ENABLE_ACLK_MFC0_SECURE_SMMU_MFC	EXYNOS_CLKREG_MFC0(0x0804)
#define EXYNOS5430_ENABLE_PCLK_MFC0			EXYNOS_CLKREG_MFC0(0x0900)
#define EXYNOS5430_ENABLE_PCLK_MFC0_SECURE_SMMU_MFC	EXYNOS_CLKREG_MFC0(0x0904)
#define EXYNOS5430_ENABLE_IP_MFC00			EXYNOS_CLKREG_MFC0(0x0B00)
#define EXYNOS5430_ENABLE_IP_MFC01			EXYNOS_CLKREG_MFC0(0x0B04)
#define EXYNOS5430_ENABLE_IP_MFC0_SECURE_SMMU_MFC	EXYNOS_CLKREG_MFC0(0x0B08)
#define EXYNOS5430_ENABLE_ACLK_MFC1			EXYNOS_CLKREG_MFC1(0x0800)
#define EXYNOS5430_ENABLE_ACLK_MFC1_SECURE_SMMU_MFC	EXYNOS_CLKREG_MFC1(0x0804)
#define EXYNOS5430_ENABLE_PCLK_MFC1			EXYNOS_CLKREG_MFC1(0x0900)
#define EXYNOS5430_ENABLE_PCLK_MFC1_SECURE_SMMU_MFC	EXYNOS_CLKREG_MFC1(0x0904)
#define EXYNOS5430_ENABLE_IP_MFC10			EXYNOS_CLKREG_MFC1(0x0B00)
#define EXYNOS5430_ENABLE_IP_MFC11			EXYNOS_CLKREG_MFC1(0x0B04)
#define EXYNOS5430_ENABLE_IP_MFC1_SECURE_SMMU_MFC	EXYNOS_CLKREG_MFC1(0x0B08)
#define EXYNOS5430_ENABLE_ACLK_MIF0			EXYNOS_CLKREG_MIF(0x0800)
#define EXYNOS5430_ENABLE_ACLK_MIF1			EXYNOS_CLKREG_MIF(0x0804)
#define EXYNOS5430_ENABLE_ACLK_MIF2			EXYNOS_CLKREG_MIF(0x0808)
#define EXYNOS5430_ENABLE_ACLK_MIF3			EXYNOS_CLKREG_MIF(0x080C)
#define EXYNOS5430_ENABLE_PCLK_MIF			EXYNOS_CLKREG_MIF(0x0900)
#define EXYNOS5430_ENABLE_PCLK_MIF_SECURE_DREX0_TZ	EXYNOS_CLKREG_MIF(0x0904)
#define EXYNOS5430_ENABLE_PCLK_MIF_SECURE_DREX1_TZ	EXYNOS_CLKREG_MIF(0x0908)
#define EXYNOS5430_ENABLE_PCLK_MIF_SECURE_MONOTONIC_CNT	EXYNOS_CLKREG_MIF(0x090C)
#define EXYNOS5430_ENABLE_PCLK_MIF_SECURE_RTC		EXYNOS_CLKREG_MIF(0x0910)
#define EXYNOS5430_ENABLE_SCLK_MIF			EXYNOS_CLKREG_MIF(0x0A00)
#define EXYNOS5430_ENABLE_IP_MIF0			EXYNOS_CLKREG_MIF(0x0B00)
#define EXYNOS5430_ENABLE_IP_MIF1			EXYNOS_CLKREG_MIF(0x0B04)
#define EXYNOS5430_ENABLE_IP_MIF2			EXYNOS_CLKREG_MIF(0x0B08)
#define EXYNOS5430_ENABLE_IP_MIF3			EXYNOS_CLKREG_MIF(0x0B0C)
#define EXYNOS5430_ENABLE_IP_MIF_SECURE_DREX0_TZ	EXYNOS_CLKREG_MIF(0x0B10)
#define EXYNOS5430_ENABLE_IP_MIF_SECURE_DREX1_TZ	EXYNOS_CLKREG_MIF(0x0B14)
#define EXYNOS5430_ENABLE_IP_MIF_SECURE_MONOTONIC_CNT	EXYNOS_CLKREG_MIF(0x0B18)
#define EXYNOS5430_ENABLE_IP_MIF_SECURE_RTC		EXYNOS_CLKREG_MIF(0x0B1C)
#define EXYNOS5430_ENABLE_ACLK_MSCL			EXYNOS_CLKREG_MSCL(0x0800)
#define EXYNOS5430_ENABLE_ACLK_MSCL_SECURE_SMMU_M2MSCALER0	EXYNOS_CLKREG_MSCL(0x0804)
#define EXYNOS5430_ENABLE_ACLK_MSCL_SECURE_SMMU_M2MSCALER1	EXYNOS_CLKREG_MSCL(0x0808)
#define EXYNOS5430_ENABLE_ACLK_MSCL_SECURE_SMMU_JPEG		EXYNOS_CLKREG_MSCL(0x080C)
#define EXYNOS5430_ENABLE_PCLK_MSCL			EXYNOS_CLKREG_MSCL(0x0900)
#define EXYNOS5430_ENABLE_PCLK_MSCL_SECURE_SMMU_M2MSCALER0	EXYNOS_CLKREG_MSCL(0x0904)
#define EXYNOS5430_ENABLE_PCLK_MSCL_SECURE_SMMU_M2MSCALER1	EXYNOS_CLKREG_MSCL(0x0908)
#define EXYNOS5430_ENABLE_PCLK_MSCL_SECURE_SMMU_JPEG		EXYNOS_CLKREG_MSCL(0x090C)
#define EXYNOS5430_ENABLE_SCLK_MSCL			EXYNOS_CLKREG_MSCL(0x0A00)
#define EXYNOS5430_ENABLE_IP_MSCL0			EXYNOS_CLKREG_MSCL(0x0B00)
#define EXYNOS5430_ENABLE_IP_MSCL1			EXYNOS_CLKREG_MSCL(0x0B04)
#define EXYNOS5430_ENABLE_IP_MSCL_SECURE_SMMU_M2MSCALER0	EXYNOS_CLKREG_MSCL(0x0B08)
#define EXYNOS5430_ENABLE_IP_MSCL_SECURE_SMMU_M2MSCALER1	EXYNOS_CLKREG_MSCL(0x0B0C)
#define EXYNOS5430_ENABLE_IP_MSCL_SECURE_SMMU_JPEG		EXYNOS_CLKREG_MSCL(0x0B10)
#define EXYNOS5430_ENABLE_ACLK_PERIC			EXYNOS_CLKREG_PERIC(0x0800)
#define EXYNOS5430_ENABLE_PCLK_PERIC			EXYNOS_CLKREG_PERIC(0x0900)
#define EXYNOS5430_ENABLE_SCLK_PERIC			EXYNOS_CLKREG_PERIC(0x0A00)
#define EXYNOS5430_ENABLE_IP_PERIC0			EXYNOS_CLKREG_PERIC(0x0B00)
#define EXYNOS5430_ENABLE_IP_PERIC1			EXYNOS_CLKREG_PERIC(0x0B04)
#define EXYNOS5430_ENABLE_ACLK_PERIS			EXYNOS_CLKREG_PERIS(0x0800)
#define EXYNOS5430_ENABLE_PCLK_PERIS			EXYNOS_CLKREG_PERIS(0x0900)
#define EXYNOS5430_ENABLE_PCLK_PERIS_SECURE_TZPC	EXYNOS_CLKREG_PERIS(0x0904)
#define EXYNOS5430_ENABLE_PCLK_PERIS_SECURE_SECKEY_APBIF	EXYNOS_CLKREG_PERIS(0x0908)
#define EXYNOS5430_ENABLE_PCLK_PERIS_SECURE_CHIPID_APBIF	EXYNOS_CLKREG_PERIS(0x090C)
#define EXYNOS5430_ENABLE_PCLK_PERIS_SECURE_TOPRTC		EXYNOS_CLKREG_PERIS(0x0910)
#define EXYNOS5430_ENABLE_PCLK_PERIS_SECURE_CUSTOM_EFUSE_APBIF	EXYNOS_CLKREG_PERIS(0x0914)
#define EXYNOS5430_ENABLE_PCLK_PERIS_SECURE_ANTIRBK_CNT_APBIF	EXYNOS_CLKREG_PERIS(0x0918)
#define EXYNOS5430_ENABLE_SCLK_PERIS			EXYNOS_CLKREG_PERIS(0x0A00)
#define EXYNOS5430_ENABLE_SCLK_PERIS_SECURE_SECKEY	EXYNOS_CLKREG_PERIS(0x0A04)
#define EXYNOS5430_ENABLE_SCLK_PERIS_SECURE_CHIPID	EXYNOS_CLKREG_PERIS(0x0A08)
#define EXYNOS5430_ENABLE_SCLK_PERIS_SECURE_TOPRTC	EXYNOS_CLKREG_PERIS(0x0A0C)
#define EXYNOS5430_ENABLE_SCLK_PERIS_SECURE_CUSTOM_EFUSE	EXYNOS_CLKREG_PERIS(0x0A10)
#define EXYNOS5430_ENABLE_SCLK_PERIS_SECURE_ANTIRBK_CNT		EXYNOS_CLKREG_PERIS(0x0A14)
#define EXYNOS5430_ENABLE_IP_PERIS0			EXYNOS_CLKREG_PERIS(0x0B00)
#define EXYNOS5430_ENABLE_IP_PERIS1			EXYNOS_CLKREG_PERIS(0x0B04)
#define EXYNOS5430_ENABLE_IP_PERIS_SECURE_TZPC		EXYNOS_CLKREG_PERIS(0x0B08)
#define EXYNOS5430_ENABLE_IP_PERIS_SECURE_SECKEY	EXYNOS_CLKREG_PERIS(0x0B0C)
#define EXYNOS5430_ENABLE_IP_PERIS_SECURE_CHIPID	EXYNOS_CLKREG_PERIS(0x0B10)
#define EXYNOS5430_ENABLE_IP_PERIS_SECURE_TOPRTC	EXYNOS_CLKREG_PERIS(0x0B14)
#define EXYNOS5430_ENABLE_IP_PERIS_SECURE_CUSTOM_EFUSE	EXYNOS_CLKREG_PERIS(0x0B18)
#define EXYNOS5430_ENABLE_IP_PERIS_SECURE_ANTIRBK_CNT	EXYNOS_CLKREG_PERIS(0x0B1C)
#define EXYNOS5430_ENABLE_ACLK_TOP			EXYNOS_CLKREG_TOP(0x0800)
#define EXYNOS5430_ENABLE_SCLK_TOP			EXYNOS_CLKREG_TOP(0x0A00)
#define EXYNOS5430_ENABLE_SCLK_TOP_MSCL			EXYNOS_CLKREG_TOP(0x0A04)
#define EXYNOS5430_ENABLE_SCLK_TOP_CAM1			EXYNOS_CLKREG_TOP(0x0A08)
#define EXYNOS5430_ENABLE_SCLK_TOP_DISP			EXYNOS_CLKREG_TOP(0x0A0C)
#define EXYNOS5430_ENABLE_SCLK_TOP_FSYS			EXYNOS_CLKREG_TOP(0x0A10)
#define EXYNOS5430_ENABLE_SCLK_TOP_PERIC		EXYNOS_CLKREG_TOP(0x0A14)
#define EXYNOS5430_ENABLE_IP_TOP			EXYNOS_CLKREG_TOP(0x0B00)

#define EXYNOS5430_CLKOUT_CMU_EGL			EXYNOS_CLKREG_EGL(0x0C00)
#define EXYNOS5430_CLKOUT_CMU_KFC			EXYNOS_CLKREG_KFC(0x0C00)

#define EXYNOS5430_EGL_PWR_CTRL				EXYNOS_CLKREG_EGL(0x1020)
#define EXYNOS5430_EGL_PWR_CTRL2			EXYNOS_CLKREG_EGL(0x1024)
#define EXYNOS5430_KFC_PWR_CTRL				EXYNOS_CLKREG_KFC(0x1020)
#define EXYNOS5430_KFC_PWR_CTRL2			EXYNOS_CLKREG_KFC(0x1024)
#define EXYNOS5430_EGL2_RATIO_SHIFT			(24)
#define EXYNOS5430_EGL2_RATIO				(0x7 << EXYNOS5430_EGL2_RATIO_SHIFT)
#define EXYNOS5430_EGL1_RATIO_SHIFT			(20)
#define EXYNOS5430_EGL1_RATIO				(0x7 << EXYNOS5430_EGL1_RATIO_SHIFT)
#define EXYNOS5430_DIVEGL2_DOWN_ENABLE_SHIFT		(17)
#define EXYNOS5430_DIVEGL2_DOWN_ENABLE			(0x1 << EXYNOS5430_DIVEGL2_DOWN_ENABLE_SHIFT)
#define EXYNOS5430_DIVEGL1_DOWN_ENABLE_SHIFT		(16)
#define EXYNOS5430_DIVEGL1_DOWN_ENABLE			(0x1 << EXYNOS5430_DIVEGL1_DOWN_ENABLE_SHIFT)
#define EXYNOS5430_USE_EGL_CLAMPCOREOUT_SHIFT		(13)
#define EXYNOS5430_USE_EGL_CLAMPCOREOUT			(0x1 << EXYNOS5430_USE_EGL_CLAMPCOREOUT_SHIFT)
#define EXYNOS5430_USE_STANDBYWFIL2_EGL_SHIFT		(12)
#define EXYNOS5430_USE_STANDBYWFIL2_EGL			(0x1 << EXYNOS5430_USE_STANDBYWFIL2_EGL_SHIFT)
#define EXYNOS5430_DIVEGL2_UP_ENABLE_SHIFT		(25)
#define EXYNOS5430_DIVEGL2_UP_ENABLE			(0x1 << EXYNOS5430_DIVEGL2_UP_ENABLE_SHIFT)
#define EXYNOS5430_DIVEGL1_UP_ENABLE_SHIFT		(24)
#define EXYNOS5430_DIVEGL1_UP_ENABLE			(0x1 << EXYNOS5430_DIVEGL1_UP_ENABLE_SHIFT)
#define EXYNOS5430_DUR_STANDBY2_SHIFT			(16)
#define EXYNOS5430_DUR_STANDBY2				(0xFF << EXYNOS5430_DUR_STANDBY2_SHIFT)
#define EXYNOS5430_DUR_STANDBY2_VALUE			(0xF << EXYNOS5430_DUR_STANDBY2_SHIFT)
#define EXYNOS5430_DUR_STANDBY1_SHIFT			(8)
#define EXYNOS5430_DUR_STANDBY1				(0xFF << EXYNOS5430_DUR_STANDBY1_SHIFT)
#define EXYNOS5430_DUR_STANDBY1_VALUE			(0xF << EXYNOS5430_DUR_STANDBY1_SHIFT)
#define EXYNOS5430_UP_EGL2_RATIO_SHIFT			(4)
#define EXYNOS5430_UP_EGL2_RATIO			(0x3 << EXYNOS5430_UP_EGL2_RATIO_SHIFT)
#define EXYNOS5430_UP_EGL1_RATIO_SHIFT			(0)
#define EXYNOS5430_UP_EGL1_RATIO			(0x3 << EXYNOS5430_UP_EGL1_RATIO_SHIFT)

#define PLL2450X_PMS(MDIV, PDIV, SDIV)	\
(	\
	(MDIV << EXYNOS5430_PLL_MDIV_SHIFT) |	\
	(PDIV << EXYNOS5430_PLL_PDIV_SHIFT) |	\
	(SDIV << EXYNOS5430_PLL_SDIV_SHIFT)	\
)

#define EXYNOS5430_PLL_MDIV_SHIFT			(16)
#define EXYNOS5430_PLL_MDIV_MASK			(0x3FF << EXYNOS5430_PLL_MDIV_SHIFT)
#define EXYNOS5430_PLL_PDIV_SHIFT			(8)
#define EXYNOS5430_PLL_PDIV_MASK			(0x3F << EXYNOS5430_PLL_PDIV_SHIFT)
#define EXYNOS5430_PLL_SDIV_SHIFT			(0)
#define EXYNOS5430_PLL_SDIV_MASK			(0x7 << EXYNOS5430_PLL_SDIV_SHIFT)
#define EXYNOS5430_PLL_KDIV_SHIFT			(0)
#define EXYNOS5430_PLL_KDIV_MASK			(0xFFFF << EXYNOS5430_PLL_KDIV_SHIFT)
#define EXYNOS5430_PLL_BYPASS_SHIFT			(22)
#define EXYNOS5430_PLL_BYPASS_MASK			(0x1 << EXYNOS5430_PLL_BYPASS_SHIFT)

#define EXYNOS5430_EGL_PLL_CON0_LOCKED_SHIFT		(29)

#ifdef CONFIG_SOC_EXYNOS5430_REV_0
#define EXYNOS5430_SRC_STAT_EGL2_EGL2_SHIFT		(4)
#define EXYNOS5430_SRC_STAT_EGL2_EGL2_MASK		(0x7 << EXYNOS5430_SRC_STAT_EGL2_EGL2_SHIFT)
#else
#define EXYNOS5430_SRC_STAT_EGL2_EGL_SHIFT		(0)
#define EXYNOS5430_SRC_STAT_EGL2_EGL_MASK		(0x7 << EXYNOS5430_SRC_STAT_EGL2_EGL_SHIFT)
#endif

#define EXYNOS5430_DIV_EGL0_EGL1_SHIFT			(0)
#define EXYNOS5430_DIV_EGL0_EGL1_MASK			(0x7 << EXYNOS5430_DIV_EGL0_EGL1_SHIFT)
#define EXYNOS5430_DIV_EGL0_EGL2_SHIFT			(4)
#define EXYNOS5430_DIV_EGL0_EGL2_MASK			(0x7 << EXYNOS5430_DIV_EGL0_EGL2_SHIFT)
#define EXYNOS5430_DIV_EGL0_ACLK_EGL_SHIFT		(8)
#define EXYNOS5430_DIV_EGL0_ACLK_EGL_MASK		(0x7 << EXYNOS5430_DIV_EGL0_ACLK_EGL_SHIFT)
#define EXYNOS5430_DIV_EGL0_PCLK_EGL_SHIFT		(12)
#define EXYNOS5430_DIV_EGL0_PCLK_EGL_MASK		(0x7 << EXYNOS5430_DIV_EGL0_PCLK_EGL_SHIFT)
#define EXYNOS5430_DIV_EGL0_ATCLK_EGL_SHIFT		(16)

#ifdef CONFIG_SOC_EXYNOS5430_REV_0
#define EXYNOS5430_DIV_EGL0_ATCLK_EGL_MASK		(0x7 << EXYNOS5430_DIV_EGL0_ATCLK_EGL_SHIFT)
#else
#define EXYNOS5430_DIV_EGL0_ATCLK_EGL_MASK		(0xF << EXYNOS5430_DIV_EGL0_ATCLK_EGL_SHIFT)
#endif

#define EXYNOS5430_DIV_EGL0_PCLK_DBG_EGL_SHIFT		(20)
#define EXYNOS5430_DIV_EGL0_PCLK_DBG_EGL_MASK		(0x7 << EXYNOS5430_DIV_EGL0_PCLK_DBG_EGL_SHIFT)
#define EXYNOS5430_DIV_EGL1_EGL_PLL_SHIFT		(0)
#define EXYNOS5430_DIV_EGL1_EGL_PLL_MASK		(0x7 << EXYNOS5430_DIV_EGL1_EGL_PLL_SHIFT)
#define EXYNOS5430_DIV_EGL1_SCLK_HPM_EGL_SHIFT		(4)
#define EXYNOS5430_DIV_EGL1_SCLK_HPM_EGL_MASK		(0x7 << EXYNOS5430_DIV_EGL1_SCLK_HPM_EGL_SHIFT)

#define EXYNOS5430_KFC_PLL_CON0_LOCKED_SHIFT		(29)
#define EXYNOS5430_SRC_STAT_KFC2_KFC_SHIFT		(0)
#define EXYNOS5430_SRC_STAT_KFC2_KFC_MASK		(0x7 << EXYNOS5430_SRC_STAT_KFC2_KFC_SHIFT)
#define EXYNOS5430_DIV_KFC0_KFC1_SHIFT			(0)
#define EXYNOS5430_DIV_KFC0_KFC1_MASK			(0x7 << EXYNOS5430_DIV_KFC0_KFC1_SHIFT)
#define EXYNOS5430_DIV_KFC0_KFC2_SHIFT			(4)
#define EXYNOS5430_DIV_KFC0_KFC2_MASK			(0x7 << EXYNOS5430_DIV_KFC0_KFC2_SHIFT)
#define EXYNOS5430_DIV_KFC0_ACLK_KFC_SHIFT		(8)
#define EXYNOS5430_DIV_KFC0_ACLK_KFC_MASK		(0x7 << EXYNOS5430_DIV_KFC0_ACLK_KFC_SHIFT)
#define EXYNOS5430_DIV_KFC0_PCLK_KFC_SHIFT		(12)
#define EXYNOS5430_DIV_KFC0_PCLK_KFC_MASK		(0x7 << EXYNOS5430_DIV_KFC0_PCLK_KFC_SHIFT)
#define EXYNOS5430_DIV_KFC0_ATCLK_KFC_SHIFT		(16)
#define EXYNOS5430_DIV_KFC0_ATCLK_KFC_MASK		(0x7 << EXYNOS5430_DIV_KFC0_ATCLK_KFC_SHIFT)
#define EXYNOS5430_DIV_KFC0_PCLK_DBG_KFC_SHIFT		(20)
#define EXYNOS5430_DIV_KFC0_PCLK_DBG_KFC_MASK		(0x7 << EXYNOS5430_DIV_KFC0_PCLK_DBG_KFC_SHIFT)
#define EXYNOS5430_DIV_KFC0_CNTCLK_KFC_SHIFT		(24)
#define EXYNOS5430_DIV_KFC0_CNTCLK_KFC_MASK		(0x7 << EXYNOS5430_DIV_KFC0_CNTCLK_KFC_SHIFT)
#define EXYNOS5430_DIV_KFC1_KFC_PLL_SHIFT		(0)
#define EXYNOS5430_DIV_KFC1_KFC_PLL_MASK		(0x7 << EXYNOS5430_DIV_KFC1_KFC_PLL_SHIFT)
#define EXYNOS5430_DIV_KFC1_SCLK_HPM_KFC_SHIFT		(4)
#define EXYNOS5430_DIV_KFC1_SCLK_HPM_KFC_MASK		(0x7 << EXYNOS5430_DIV_KFC1_SCLK_HPM_KFC_SHIFT)

#define EXYNOS5430_CLKM_PHY_C_ENABLE			(1 << 12)
#endif
