/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.GNOME.Accessibility.Accessible;
import org.GNOME.Accessibility.JavaBridge;
import org.GNOME.Accessibility.SelectionOperations;
import org.GNOME.Accessibility.SelectionPOATie;
import org.GNOME.Bonobo.UnknownImpl;

public class SelectionImpl
extends UnknownImpl
implements SelectionOperations {
    AccessibleSelection accSelection;
    AccessibleContext ac;

    public SelectionImpl(AccessibleContext accessibleContext) {
        this.accSelection = accessibleContext.getAccessibleSelection();
        this.ac = accessibleContext;
        this.poa = JavaBridge.getRootPOA();
        this.tie = new SelectionPOATie(this, JavaBridge.getRootPOA());
        try {
            JavaBridge.getRootPOA().activate_object(this.tie);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    @Override
    public int nSelectedChildren() {
        int n = 0;
        if (this.accSelection != null) {
            n = this.accSelection.getAccessibleSelectionCount();
        }
        return n;
    }

    @Override
    public Accessible getSelectedChild(int n) {
        Accessible accessible = null;
        if (this.accSelection != null) {
            javax.accessibility.Accessible accessible2 = this.accSelection.getAccessibleSelection(n);
            accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessible2.getAccessibleContext());
        }
        return accessible;
    }

    @Override
    public boolean selectChild(int n) {
        boolean bl = false;
        if (this.accSelection != null) {
            this.accSelection.addAccessibleSelection(n);
            bl = this.isChildSelected(n);
        }
        return bl;
    }

    @Override
    public boolean deselectSelectedChild(int n) {
        boolean bl = false;
        if (this.accSelection != null) {
            this.accSelection.removeAccessibleSelection(n);
            bl = !this.isChildSelected(n);
        }
        return bl;
    }

    @Override
    public boolean deselectChild(int n) {
        return false;
    }

    @Override
    public boolean isChildSelected(int n) {
        if (this.accSelection != null) {
            return this.accSelection.isAccessibleChildSelected(n);
        }
        return false;
    }

    @Override
    public boolean selectAll() {
        AccessibleStateSet accessibleStateSet;
        if (this.accSelection != null && (accessibleStateSet = this.ac.getAccessibleStateSet()).contains(AccessibleState.MULTISELECTABLE)) {
            this.accSelection.selectAllAccessibleSelection();
            return true;
        }
        return false;
    }

    @Override
    public boolean clearSelection() {
        if (this.accSelection != null) {
            this.accSelection.clearAccessibleSelection();
            return true;
        }
        return false;
    }

    @Override
    public void unImplemented() {
    }

    @Override
    public void unImplemented2() {
    }

    @Override
    public void unImplemented3() {
    }

    public void unImplemented4() {
    }
}

