/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteAction
extends TransportReplicationAction<DeleteRequest, DeleteRequest, DeleteResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;

    @Inject
    public TransportDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MappingUpdatedAction mappingUpdatedAction, AutoCreateIndex autoCreateIndex) {
        super(settings, "indices:data/write/delete", transportService, clusterService, indicesService, threadPool, shardStateAction, mappingUpdatedAction, actionFilters, indexNameExpressionResolver, DeleteRequest.class, DeleteRequest.class, "index");
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = autoCreateIndex;
    }

    @Override
    protected void doExecute(final DeleteRequest request, final ActionListener<DeleteResponse> listener) {
        ClusterState state = this.clusterService.state();
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), state)) {
            this.createIndexAction.execute(new CreateIndexRequest(request).index(request.index()).cause("auto(delete api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportDeleteAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        TransportDeleteAction.this.innerExecute(request, listener);
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    @Override
    protected void resolveRequest(MetaData metaData, String concreteIndex, DeleteRequest request) {
        MappingMetaData mappingMd;
        request.routing(metaData.resolveIndexRouting(request.routing(), request.index()));
        if (metaData.hasIndex(concreteIndex) && (mappingMd = metaData.index(concreteIndex).mappingOrDefault(request.type())) != null && mappingMd.routing().required() && request.routing() == null) {
            if (request.versionType() != VersionType.INTERNAL) {
                throw new IllegalArgumentException("routing value is required for deleting documents of type [" + request.type() + "] while using version_type [" + (Object)((Object)request.versionType()) + "]");
            }
            throw new RoutingMissingException(concreteIndex, request.type(), request.id());
        }
        ShardId shardId = this.clusterService.operationRouting().shardId(this.clusterService.state(), concreteIndex, request.type(), request.id(), request.routing());
        request.setShardId(shardId);
    }

    private void innerExecute(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected DeleteResponse newResponseInstance() {
        return new DeleteResponse();
    }

    @Override
    protected Tuple<DeleteResponse, DeleteRequest> shardOperationOnPrimary(MetaData metaData, DeleteRequest request) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(request.shardId().getIndex()).shardSafe(request.shardId().id());
        TransportReplicationAction.WriteResult<DeleteResponse> result = TransportDeleteAction.executeDeleteRequestOnPrimary(request, indexShard);
        this.processAfterWrite(request.refresh(), indexShard, result.location);
        return new Tuple<DeleteResponse, DeleteRequest>((DeleteResponse)result.response, request);
    }

    public static TransportReplicationAction.WriteResult<DeleteResponse> executeDeleteRequestOnPrimary(DeleteRequest request, IndexShard indexShard) {
        Engine.Delete delete = indexShard.prepareDeleteOnPrimary(request.type(), request.id(), request.version(), request.versionType());
        indexShard.delete(delete);
        request.versionType(delete.versionType().versionTypeForReplicationAndRecovery());
        request.version(delete.version());
        assert (request.versionType().validateVersionForWrites(request.version()));
        return new TransportReplicationAction.WriteResult<DeleteResponse>(new DeleteResponse(indexShard.shardId().getIndex(), request.type(), request.id(), delete.version(), delete.found()), delete.getTranslogLocation());
    }

    public static Engine.Delete executeDeleteRequestOnReplica(DeleteRequest request, IndexShard indexShard) {
        Engine.Delete delete = indexShard.prepareDeleteOnReplica(request.type(), request.id(), request.version(), request.versionType());
        indexShard.delete(delete);
        return delete;
    }

    @Override
    protected void shardOperationOnReplica(DeleteRequest request) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(request.shardId().getIndex()).shardSafe(request.shardId().id());
        Engine.Delete delete = TransportDeleteAction.executeDeleteRequestOnReplica(request, indexShard);
        this.processAfterWrite(request.refresh(), indexShard, delete.getTranslogLocation());
    }
}

