/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.publish;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.AckClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.BlockingClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class PublishClusterStateAction
extends AbstractComponent {
    public static final String ACTION_NAME = "internal:discovery/zen/publish";
    private final TransportService transportService;
    private final DiscoveryNodesProvider nodesProvider;
    private final NewClusterStateListener listener;
    private final DiscoverySettings discoverySettings;

    public PublishClusterStateAction(Settings settings, TransportService transportService, DiscoveryNodesProvider nodesProvider, NewClusterStateListener listener, DiscoverySettings discoverySettings) {
        super(settings);
        this.transportService = transportService;
        this.nodesProvider = nodesProvider;
        this.listener = listener;
        this.discoverySettings = discoverySettings;
        transportService.registerRequestHandler(ACTION_NAME, BytesTransportRequest.class, "same", new PublishClusterStateRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler(ACTION_NAME);
    }

    public void publish(ClusterChangedEvent clusterChangedEvent, Discovery.AckListener ackListener) {
        HashSet<DiscoveryNode> nodesToPublishTo = new HashSet<DiscoveryNode>(clusterChangedEvent.state().nodes().size());
        DiscoveryNode localNode = this.nodesProvider.nodes().localNode();
        for (DiscoveryNode node : clusterChangedEvent.state().nodes()) {
            if (node.equals(localNode)) continue;
            nodesToPublishTo.add(node);
        }
        this.publish(clusterChangedEvent, nodesToPublishTo, new AckClusterStatePublishResponseHandler(nodesToPublishTo, ackListener));
    }

    private void publish(ClusterChangedEvent clusterChangedEvent, Set<DiscoveryNode> nodesToPublishTo, BlockingClusterStatePublishResponseHandler publishResponseHandler) {
        HashMap serializedStates = Maps.newHashMap();
        HashMap serializedDiffs = Maps.newHashMap();
        ClusterState clusterState = clusterChangedEvent.state();
        ClusterState previousState = clusterChangedEvent.previousState();
        AtomicBoolean timedOutWaitingForNodes = new AtomicBoolean(false);
        TimeValue publishTimeout = this.discoverySettings.getPublishTimeout();
        boolean sendFullVersion = !this.discoverySettings.getPublishDiff() || previousState == null;
        Diff diff = null;
        for (DiscoveryNode node : nodesToPublishTo) {
            if (sendFullVersion || !previousState.nodes().nodeExists(node.id())) {
                this.sendFullClusterState(clusterState, serializedStates, node, timedOutWaitingForNodes, publishTimeout, publishResponseHandler);
                continue;
            }
            if (diff == null) {
                diff = clusterState.diff(previousState);
            }
            this.sendClusterStateDiff(clusterState, diff, serializedDiffs, node, timedOutWaitingForNodes, publishTimeout, publishResponseHandler);
        }
        if (publishTimeout.millis() > 0L) {
            try {
                DiscoveryNode[] pendingNodes;
                timedOutWaitingForNodes.set(!publishResponseHandler.awaitAllNodes(publishTimeout));
                if (timedOutWaitingForNodes.get() && (pendingNodes = publishResponseHandler.pendingNodes()).length > 0) {
                    this.logger.warn("timed out waiting for all nodes to process published state [{}] (timeout [{}], pending nodes: {})", clusterState.version(), publishTimeout, pendingNodes);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void sendFullClusterState(ClusterState clusterState, @Nullable Map<Version, BytesReference> serializedStates, DiscoveryNode node, AtomicBoolean timedOutWaitingForNodes, TimeValue publishTimeout, BlockingClusterStatePublishResponseHandler publishResponseHandler) {
        BytesReference bytes = null;
        if (serializedStates != null) {
            bytes = serializedStates.get(node.version());
        }
        if (bytes == null) {
            try {
                bytes = PublishClusterStateAction.serializeFullClusterState(clusterState, node.version());
                if (serializedStates != null) {
                    serializedStates.put(node.version(), bytes);
                }
            }
            catch (Throwable e) {
                this.logger.warn("failed to serialize cluster_state before publishing it to node {}", e, node);
                publishResponseHandler.onFailure(node, e);
                return;
            }
        }
        this.publishClusterStateToNode(clusterState, bytes, node, timedOutWaitingForNodes, publishTimeout, publishResponseHandler, false);
    }

    private void sendClusterStateDiff(ClusterState clusterState, Diff diff, Map<Version, BytesReference> serializedDiffs, DiscoveryNode node, AtomicBoolean timedOutWaitingForNodes, TimeValue publishTimeout, BlockingClusterStatePublishResponseHandler publishResponseHandler) {
        BytesReference bytes = serializedDiffs.get(node.version());
        if (bytes == null) {
            try {
                bytes = PublishClusterStateAction.serializeDiffClusterState(diff, node.version());
                serializedDiffs.put(node.version(), bytes);
            }
            catch (Throwable e) {
                this.logger.warn("failed to serialize diff of cluster_state before publishing it to node {}", e, node);
                publishResponseHandler.onFailure(node, e);
                return;
            }
        }
        this.publishClusterStateToNode(clusterState, bytes, node, timedOutWaitingForNodes, publishTimeout, publishResponseHandler, true);
    }

    private void publishClusterStateToNode(final ClusterState clusterState, BytesReference bytes, final DiscoveryNode node, final AtomicBoolean timedOutWaitingForNodes, final TimeValue publishTimeout, final BlockingClusterStatePublishResponseHandler publishResponseHandler, final boolean sendDiffs) {
        try {
            TransportRequestOptions options = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.STATE).withCompress(false).build();
            this.transportService.sendRequest(node, ACTION_NAME, new BytesTransportRequest(bytes, node.version()), options, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    if (timedOutWaitingForNodes.get()) {
                        PublishClusterStateAction.this.logger.debug("node {} responded for cluster state [{}] (took longer than [{}])", node, clusterState.version(), publishTimeout);
                    }
                    publishResponseHandler.onResponse(node);
                }

                @Override
                public void handleException(TransportException exp) {
                    if (sendDiffs && exp.unwrapCause() instanceof IncompatibleClusterStateVersionException) {
                        PublishClusterStateAction.this.logger.debug("resending full cluster state to node {} reason {}", node, exp.getDetailedMessage());
                        PublishClusterStateAction.this.sendFullClusterState(clusterState, null, node, timedOutWaitingForNodes, publishTimeout, publishResponseHandler);
                    } else {
                        PublishClusterStateAction.this.logger.debug("failed to send cluster state to {}", exp, node);
                        publishResponseHandler.onFailure(node, exp);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.logger.warn("error sending cluster state to {}", t, node);
            publishResponseHandler.onFailure(node, t);
        }
    }

    public static BytesReference serializeFullClusterState(ClusterState clusterState, Version nodeVersion) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        try (StreamOutput stream = CompressorFactory.defaultCompressor().streamOutput(bStream);){
            stream.setVersion(nodeVersion);
            stream.writeBoolean(true);
            clusterState.writeTo(stream);
        }
        return bStream.bytes();
    }

    public static BytesReference serializeDiffClusterState(Diff diff, Version nodeVersion) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        try (StreamOutput stream = CompressorFactory.defaultCompressor().streamOutput(bStream);){
            stream.setVersion(nodeVersion);
            stream.writeBoolean(false);
            diff.writeTo(stream);
        }
        return bStream.bytes();
    }

    private class PublishClusterStateRequestHandler
    implements TransportRequestHandler<BytesTransportRequest> {
        private ClusterState lastSeenClusterState;

        private PublishClusterStateRequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageReceived(BytesTransportRequest request, final TransportChannel channel) throws Exception {
            Compressor compressor = CompressorFactory.compressor(request.bytes());
            StreamInput in = compressor != null ? compressor.streamInput(request.bytes().streamInput()) : request.bytes().streamInput();
            in.setVersion(request.version());
            PublishClusterStateRequestHandler publishClusterStateRequestHandler = this;
            synchronized (publishClusterStateRequestHandler) {
                if (in.readBoolean()) {
                    this.lastSeenClusterState = ClusterState.Builder.readFrom(in, PublishClusterStateAction.this.nodesProvider.nodes().localNode());
                    PublishClusterStateAction.this.logger.debug("received full cluster state version {} with size {}", this.lastSeenClusterState.version(), request.bytes().length());
                } else if (this.lastSeenClusterState != null) {
                    Diff<ClusterState> diff = this.lastSeenClusterState.readDiffFrom(in);
                    this.lastSeenClusterState = diff.apply(this.lastSeenClusterState);
                    PublishClusterStateAction.this.logger.debug("received diff cluster state version {} with uuid {}, diff size {}", this.lastSeenClusterState.version(), this.lastSeenClusterState.stateUUID(), request.bytes().length());
                } else {
                    PublishClusterStateAction.this.logger.debug("received diff for but don't have any local cluster state - requesting full state", new Object[0]);
                    throw new IncompatibleClusterStateVersionException("have no local cluster state");
                }
                this.lastSeenClusterState.status(ClusterState.ClusterStateStatus.RECEIVED);
            }
            try {
                PublishClusterStateAction.this.listener.onNewClusterState(this.lastSeenClusterState, new NewClusterStateListener.NewStateProcessed(){

                    @Override
                    public void onNewClusterStateProcessed() {
                        try {
                            channel.sendResponse(TransportResponse.Empty.INSTANCE);
                        }
                        catch (Throwable e) {
                            PublishClusterStateAction.this.logger.debug("failed to send response on cluster state processed", e, new Object[0]);
                        }
                    }

                    @Override
                    public void onNewClusterStateFailed(Throwable t) {
                        try {
                            channel.sendResponse(t);
                        }
                        catch (Throwable e) {
                            PublishClusterStateAction.this.logger.debug("failed to send response on cluster state processed", e, new Object[0]);
                        }
                    }
                });
            }
            catch (Exception e) {
                PublishClusterStateAction.this.logger.warn("unexpected error while processing cluster state version [{}]", e, this.lastSeenClusterState.version());
                try {
                    channel.sendResponse(e);
                }
                catch (Throwable e1) {
                    PublishClusterStateAction.this.logger.debug("failed to send response on cluster state processed", e1, new Object[0]);
                }
            }
        }
    }

    public static interface NewClusterStateListener {
        public void onNewClusterState(ClusterState var1, NewStateProcessed var2);

        public static interface NewStateProcessed {
            public void onNewClusterStateProcessed();

            public void onNewClusterStateFailed(Throwable var1);
        }
    }
}

