/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.script.Template;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.transport.TransportRequest;

public class ShardSearchTransportRequest
extends TransportRequest
implements ShardSearchRequest,
IndicesRequest {
    private OriginalIndices originalIndices;
    private ShardSearchLocalRequest shardSearchLocalRequest;

    public ShardSearchTransportRequest() {
    }

    public ShardSearchTransportRequest(SearchRequest searchRequest, ShardRouting shardRouting, int numberOfShards, String[] filteringAliases, long nowInMillis) {
        super(searchRequest);
        this.shardSearchLocalRequest = new ShardSearchLocalRequest(searchRequest, shardRouting, numberOfShards, filteringAliases, nowInMillis);
        this.originalIndices = new OriginalIndices(searchRequest);
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    @Override
    public String index() {
        return this.shardSearchLocalRequest.index();
    }

    @Override
    public int shardId() {
        return this.shardSearchLocalRequest.shardId();
    }

    @Override
    public String[] types() {
        return this.shardSearchLocalRequest.types();
    }

    @Override
    public BytesReference source() {
        return this.shardSearchLocalRequest.source();
    }

    @Override
    public void source(BytesReference source) {
        this.shardSearchLocalRequest.source(source);
    }

    @Override
    public BytesReference extraSource() {
        return this.shardSearchLocalRequest.extraSource();
    }

    @Override
    public int numberOfShards() {
        return this.shardSearchLocalRequest.numberOfShards();
    }

    @Override
    public SearchType searchType() {
        return this.shardSearchLocalRequest.searchType();
    }

    @Override
    public String[] filteringAliases() {
        return this.shardSearchLocalRequest.filteringAliases();
    }

    @Override
    public long nowInMillis() {
        return this.shardSearchLocalRequest.nowInMillis();
    }

    @Override
    public Template template() {
        return this.shardSearchLocalRequest.template();
    }

    @Override
    public BytesReference templateSource() {
        return this.shardSearchLocalRequest.templateSource();
    }

    @Override
    public Boolean requestCache() {
        return this.shardSearchLocalRequest.requestCache();
    }

    @Override
    public Scroll scroll() {
        return this.shardSearchLocalRequest.scroll();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardSearchLocalRequest = new ShardSearchLocalRequest();
        this.shardSearchLocalRequest.innerReadFrom(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardSearchLocalRequest.innerWriteTo(out, false);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    @Override
    public BytesReference cacheKey() throws IOException {
        return this.shardSearchLocalRequest.cacheKey();
    }

    @Override
    public void setProfile(boolean profile) {
        this.shardSearchLocalRequest.setProfile(profile);
    }

    @Override
    public boolean isProfile() {
        return this.shardSearchLocalRequest.isProfile();
    }
}

