/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.ChildNodeInitializerStrategyAccessor;
import org.gradle.model.internal.core.DefaultModelViewState;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMapModelProjection<I>
implements ModelProjection {
    private static final ModelType<ManagedInstance> MANAGED_INSTANCE_TYPE = ModelType.of(ManagedInstance.class);
    protected final ModelType<I> baseItemModelType;
    private final ChildNodeInitializerStrategyAccessor<? super I> creatorStrategyAccessor;
    private final boolean managed;

    public static <T> ModelProjection unmanaged(ModelType<T> itemType, ChildNodeInitializerStrategyAccessor<? super T> creatorStrategyAccessor) {
        return new ModelMapModelProjection<T>(itemType, false, creatorStrategyAccessor);
    }

    public static <T> ModelProjection unmanaged(Class<T> itemType, ChildNodeInitializerStrategyAccessor<? super T> creatorStrategyAccessor) {
        return ModelMapModelProjection.unmanaged(ModelType.of(itemType), creatorStrategyAccessor);
    }

    public static <T> ModelProjection managed(ModelType<T> itemType, ChildNodeInitializerStrategyAccessor<? super T> creatorStrategyAccessor) {
        return new ModelMapModelProjection<T>(itemType, true, creatorStrategyAccessor);
    }

    private ModelMapModelProjection(ModelType<I> baseItemModelType, boolean managed, ChildNodeInitializerStrategyAccessor<? super I> creatorStrategyAccessor) {
        this.baseItemModelType = baseItemModelType;
        this.managed = managed;
        this.creatorStrategyAccessor = creatorStrategyAccessor;
    }

    private Collection<? extends Class<?>> getCreatableTypes() {
        return Collections.singleton(this.baseItemModelType.getConcreteClass());
    }

    private String getContainerTypeDescription(Class<?> containerType, Collection<? extends Class<?>> creatableTypes) {
        StringBuilder sb = new StringBuilder(containerType.getName());
        if (creatableTypes.size() == 1) {
            String onlyType = ((Class)Iterables.getFirst(creatableTypes, null)).getName();
            sb.append("<").append(onlyType).append(">");
        } else {
            sb.append("<T>; where T is one of [");
            Joiner.on((String)", ").appendTo(sb, (Iterable)CollectionUtils.sort((Iterable)Iterables.transform(creatableTypes, (Function)new Function<Class<?>, String>(){

                public String apply(Class<?> input) {
                    return input.getName();
                }
            })));
            sb.append("]");
        }
        return sb.toString();
    }

    private ModelType<? extends I> itemType(ModelType<?> targetType) {
        Class<ModelMap> targetClass = targetType.getRawClass();
        if (targetClass.equals(ModelMap.class)) {
            ModelType<I> targetItemClass = targetType.getTypeVariables().get(0);
            if (targetItemClass.isAssignableFrom(this.baseItemModelType)) {
                return this.baseItemModelType;
            }
            if (this.baseItemModelType.isAssignableFrom(targetItemClass)) {
                return targetItemClass.asSubtype(this.baseItemModelType);
            }
            return null;
        }
        if (targetClass.isAssignableFrom(ModelMap.class)) {
            return this.baseItemModelType;
        }
        return null;
    }

    @Override
    public <T> boolean canBeViewedAs(ModelType<T> targetType) {
        return this.itemType(targetType) != null || targetType.equals(MANAGED_INSTANCE_TYPE);
    }

    @Override
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, MutableModelNode modelNode, @Nullable ModelRuleDescriptor ruleDescriptor) {
        return this.doAs(type, modelNode, ruleDescriptor, false);
    }

    @Override
    public <T> ModelView<? extends T> asMutable(ModelType<T> targetType, MutableModelNode node, ModelRuleDescriptor ruleDescriptor) {
        return this.doAs(targetType, node, ruleDescriptor, true);
    }

    @Nullable
    private <T> ModelView<? extends T> doAs(ModelType<T> targetType, MutableModelNode node, ModelRuleDescriptor ruleDescriptor, boolean mutable) {
        ModelType<I> itemType = this.itemType(targetType);
        if (itemType != null) {
            return (ModelView)Cast.uncheckedCast(this.toView(targetType, ruleDescriptor, node, itemType, mutable, !this.managed || !mutable));
        }
        return null;
    }

    private <T, S extends I> ModelView<ModelMap<S>> toView(ModelType<T> targetType, ModelRuleDescriptor sourceDescriptor, MutableModelNode node, ModelType<S> itemType, boolean mutable, boolean canReadChildren) {
        ChildNodeInitializerStrategy<? super I> creatorStrategy = this.creatorStrategyAccessor.getStrategy(node);
        DefaultModelViewState state = new DefaultModelViewState(targetType, sourceDescriptor, mutable, canReadChildren);
        NodeBackedModelMap<I> builder = new NodeBackedModelMap<I>(this.baseItemModelType, sourceDescriptor, node, state, creatorStrategy);
        return InstanceModelView.of(node.getPath(), ModelTypes.modelMap(itemType), builder.withType(itemType), state.closer());
    }

    @Override
    public Iterable<String> getTypeDescriptions(MutableModelNode node) {
        Collection<Class<?>> creatableTypes = this.getCreatableTypes();
        return Collections.singleton(this.getContainerTypeDescription(ModelMap.class, creatableTypes));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelMapModelProjection that = (ModelMapModelProjection)o;
        return this.baseItemModelType.equals(that.baseItemModelType);
    }

    public int hashCode() {
        return this.baseItemModelType.hashCode();
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
        return Optional.absent();
    }
}

