/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.resolve.LibraryPublishArtifact;
import org.gradle.api.internal.resolve.LocalLibraryMetaDataAdapter;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.local.model.UsageKind;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJvmBinarySpec;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JarFile;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.WithJvmAssembly;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetaData;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmLocalLibraryMetaDataAdapter
implements LocalLibraryMetaDataAdapter {
    public DefaultLibraryLocalComponentMetaData createLocalComponentMetaData(BinarySpec selectedBinary, String projectPath, boolean toAssembly) {
        EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage = new EnumMap<UsageKind, Iterable<DependencySpec>>(UsageKind.class);
        EnumMap<UsageKind, TaskDependency> buildDependenciesPerUsage = new EnumMap<UsageKind, TaskDependency>(UsageKind.class);
        EnumMap<UsageKind, List<PublishArtifact>> artifacts = new EnumMap<UsageKind, List<PublishArtifact>>(UsageKind.class);
        this.initializeUsages(dependenciesPerUsage, buildDependenciesPerUsage, artifacts);
        if (selectedBinary instanceof JarBinarySpecInternal) {
            JarBinarySpecInternal jarBinarySpec = (JarBinarySpecInternal)selectedBinary;
            this.createJarBinarySpecLocalComponentMetaData(artifacts, jarBinarySpec, dependenciesPerUsage, buildDependenciesPerUsage, toAssembly);
        }
        if (selectedBinary instanceof WithJvmAssembly) {
            JvmAssembly assembly = ((WithJvmAssembly)selectedBinary).getAssembly();
            this.createJvmAssemblyLocalComponentMetaData(artifacts, assembly, dependenciesPerUsage, buildDependenciesPerUsage, toAssembly);
        }
        return this.createResolvedMetaData((BinarySpecInternal)selectedBinary, projectPath, dependenciesPerUsage, buildDependenciesPerUsage, artifacts);
    }

    private DefaultLibraryLocalComponentMetaData createResolvedMetaData(BinarySpecInternal selectedBinary, String projectPath, EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, EnumMap<UsageKind, TaskDependency> buildDependenciesPerUsage, EnumMap<UsageKind, List<PublishArtifact>> artifacts) {
        DefaultLibraryLocalComponentMetaData metadata = DefaultLibraryLocalComponentMetaData.newResolvedLibraryMetadata((LibraryBinaryIdentifier)selectedBinary.getId(), buildDependenciesPerUsage, dependenciesPerUsage, (String)projectPath);
        for (Map.Entry<UsageKind, List<PublishArtifact>> entry : artifacts.entrySet()) {
            UsageKind usage = entry.getKey();
            List<PublishArtifact> publishArtifacts = entry.getValue();
            metadata.addArtifacts(usage.getConfigurationName(), publishArtifacts);
        }
        return metadata;
    }

    private void initializeUsages(EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, EnumMap<UsageKind, TaskDependency> buildDependenciesPerUsage, EnumMap<UsageKind, List<PublishArtifact>> artifacts) {
        for (UsageKind usageKind : UsageKind.values()) {
            dependenciesPerUsage.put(usageKind, Collections.emptyList());
            buildDependenciesPerUsage.put(usageKind, (TaskDependency)new DefaultTaskDependency());
            artifacts.put(usageKind, new LinkedList());
        }
    }

    private void createJarBinarySpecLocalComponentMetaData(EnumMap<UsageKind, List<PublishArtifact>> artifacts, JarBinarySpecInternal jarBinarySpec, EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, EnumMap<UsageKind, TaskDependency> buildDependenciesPerUsage, boolean toAssembly) {
        JarFile apiJar = jarBinarySpec.getApiJar();
        JvmLocalLibraryMetaDataAdapter.configureUsageMetadata(UsageKind.API, toAssembly ? null : apiJar, jarBinarySpec.getApiDependencies(), dependenciesPerUsage, buildDependenciesPerUsage);
        JarFile runtimeJar = jarBinarySpec.getRuntimeJar();
        JvmLibrarySpec library = jarBinarySpec.getLibrary();
        JvmLocalLibraryMetaDataAdapter.configureUsageMetadata(UsageKind.RUNTIME, toAssembly ? null : runtimeJar, library != null ? DefaultJvmBinarySpec.collectDependencies(jarBinarySpec, library, library.getDependencies().getDependencies(), jarBinarySpec.getApiDependencies()) : Collections.emptyList(), dependenciesPerUsage, buildDependenciesPerUsage);
        if (!toAssembly) {
            JvmLocalLibraryMetaDataAdapter.addArtifact(UsageKind.API, apiJar, artifacts);
            JvmLocalLibraryMetaDataAdapter.addArtifact(UsageKind.RUNTIME, runtimeJar, artifacts);
        }
    }

    private void createJvmAssemblyLocalComponentMetaData(EnumMap<UsageKind, List<PublishArtifact>> artifacts, JvmAssembly assembly, EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, EnumMap<UsageKind, TaskDependency> buildDependenciesPerUsage, boolean toAssembly) {
        JvmLocalLibraryMetaDataAdapter.configureUsageMetadata(UsageKind.API, toAssembly ? assembly : null, Collections.<DependencySpec>emptyList(), dependenciesPerUsage, buildDependenciesPerUsage);
        JvmLocalLibraryMetaDataAdapter.configureUsageMetadata(UsageKind.RUNTIME, toAssembly ? assembly : null, Collections.<DependencySpec>emptyList(), dependenciesPerUsage, buildDependenciesPerUsage);
        if (toAssembly) {
            JvmLocalLibraryMetaDataAdapter.addArtifact(UsageKind.API, assembly.getClassDirectories(), artifacts);
            JvmLocalLibraryMetaDataAdapter.addArtifact(UsageKind.RUNTIME, (Set<File>)Sets.union(assembly.getClassDirectories(), assembly.getResourceDirectories()), artifacts);
        }
    }

    private static void configureUsageMetadata(UsageKind usage, Object buildDependency, Iterable<DependencySpec> dependencies, EnumMap<UsageKind, Iterable<DependencySpec>> dependenciesPerUsage, EnumMap<UsageKind, TaskDependency> buildDependenciesPerUsage) {
        Iterable<DependencySpec> dependencySpecs = dependenciesPerUsage.get(usage);
        dependenciesPerUsage.put(usage, Iterables.concat(dependencies, dependencySpecs));
        if (buildDependency != null) {
            DefaultTaskDependency buildDependencies = (DefaultTaskDependency)buildDependenciesPerUsage.get(usage);
            buildDependencies.add(new Object[]{buildDependency});
        }
    }

    private static void addArtifact(UsageKind usage, JarFile jarFile, EnumMap<UsageKind, List<PublishArtifact>> artifacts) {
        artifacts.get(usage).add((PublishArtifact)new LibraryPublishArtifact("jar", jarFile.getFile()));
    }

    private static void addArtifact(UsageKind usage, Set<File> directories, EnumMap<UsageKind, List<PublishArtifact>> artifacts) {
        List<PublishArtifact> publishArtifacts = artifacts.get(usage);
        for (File dir : directories) {
            publishArtifacts.add((PublishArtifact)new DefaultPublishArtifact("assembly", "", "", "", new Date(dir.lastModified()), dir, new Object[0]));
        }
    }
}

