/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetFactory;
import org.gradle.language.base.internal.registry.LanguageRegistration;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.model.Defaults;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.RuleInput;
import org.gradle.model.RuleSource;
import org.gradle.model.RuleTarget;
import org.gradle.model.Rules;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRules
extends RuleSource {
    @Defaults
    void initializeSourceSets(ComponentSpecInternal component, LanguageSourceSetFactory languageSourceSetFactory, LanguageTransformContainer languageTransforms) {
        for (LanguageRegistration<?> languageRegistration : languageSourceSetFactory.getRegistrations()) {
            this.registerLanguageTypes(component, languageRegistration, languageTransforms);
        }
    }

    @Defaults
    void applyDefaultSourceConventions(ComponentSpec component, ProjectIdentifier projectIdentifier) {
        component.getSources().afterEach((Action)new AddDefaultSourceLocation(projectIdentifier.getProjectDir()));
    }

    @Defaults
    void addSourcesSetsToProjectSourceSet(ComponentSpec component, final ProjectSourceSet projectSourceSet) {
        component.getSources().afterEach((Action)new Action<LanguageSourceSet>(){

            public void execute(LanguageSourceSet languageSourceSet) {
                projectSourceSet.add(languageSourceSet);
            }
        });
    }

    private <U extends LanguageSourceSet> void registerLanguageTypes(ComponentSpecInternal component, LanguageRegistration<U> languageRegistration, LanguageTransformContainer languageTransforms) {
        Iterator i$ = languageTransforms.iterator();
        while (i$.hasNext()) {
            LanguageTransform languageTransform = (LanguageTransform)i$.next();
            if (!ModelType.of(languageTransform.getSourceSetType()).equals(languageRegistration.getSourceSetType()) || !component.getInputTypes().contains(languageTransform.getOutputType())) continue;
            component.getSources().create(languageRegistration.getName(), languageRegistration.getSourceSetType().getConcreteClass());
            return;
        }
    }

    @Rules
    void inputRules(AttachInputs attachInputs, ComponentSpec component) {
        attachInputs.setBinaries(component.getBinaries());
        attachInputs.setSources(component.getSources());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AddDefaultSourceLocation
    implements Action<LanguageSourceSet> {
        private File baseDir;

        AddDefaultSourceLocation(File baseDir) {
            this.baseDir = baseDir;
        }

        public void execute(LanguageSourceSet languageSourceSet) {
            if (languageSourceSet.getSource().getSrcDirs().isEmpty()) {
                String defaultSourceDir = this.calculateDefaultPath(languageSourceSet);
                languageSourceSet.getSource().srcDir((Object)defaultSourceDir);
            }
        }

        private String calculateDefaultPath(LanguageSourceSet languageSourceSet) {
            return Joiner.on((String)File.separator).skipNulls().join((Object)this.baseDir.getPath(), (Object)"src", new Object[]{Strings.emptyToNull((String)languageSourceSet.getParentName()), Strings.emptyToNull((String)languageSourceSet.getName())});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AttachInputs
    extends RuleSource {
        AttachInputs() {
        }

        @RuleTarget
        abstract ModelMap<BinarySpec> getBinaries();

        abstract void setBinaries(ModelMap<BinarySpec> var1);

        @RuleInput
        abstract ModelMap<LanguageSourceSet> getSources();

        abstract void setSources(ModelMap<LanguageSourceSet> var1);

        @Mutate
        void initializeBinarySourceSets(ModelMap<BinarySpec> binaries) {
            binaries.withType(BinarySpecInternal.class, (Action)new Action<BinarySpecInternal>(){

                public void execute(BinarySpecInternal binary) {
                    binary.getInputs().addAll(AttachInputs.this.getSources().values());
                }
            });
        }
    }
}

