/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeBuilder<T>
implements TypeBuilderInternal<T> {
    private final Class<?> markerAnnotation;
    private final ModelSchema<? extends T> schema;
    private Class<? extends T> implementation;
    private final Set<Class<?>> internalViews = Sets.newLinkedHashSet();

    public AbstractTypeBuilder(Class<?> markerAnnotation, ModelSchema<T> schema) {
        this.markerAnnotation = markerAnnotation;
        this.schema = schema;
    }

    @Override
    public TypeBuilderInternal<T> defaultImplementation(Class<? extends T> implementation) {
        if (this.schema instanceof ManagedImplSchema) {
            throw new InvalidModelException(String.format("Method annotated with @%s cannot set default implementation for managed type %s.", this.markerAnnotation.getSimpleName(), this.schema.getType().getName()));
        }
        if (this.implementation != null) {
            throw new InvalidModelException(String.format("Method annotated with @%s cannot set default implementation multiple times.", this.markerAnnotation.getSimpleName()));
        }
        this.implementation = implementation;
        return this;
    }

    @Override
    public Class<? extends T> getDefaultImplementation() {
        return this.implementation;
    }

    @Override
    public TypeBuilder<T> internalView(Class<?> internalView) {
        if (this.internalViews.contains(internalView)) {
            throw new InvalidModelException(String.format("Internal view '%s' must not be specified multiple times.", internalView.getName()));
        }
        this.internalViews.add(internalView);
        return this;
    }

    @Override
    public Set<Class<?>> getInternalViews() {
        return this.internalViews;
    }
}

