/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.jruby;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyNil;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.springframework.core.NestedRuntimeException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Deprecated
public abstract class JRubyScriptUtils {
    public static Object createJRubyObject(String scriptSource, Class<?> ... interfaces) throws JumpException {
        return JRubyScriptUtils.createJRubyObject(scriptSource, interfaces, ClassUtils.getDefaultClassLoader());
    }

    public static Object createJRubyObject(String scriptSource, Class<?>[] interfaces, ClassLoader classLoader) {
        Node scriptRootNode;
        Ruby ruby = JRubyScriptUtils.initializeRuntime();
        IRubyObject rubyObject = ruby.runNormally(scriptRootNode = ruby.parseEval(scriptSource, "", null, 0));
        if (rubyObject instanceof RubyNil) {
            String className = JRubyScriptUtils.findClassName(scriptRootNode);
            rubyObject = ruby.evalScriptlet("\n" + className + ".new");
        }
        if (rubyObject instanceof RubyNil) {
            throw new IllegalStateException("Compilation of JRuby script returned RubyNil: " + rubyObject);
        }
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new RubyObjectInvocationHandler(rubyObject, ruby));
    }

    private static Ruby initializeRuntime() {
        return JavaEmbedUtils.initialize((List)Collections.EMPTY_LIST);
    }

    private static String findClassName(Node rootNode) {
        ClassNode classNode = JRubyScriptUtils.findClassNode(rootNode);
        if (classNode == null) {
            throw new IllegalArgumentException("Unable to determine class name for root node '" + rootNode + "'");
        }
        Colon2Node node = (Colon2Node)classNode.getCPath();
        return node.getName();
    }

    private static ClassNode findClassNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ClassNode) {
            return (ClassNode)node;
        }
        List children = node.childNodes();
        for (Node child : children) {
            NewlineNode nn;
            ClassNode found;
            if (child instanceof ClassNode) {
                return (ClassNode)child;
            }
            if (!(child instanceof NewlineNode) || (found = JRubyScriptUtils.findClassNode((nn = (NewlineNode)child).getNextNode())) == null) continue;
            return found;
        }
        for (Node child : children) {
            ClassNode found = JRubyScriptUtils.findClassNode(child);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static class JRubyExecutionException
    extends NestedRuntimeException {
        public JRubyExecutionException(RaiseException ex) {
            super(ex.getMessage(), (Throwable)ex);
        }
    }

    private static class RubyObjectInvocationHandler
    implements InvocationHandler {
        private final IRubyObject rubyObject;
        private final Ruby ruby;

        public RubyObjectInvocationHandler(IRubyObject rubyObject, Ruby ruby) {
            this.rubyObject = rubyObject;
            this.ruby = ruby;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ReflectionUtils.isEqualsMethod((Method)method)) {
                return this.isProxyForSameRubyObject(args[0]);
            }
            if (ReflectionUtils.isHashCodeMethod((Method)method)) {
                return this.rubyObject.hashCode();
            }
            if (ReflectionUtils.isToStringMethod((Method)method)) {
                String toStringResult = this.rubyObject.toString();
                if (!StringUtils.hasText((String)toStringResult)) {
                    toStringResult = ObjectUtils.identityToString((Object)this.rubyObject);
                }
                return "JRuby object [" + toStringResult + "]";
            }
            try {
                IRubyObject[] rubyArgs = this.convertToRuby(args);
                IRubyObject rubyResult = this.rubyObject.callMethod(this.ruby.getCurrentContext(), method.getName(), rubyArgs);
                return this.convertFromRuby(rubyResult, method.getReturnType());
            }
            catch (RaiseException ex) {
                throw new JRubyExecutionException(ex);
            }
        }

        private boolean isProxyForSameRubyObject(Object other) {
            if (!Proxy.isProxyClass(other.getClass())) {
                return false;
            }
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            return ih instanceof RubyObjectInvocationHandler && this.rubyObject.equals(((RubyObjectInvocationHandler)ih).rubyObject);
        }

        private IRubyObject[] convertToRuby(Object[] javaArgs) {
            if (javaArgs == null || javaArgs.length == 0) {
                return new IRubyObject[0];
            }
            IRubyObject[] rubyArgs = new IRubyObject[javaArgs.length];
            for (int i = 0; i < javaArgs.length; ++i) {
                rubyArgs[i] = JavaEmbedUtils.javaToRuby((Ruby)this.ruby, (Object)javaArgs[i]);
            }
            return rubyArgs;
        }

        private Object convertFromRuby(IRubyObject rubyResult, Class<?> returnType) {
            Object result = JavaEmbedUtils.rubyToJava((Ruby)this.ruby, (IRubyObject)rubyResult, returnType);
            if (result instanceof RubyArray && returnType.isArray()) {
                result = this.convertFromRubyArray(((RubyArray)result).toJavaArray(), returnType);
            }
            return result;
        }

        private Object convertFromRubyArray(IRubyObject[] rubyArray, Class<?> returnType) {
            Class<?> targetType = returnType.getComponentType();
            Object javaArray = Array.newInstance(targetType, rubyArray.length);
            for (int i = 0; i < rubyArray.length; ++i) {
                IRubyObject rubyObject = rubyArray[i];
                Array.set(javaArray, i, this.convertFromRuby(rubyObject, targetType));
            }
            return javaArray;
        }
    }
}

