/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.select.Evaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CombiningEvaluator
extends Evaluator {
    final List<Evaluator> evaluators = new ArrayList<Evaluator>();

    CombiningEvaluator() {
    }

    CombiningEvaluator(Collection<Evaluator> evaluators) {
        this();
        this.evaluators.addAll(evaluators);
    }

    Evaluator rightMostEvaluator() {
        return this.evaluators.size() > 0 ? this.evaluators.get(this.evaluators.size() - 1) : null;
    }

    void replaceRightMostEvaluator(Evaluator replacement) {
        this.evaluators.set(this.evaluators.size() - 1, replacement);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Or
    extends CombiningEvaluator {
        Or(Collection<Evaluator> evaluators) {
            if (evaluators.size() > 1) {
                this.evaluators.add(new And(evaluators));
            } else {
                this.evaluators.addAll(evaluators);
            }
        }

        Or() {
        }

        public void add(Evaluator e) {
            this.evaluators.add(e);
        }

        @Override
        public boolean matches(Element root, Element node) {
            for (int i = 0; i < this.evaluators.size(); ++i) {
                Evaluator s = (Evaluator)this.evaluators.get(i);
                if (!s.matches(root, node)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format(":or%s", this.evaluators);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class And
    extends CombiningEvaluator {
        And(Collection<Evaluator> evaluators) {
            super(evaluators);
        }

        And(Evaluator ... evaluators) {
            this(Arrays.asList(evaluators));
        }

        @Override
        public boolean matches(Element root, Element node) {
            for (int i = 0; i < this.evaluators.size(); ++i) {
                Evaluator s = (Evaluator)this.evaluators.get(i);
                if (s.matches(root, node)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return StringUtil.join(this.evaluators, " ");
        }
    }
}

