
#include        "system.h"              /* system dependent part           */

#include        "gasman.h"              /* garbage collector               */
#include        "objects.h"             /* objects                         */
#include        "scanner.h"             /* scanner                         */

#include        "gap.h"                 /* error handling, initialisation  */

#include        "gvars.h"               /* global variables                */

#include        "calls.h"               /* generic call mechanism          */
#include        "opers.h"               /* generic operations              */

#include        "ariths.h"              /* basic arithmetic                */

#include        "bool.h"                /* booleans                        */

#include        "integer.h"             /* integers                        */
#include        "intfuncs.h"            /* hashing                         */

#include        "permutat.h"            /* permutations                    */

#include        "records.h"             /* generic records                 */
#include        "precord.h"             /* plain records                   */

#include        "lists.h"               /* generic lists                   */
#include        "plist.h"               /* plain lists                     */
#include        "range.h"               /* ranges                          */
#include        "string.h"              /* strings                         */

#include        "saveload.h"            /* saving and loading              */

#include        "set.h"                 /* sets                            */

#ifndef libGAP_GAP_TRANS_H
#define libGAP_GAP_TRANS_H

extern libGAP_UInt libGAP_INIT_TRANS2(libGAP_Obj f);
extern libGAP_UInt libGAP_INIT_TRANS4(libGAP_Obj f);

#define libGAP_IMG_TRANS(f)      (*(libGAP_Obj*)(libGAP_ADDR_OBJ(f)))
#define libGAP_KER_TRANS(f)      (*((libGAP_Obj*)(libGAP_ADDR_OBJ(f))+1))
#define libGAP_EXT_TRANS(f)      (*((libGAP_Obj*)(libGAP_ADDR_OBJ(f))+2))

#define libGAP_NEW_TRANS2(deg)   libGAP_NewBag(libGAP_T_TRANS2, deg*sizeof(libGAP_UInt2)+3*sizeof(libGAP_Obj))
#define libGAP_ADDR_TRANS2(f)    ((libGAP_UInt2*)((libGAP_Obj*)(libGAP_ADDR_OBJ(f))+3))
#define libGAP_DEG_TRANS2(f)     ((libGAP_UInt)(libGAP_SIZE_OBJ(f)-3*sizeof(libGAP_Obj))/sizeof(libGAP_UInt2))
#define libGAP_RANK_TRANS2(f)    (libGAP_IMG_TRANS(f)==NULL?libGAP_INIT_TRANS2(f):libGAP_LEN_PLIST(libGAP_IMG_TRANS(f)))

#define libGAP_NEW_TRANS4(deg)   libGAP_NewBag(libGAP_T_TRANS4, deg*sizeof(libGAP_UInt4)+3*sizeof(libGAP_Obj))
#define libGAP_ADDR_TRANS4(f)    ((libGAP_UInt4*)((libGAP_Obj*)(libGAP_ADDR_OBJ(f))+3))
#define libGAP_DEG_TRANS4(f)     ((libGAP_UInt)(libGAP_SIZE_OBJ(f)-3*sizeof(libGAP_Obj))/sizeof(libGAP_UInt4))
#define libGAP_RANK_TRANS4(f)    (libGAP_IMG_TRANS(f)==NULL?libGAP_INIT_TRANS4(f):libGAP_LEN_PLIST(libGAP_IMG_TRANS(f)))

#define libGAP_IS_TRANS(f)       (libGAP_TNUM_OBJ(f)==libGAP_T_TRANS2||libGAP_TNUM_OBJ(f)==libGAP_T_TRANS4)
#define libGAP_RANK_TRANS(f)     (libGAP_TNUM_OBJ(f)==libGAP_T_TRANS2?libGAP_RANK_TRANS2(f):libGAP_RANK_TRANS4(f))
#define libGAP_DEG_TRANS(f)      (libGAP_TNUM_OBJ(f)==libGAP_T_TRANS2?libGAP_DEG_TRANS2(f):libGAP_DEG_TRANS4(f))

/****************************************************************************
**
*F  OnTuplesTrans( <tup>, <f> )  . . . .  operations on tuples of points
**
**  'OnTuplesTrans'  returns  the  image  of  the  tuple  <tup>   under  the
**  transformation <f>.
*/
extern libGAP_Obj libGAP_OnTuplesTrans ( libGAP_Obj tup, libGAP_Obj f );

/****************************************************************************
**
*F  OnSetsTrans( <set>, <f> ) . . . . . . . .  operations on sets of points
**
**  'OnSetsTrans' returns the  image of the  tuple <set> under the 
**  transformation <f>. 
*/
extern libGAP_Obj libGAP_OnSetsTrans ( libGAP_Obj set, libGAP_Obj f );

/****************************************************************************
**
*V  IdentityTrans  . . . . . . . . . . . . . . . . .  identity transformation
**
**  'IdentityTrans' is an identity transformation.
*/
extern  libGAP_Obj             libGAP_IdentityTrans;

/****************************************************************************

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * */

/****************************************************************************

*F  InitInfoTrans()  . . . . . . . . . . . . . . . table of init functions
*/

libGAP_StructInitInfo * libGAP_InitInfoTrans ( void );

#endif // GAP_TRANS_H
