/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultipartParam {
    private final List<String> headers = new ArrayList<String>();
    private String name;
    private String fileName;
    private String content;

    public void addHeader(String string) throws IOException {
        this.headers.add(string);
        if (string.toLowerCase().startsWith("content-disposition:")) {
            this.extractDispositionInfo(string);
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.headers) {
            stringBuilder.append(string);
            stringBuilder.append("\r\n");
        }
        stringBuilder.append("\r\n");
        stringBuilder.append(this.content);
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    private void extractDispositionInfo(String string) throws IOException {
        String string2 = string;
        string = string2.toLowerCase();
        int n = string.indexOf("content-disposition: ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string3 = string.substring(n + 21, n2).trim();
        if (!string3.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + string3);
        }
        n = string.indexOf("name=\"", n2);
        n2 = string.indexOf("\"", n + 7);
        int n3 = 6;
        if (n == -1 || n2 == -1) {
            n = string.indexOf("name=", n2);
            n2 = string.indexOf(";", n + 6);
            if (n == -1) {
                throw new IOException("Content disposition corrupt: " + string2);
            }
            if (n2 == -1) {
                n2 = string.length();
            }
            n3 = 5;
        }
        this.name = string2.substring(n + n3, n2);
        String string4 = null;
        String string5 = null;
        n = string.indexOf("filename=\"", n2 + 2);
        n2 = string.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string5 = string4 = string2.substring(n + 10, n2);
            int n4 = Math.max(string4.lastIndexOf(47), string4.lastIndexOf(92));
            if (n4 > -1) {
                string4 = string4.substring(n4 + 1);
            }
        }
        this.fileName = string4;
    }

    private static String extractContentType(String string) throws IOException {
        int n = (string = string.toLowerCase()).indexOf(";");
        if (n == -1) {
            n = string.length();
        }
        return string.substring(13, n).trim();
    }
}

