<?php
/*************************************************************************************
 * bash.php
 * --------
 * Author: Andreas Gohr (andi@splitbrain.org)
 * Copyright: (c) 2004 Andreas Gohr, Nigel McNie (http://qbnz.com/highlighter)
 * Release Version: 1.0.8.11
 * Date Started: 2004/08/20
 *
 * BASH language file for GeSHi.
 *
 * CHANGES
 * -------
 * 2008/06/21 (1.0.8)
 *  -  Added loads of keywords and commands of GNU/Linux
 *  -  Added support for parameters starting with a dash
 * 2008/05/23 (1.0.7.22)
 *  -  Added description of extra language features (SF#1970248)
 * 2007/09/05 (1.0.7.21)
 *  -  PARSER_CONTROL patch using SF #1788408 (BenBE)
 * 2007/06/11 (1.0.7.20)
 *  -  Added a lot of keywords (BenBE / Jan G)
 * 2004/11/27 (1.0.2)
 *  -  Added support for multiple object splitters
 * 2004/10/27 (1.0.1)
 *   -  Added support for URLs
 * 2004/08/20 (1.0.0)
 *   -  First Release
 *
 * TODO (updated 2004/11/27)
 * -------------------------
 * * Get symbols working
 * * Highlight builtin vars
 *
 *************************************************************************************
 *
 *     This file is part of GeSHi.
 *
 *   GeSHi is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   GeSHi is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with GeSHi; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ************************************************************************************/

$language_data = array (
    'LANG_NAME' => 'Bash',
    // Bash DOES have single line comments with # markers. But bash also has
    // the  $# variable, so comments need special handling (see sf.net
    // 1564839)
    'COMMENT_SINGLE' => array('#'),
    'COMMENT_MULTI' => array(),
    'COMMENT_REGEXP' => array(
        //Variables
        1 => "/\\$\\{[^\\n\\}]*?\\}/i",
        //BASH-style Heredoc
        2 => '/<<-?\s*?(\'?)([a-zA-Z0-9]+)\1\\n.*\\n\\2(?![a-zA-Z0-9])/siU',
        //Escaped String Starters
        3 => "/\\\\['\"]/siU",
        // Single-Line Shell usage: Hide the prompt at the beginning
        /* 4 => "/\A(?!#!)\s*(?>[\w:@\\/\\-\\._~]*[$#]\s?)?(?=[^\n]+\n?\Z)|^(?!#!)(\w+@)?[\w\\-\\.]+(:~?)[\w\\/\\-\\._]*?[$#]\s?/ms" */
        4 => "/\A(?!#!)(?:(?>[\w:@\\/\\-\\._~]*)[$#]\s?)(?=(?>[^\n]+)\n?\Z)|^(?!#!)(?:\w+@)?(?>[\w\\-\\.]+)(?>:~?[\w\\/\\-\\._]*?)?[$#]\s?/sm"
        ),
    'CASE_KEYWORDS' => GESHI_CAPS_NO_CHANGE,
    'QUOTEMARKS' => array('"'),
    'HARDQUOTE' => array("'", "'"),
    'HARDESCAPE' => array("\'"),
    'ESCAPE_CHAR' => '',
    'ESCAPE_REGEXP' => array(
        //Simple Single Char Escapes
        1 => "#\\\\[nfrtv\\$\\\"\n]#i",
        // $var
        2 => "#\\$[a-z_][a-z0-9_]*#i",
        // ${...}
        3 => "/\\$\\{[^\\n\\}]*?\\}/i",
        // $(...)
        4 => "/\\$\\([^\\n\\)]*?\\)/i",
        // `...`
        5 => "/`[^`]*`/"
        ),
    'KEYWORDS' => array(
        1 => array(
            'case', 'do', 'done', 'elif', 'else', 'esac', 'fi', 'for', 'function',
            'if', 'in', 'select', 'set', 'then', 'until', 'while', 'time'
            ),
        2 => array(
            'aclocal', 'aconnect', 'apachectl', 'apache2ctl', 'aplay', 'apm',
            'apmsleep', 'apropos', 'apt-cache', 'apt-cdrom', 'apt-config',
            'apt-file', 'apt-ftparchive', 'apt-get', 'apt-key', 'apt-listbugs',
            'apt-listchanges', 'apt-mark', 'apt-mirror', 'apt-sortpkgs',
            'apt-src', 'apticron', 'aptitude', 'aptsh', 'apxs', 'apxs2', 'ar',
            'arch', 'arecord', 'as', 'as86', 'ash', 'autoconf', 'autoheader',
            'automake', 'awk',

            'apachectl start', 'apachectl stop', 'apachectl restart',
            'apachectl graceful', 'apachectl graceful-stop',
            'apachectl configtest', 'apachectl status', 'apachectl fullstatus',
            'apachectl help', 'apache2ctl start', 'apache2ctl stop',
            'apache2ctl restart', 'apache2ctl graceful',
            'apache2ctl graceful-stop', 'apache2ctl configtest',
            'apache2ctl status', 'apache2ctl fullstatus', 'apache2ctl help',

            'apt-cache add', 'apt-cache depends', 'apt-cache dotty',
            'apt-cache dump', 'apt-cache dumpavail', 'apt-cache gencaches',
            'apt-cache pkgnames', 'apt-cache policy', 'apt-cache rdepends',
            'apt-cache search', 'apt-cache show', 'apt-cache showauto',
            'apt-cache showpkg', 'apt-cache showsrc', 'apt-cache stats',
            'apt-cache unmet', 'apt-cache xvcg', 'apt-cdrom add',
            'apt-cdrom ident', 'apt-config dump', 'apt-config shell',
            'apt-file find', 'apt-file list', 'apt-file purge',
            'apt-file search', 'apt-file shot', 'apt-file update',
            'apt-get autoclean', 'apt-get autoremove', 'apt-get build-dep',
            'apt-get check', 'apt-get clean', 'apt-get dist-upgrade',
            'apt-get dselect-upgrade', 'apt-get install', 'apt-get markauto',
            'apt-get purge', 'apt-get remove', 'apt-get source',
            'apt-get unmarkauto', 'apt-get update', 'apt-get upgrade',
            'apt-key add', 'apt-key adv', 'apt-key del', 'apt-key export',
            'apt-key exportall', 'apt-key finger', 'apt-key list',
            'apt-key net-update', 'apt-key update', 'apt-listbugs apt',
            'apt-listbugs list', 'apt-listbugs rss', 'apt-src build',
            'apt-src clean', 'apt-src import', 'apt-src install',
            'apt-src list', 'apt-src location', 'apt-src name',
            'apt-src remove', 'apt-src update', 'apt-src upgrade',
            'apt-src version',

            'aptitude autoclean', 'aptitude build-dep', 'aptitude changelog',
            'aptitude clean', 'aptitude download', 'aptitude forbid-version',
            'aptitude forget-new', 'aptitude full-upgrade', 'aptitude hold',
            'aptitude install', 'aptitude markauto', 'aptitude purge',
            'aptitude reinstall', 'aptitude remove', 'aptitude safe-upgrade',
            'aptitude search', 'aptitude show', 'aptitude unhold',
            'aptitude unmarkauto', 'aptitude update', 'aptitude versions',
            'aptitude why', 'aptitude why-not',

            'basename', 'bash', 'batctl', 'bc', 'bison', 'bunzip2', 'bzcat',
            'bzcmp', 'bzdiff', 'bzegrep', 'bzfgrep', 'bzgrep',
            'bzip2', 'bzip2recover', 'bzless', 'bzmore',

            'c++', 'cal', 'cat', 'chattr', 'cc', 'cdda2wav', 'cdparanoia',
            'cdrdao', 'cd-read', 'cdrecord', 'chfn', 'chgrp', 'chmod',
            'chown', 'chroot', 'chsh', 'chvt', 'clear', 'cmp', 'comm', 'co',
            'col', 'cp', 'cpio', 'cpp', 'csh', 'cut', 'cvs', 'cvs-pserver',

            'cvs add', 'cvs admin', 'cvs annotate', 'cvs checkout',
            'cvs commit', 'cvs diff', 'cvs edit', 'cvs editors', 'cvs export',
            'cvs history', 'cvs import', 'cvs init', 'cvs log', 'cvs login',
            'cvs logout', 'cvs ls', 'cvs pserver', 'cvs rannotate',
            'cvs rdiff', 'cvs release', 'cvs remove', 'cvs rlog', 'cvs rls',
            'cvs rtag', 'cvs server', 'cvs status', 'cvs tag', 'cvs unedit',
            'cvs update', 'cvs version', 'cvs watch', 'cvs watchers',

            'dash', 'date', 'dc', 'dch', 'dcop', 'dd', 'ddate', 'ddd',
            'deallocvt', 'debconf', 'defoma', 'depmod', 'df', 'dh',
            'dialog', 'diff', 'diff3', 'dig', 'dir', 'dircolors', 'directomatic',
            'dirname', 'dmesg', 'dnsdomainname', 'domainname', 'dpkg',
            'dselect', 'du', 'dumpkeys',

            'ed', 'egrep', 'env', 'expr',

            'false', 'fbset', 'fdisk', 'ffmpeg', 'fgconsole','fgrep', 'file',
            'find', 'flex', 'flex++', 'fmt', 'free', 'ftp', 'funzip', 'fuser',

            'g++', 'gawk', 'gc','gcc', 'gdb', 'getent', 'getkeycodes',
            'getopt', 'gettext', 'gettextize', 'gimp', 'gimp-remote',
            'gimptool', 'gmake', 'gocr', 'grep', 'groups', 'gs', 'gunzip',
            'gzexe', 'gzip',

            'git', 'git add', 'git add--interactive', 'git am', 'git annotate',
            'git apply', 'git archive', 'git bisect', 'git bisect--helper',
            'git blame', 'git branch', 'git bundle', 'git cat-file',
            'git check-attr', 'git checkout', 'git checkout-index',
            'git check-ref-format', 'git cherry', 'git cherry-pick',
            'git clean', 'git clone', 'git commit', 'git commit-tree',
            'git config', 'git count-objects', 'git daemon', 'git describe',
            'git diff', 'git diff-files', 'git diff-index', 'git difftool',
            'git difftool--helper', 'git diff-tree', 'git fast-export',
            'git fast-import', 'git fetch', 'git fetch-pack',
            'git filter-branch', 'git fmt-merge-msg', 'git for-each-ref',
            'git format-patch', 'git fsck', 'git fsck-objects', 'git gc',
            'git get-tar-commit-id', 'git grep', 'git hash-object', 'git help',
            'git http-backend', 'git http-fetch', 'git http-push',
            'git imap-send', 'git index-pack', 'git init', 'git init-db',
            'git instaweb', 'git log', 'git lost-found', 'git ls-files',
            'git ls-remote', 'git ls-tree', 'git mailinfo', 'git mailsplit',
            'git merge', 'git merge-base', 'git merge-file', 'git merge-index',
            'git merge-octopus', 'git merge-one-file', 'git merge-ours',
            'git merge-recursive', 'git merge-resolve', 'git merge-subtree',
            'git mergetool', 'git merge-tree', 'git mktag', 'git mktree',
            'git mv', 'git name-rev', 'git notes', 'git pack-objects',
            'git pack-redundant', 'git pack-refs', 'git patch-id',
            'git peek-remote', 'git prune', 'git prune-packed', 'git pull',
            'git push', 'git quiltimport', 'git read-tree', 'git rebase',
            'git rebase--interactive', 'git receive-pack', 'git reflog',
            'git relink', 'git remote', 'git remote-ftp', 'git remote-ftps',
            'git remote-http', 'git remote-https', 'git remote-testgit',
            'git repack', 'git replace', 'git repo-config', 'git request-pull',
            'git rerere', 'git reset', 'git revert', 'git rev-list',
            'git rev-parse', 'git rm', 'git send-pack', 'git shell',
            'git shortlog', 'git show', 'git show-branch', 'git show-index',
            'git show-ref', 'git stage', 'git stash', 'git status',
            'git stripspace', 'git submodule', 'git symbolic-ref', 'git tag',
            'git tar-tree', 'git unpack-file', 'git unpack-objects',
            'git update-index', 'git update-ref', 'git update-server-info',
            'git upload-archive', 'git upload-pack', 'git var',
            'git verify-pack', 'git verify-tag', 'git web--browse',
            'git whatchanged', 'git write-tree',

            'gitaction', 'git-add', 'git-add--interactive', 'git-am',
            'git-annotate', 'git-apply', 'git-archive', 'git-bisect',
            'git-bisect--helper', 'git-blame', 'git-branch', 'git-bundle',
            'git-cat-file', 'git-check-attr', 'git-checkout',
            'git-checkout-index', 'git-check-ref-format', 'git-cherry',
            'git-cherry-pick', 'git-clean', 'git-clone', 'git-commit',
            'git-commit-tree', 'git-config', 'git-count-objects', 'git-daemon',
            'git-describe', 'git-diff', 'git-diff-files', 'git-diff-index',
            'git-difftool', 'git-difftool--helper', 'git-diff-tree',
            'gitdpkgname', 'git-fast-export', 'git-fast-import', 'git-fetch',
            'git-fetch-pack', 'git-fetch--tool', 'git-filter-branch', 'gitfm',
            'git-fmt-merge-msg', 'git-for-each-ref', 'git-format-patch',
            'git-fsck', 'git-fsck-objects', 'git-gc', 'git-get-tar-commit-id',
            'git-grep', 'git-hash-object', 'git-help', 'git-http-fetch',
            'git-http-push', 'git-imap-send', 'git-index-pack', 'git-init',
            'git-init-db', 'git-instaweb', 'gitkeys', 'git-log',
            'git-lost-found', 'git-ls-files', 'git-ls-remote', 'git-ls-tree',
            'git-mailinfo', 'git-mailsplit', 'git-merge', 'git-merge-base',
            'git-merge-file', 'git-merge-index', 'git-merge-octopus',
            'git-merge-one-file', 'git-merge-ours', 'git-merge-recursive',
            'git-merge-resolve', 'git-merge-subtree', 'git-mergetool',
            'git-mergetool--lib', 'git-merge-tree', 'gitmkdirs', 'git-mktag',
            'git-mktree', 'gitmount', 'git-mv', 'git-name-rev',
            'git-pack-objects', 'git-pack-redundant', 'git-pack-refs',
            'git-parse-remote', 'git-patch-id', 'git-peek-remote', 'git-prune',
            'git-prune-packed', 'gitps', 'git-pull', 'git-push',
            'git-quiltimport', 'git-read-tree', 'git-rebase',
            'git-rebase--interactive', 'git-receive-pack', 'git-reflog',
            'gitregrep', 'git-relink', 'git-remote', 'git-repack',
            'git-repo-config', 'git-request-pull', 'git-rerere', 'git-reset',
            'git-revert', 'git-rev-list', 'git-rev-parse', 'gitrfgrep',
            'gitrgrep', 'git-rm', 'git-send-pack', 'git-shell', 'git-shortlog',
            'git-show', 'git-show-branch', 'git-show-index', 'git-show-ref',
            'git-sh-setup', 'git-stage', 'git-stash', 'git-status',
            'git-stripspace', 'git-submodule', 'git-svn', 'git-symbolic-ref',
            'git-tag', 'git-tar-tree', 'gitunpack', 'git-unpack-file',
            'git-unpack-objects', 'git-update-index', 'git-update-ref',
            'git-update-server-info', 'git-upload-archive', 'git-upload-pack',
            'git-var', 'git-verify-pack', 'git-verify-tag', 'gitview',
            'git-web--browse', 'git-whatchanged', 'gitwhich', 'gitwipe',
            'git-write-tree', 'gitxgrep',

            'head', 'hexdump', 'hostname', 'htop',

            'id', 'ifconfig', 'ifdown', 'ifup', 'igawk', 'install',

            'ip', 'ip addr', 'ip addrlabel', 'ip link', 'ip maddr', 'ip mroute',
            'ip neigh', 'ip route', 'ip rule', 'ip tunnel', 'ip xfrm',

            'jar', 'java', 'javac', 'join',

            'kbd_mode','kbdrate', 'kdialog', 'kfile', 'kill', 'killall',

            'lame', 'last', 'lastb', 'ld', 'ld86', 'ldd', 'less', 'lex', 'link',
            'ln', 'loadkeys', 'loadunimap', 'locate', 'lockfile', 'login',
            'logname', 'lp', 'lpr', 'ls', 'lsattr', 'lsmod', 'lsmod.old',
            'lspci', 'ltrace', 'lynx',

            'm4', 'make', 'man', 'mapscrn', 'mesg', 'mkdir', 'mkfifo',
            'mknod', 'mktemp', 'more', 'mount', 'mplayer', 'msgfmt', 'mv',

            'namei', 'nano', 'nasm', 'nawk', 'netstat', 'nice',
            'nisdomainname', 'nl', 'nm', 'nm86', 'nmap', 'nohup', 'nop',

            'od', 'openvt',

            'passwd', 'patch', 'pbzip2', 'pcregrep', 'pcretest', 'perl',
            'perror', 'pgawk', 'pidof', 'pigz', 'ping', 'pr', 'procmail',
            'prune', 'ps', 'pstree', 'ps2ascii', 'ps2epsi', 'ps2frag',
            'ps2pdf', 'ps2ps', 'psbook', 'psmerge', 'psnup', 'psresize',
            'psselect', 'pstops',

            'rbash', 'rcs', 'rcs2log', 'read', 'readlink', 'red', 'resizecons',
            'rev', 'rm', 'rmdir', 'rsh', 'run-parts',

            'sash', 'scp', 'screen', 'sed', 'seq', 'sendmail', 'setfont',
            'setkeycodes', 'setleds', 'setmetamode', 'setserial', 'setterm',
            'sh', 'showkey', 'shred', 'size', 'size86', 'skill', 'sleep',
            'slogin', 'snice', 'sort', 'sox', 'split', 'ssed', 'ssh', 'ssh-add',
            'ssh-agent', 'ssh-keygen', 'ssh-keyscan', 'sshfs', 'stat', 'strace',
            'strings', 'strip', 'stty', 'su', 'sudo', 'suidperl', 'sum', 'svn',
            'svnadmin', 'svndumpfilter', 'svnlook', 'svnmerge', 'svnmucc',
            'svnserve', 'svnshell', 'svnsync', 'svnversion', 'svnwrap', 'sync',

            'svn add', 'svn ann', 'svn annotate', 'svn blame', 'svn cat',
            'svn changelist', 'svn checkout', 'svn ci', 'svn cl', 'svn cleanup',
            'svn co', 'svn commit', 'svn copy', 'svn cp', 'svn del',
            'svn delete', 'svn di', 'svn diff', 'svn export', 'svn help',
            'svn import', 'svn info', 'svn list', 'svn lock', 'svn log',
            'svn ls', 'svn merge', 'svn mergeinfo', 'svn mkdir', 'svn move',
            'svn mv', 'svn patch', 'svn pd', 'svn pdel', 'svn pe', 'svn pedit',
            'svn pg', 'svn pget', 'svn pl', 'svn plist', 'svn praise',
            'svn propdel', 'svn propedit', 'svn propget', 'svn proplist',
            'svn propset', 'svn ps', 'svn pset', 'svn relocate', 'svn remove',
            'svn rename', 'svn resolve', 'svn resolved', 'svn revert', 'svn rm',
            'svn st', 'svn stat', 'svn status', 'svn sw', 'svn switch',
            'svn unlock', 'svn up', 'svn update', 'svn upgrade',

            'svnadmin crashtest', 'svnadmin create', 'svnadmin deltify',
            'svnadmin dump', 'svnadmin help', 'svnadmin hotcopy',
            'svnadmin list-dblogs', 'svnadmin list-unused-dblogs',
            'svnadmin load', 'svnadmin lslocks', 'svnadmin lstxns',
            'svnadmin pack', 'svnadmin recover', 'svnadmin rmlocks',
            'svnadmin rmtxns', 'svnadmin setlog', 'svnadmin setrevprop',
            'svnadmin setuuid', 'svnadmin upgrade', 'svnadmin verify',

            'svndumpfilter exclude', 'svndumpfilter help',
            'svndumpfilter include',

            'svnlook author', 'svnlook cat', 'svnlook changed', 'svnlook date',
            'svnlook diff', 'svnlook dirs-changed', 'svnlook filesize',
            'svnlook help', 'svnlook history', 'svnlook info', 'svnlook lock',
            'svnlook log', 'svnlook pg', 'svnlook pget', 'svnlook pl',
            'svnlook plist', 'svnlook propget', 'svnlook proplist',
            'svnlook tree', 'svnlook uuid', 'svnlook youngest',

            'svnrdump dump', 'svnrdump help', 'svnrdump load',

            'svnsync copy-revprops', 'svnsync help', 'svnsync info',
            'svnsync init', 'svnsync initialize', 'svnsync sync',
            'svnsync synchronize',

            'tac', 'tail', 'tar', 'tee', 'tempfile', 'touch', 'tr', 'tree',
            'true',

            'umount', 'uname', 'unicode_start', 'unicode_stop', 'uniq',
            'unlink', 'unzip', 'updatedb', 'updmap', 'uptime', 'users',
            'utmpdump', 'uuidgen',

            'valgrind', 'vdir', 'vi', 'vim', 'vmstat',

            'w', 'wall', 'watch', 'wc', 'wget', 'whatis', 'whereis',
            'which', 'whiptail', 'who', 'whoami', 'whois', 'wine', 'wineboot',
            'winebuild', 'winecfg', 'wineconsole', 'winedbg', 'winedump',
            'winefile', 'wodim', 'write',

            'xargs', 'xhost', 'xmodmap', 'xset',

            'yacc', 'yes', 'ypdomainname', 'yum',

            'yum check-update', 'yum clean', 'yum deplist', 'yum erase',
            'yum groupinfo', 'yum groupinstall', 'yum grouplist',
            'yum groupremove', 'yum groupupdate', 'yum info', 'yum install',
            'yum list', 'yum localinstall', 'yum localupdate', 'yum makecache',
            'yum provides', 'yum remove', 'yum resolvedep', 'yum search',
            'yum shell', 'yum update', 'yum upgrade', 'yum whatprovides',

            'zcat', 'zcmp', 'zdiff', 'zdump', 'zegrep', 'zfgrep', 'zforce',
            'zgrep', 'zip', 'zipgrep', 'zipinfo', 'zless', 'zmore', 'znew',
            'zsh', 'zsoelim'
            ),
        3 => array(
            'alias', 'bg', 'bind', 'break', 'builtin', 'cd', 'command',
            'compgen', 'complete', 'continue', 'declare', 'dirs', 'disown',
            'echo', 'enable', 'eval', 'exec', 'exit', 'export', 'fc',
            'fg', 'getopts', 'hash', 'help', 'history', 'jobs', 'let',
            'local', 'logout', 'popd', 'printf', 'pushd', 'pwd', 'readonly',
            'return', 'shift', 'shopt', 'source', 'suspend', 'test', 'times',
            'trap', 'type', 'typeset', 'ulimit', 'umask', 'unalias', 'unset',
            'wait'
            )
        ),
    'SYMBOLS' => array(
        '(', ')', '[', ']', '!', '@', '%', '&', '*', '|', '/', '<', '>', ';;', '`'
        ),
    'CASE_SENSITIVE' => array(
        GESHI_COMMENTS => false,
        1 => true,
        2 => true,
        3 => true
        ),
    'STYLES' => array(
        'KEYWORDS' => array(
            1 => 'color: #000000; font-weight: bold;',
            2 => 'color: #c20cb9; font-weight: bold;',
            3 => 'color: #7a0874; font-weight: bold;'
            ),
        'COMMENTS' => array(
            0 => 'color: #666666; font-style: italic;',
            1 => 'color: #800000;',
            2 => 'color: #cc0000; font-style: italic;',
            3 => 'color: #000000; font-weight: bold;',
            4 => 'color: #666666;'
            ),
        'ESCAPE_CHAR' => array(
            1 => 'color: #000099; font-weight: bold;',
            2 => 'color: #007800;',
            3 => 'color: #007800;',
            4 => 'color: #007800;',
            5 => 'color: #780078;',
            'HARD' => 'color: #000099; font-weight: bold;'
            ),
        'BRACKETS' => array(
            0 => 'color: #7a0874; font-weight: bold;'
            ),
        'STRINGS' => array(
            0 => 'color: #ff0000;',
            'HARD' => 'color: #ff0000;'
            ),
        'NUMBERS' => array(
            0 => 'color: #000000;'
            ),
        'METHODS' => array(
            ),
        'SYMBOLS' => array(
            0 => 'color: #000000; font-weight: bold;'
            ),
        'REGEXPS' => array(
            0 => 'color: #007800;',
            1 => 'color: #007800;',
            2 => 'color: #007800;',
            4 => 'color: #007800;',
            5 => 'color: #660033;'
            ),
        'SCRIPT' => array(
            )
        ),
    'URLS' => array(
        1 => '',
        2 => '',
        3 => ''
        ),
    'OOLANG' => false,
    'OBJECT_SPLITTERS' => array(
        ),
    'REGEXPS' => array(
        //Variables (will be handled by comment_regexps)
        0 => "\\$\\{[a-zA-Z_][a-zA-Z0-9_]*?\\}",
        //Variables without braces
        1 => "\\$[a-zA-Z_][a-zA-Z0-9_]*",
        //Variable assignment
        2 => "(?<![\.a-zA-Z_\-])([a-zA-Z_][a-zA-Z0-9_]*?)(?==)",
        //Shorthand shell variables
        4 => "\\$[*#\$\\-\\?!\d]",
        //Parameters of commands
        5 => "(?<=\s)--?[0-9a-zA-Z\-]+(?=[\s=]|<(?:SEMI|PIPE)>|$)"
        ),
    'STRICT_MODE_APPLIES' => GESHI_NEVER,
    'SCRIPT_DELIMITERS' => array(
        ),
    'HIGHLIGHT_STRICT_BLOCK' => array(
        ),
    'TAB_WIDTH' => 4,
    'PARSER_CONTROL' => array(
        'COMMENTS' => array(
            'DISALLOWED_BEFORE' => '$'
        ),
        'KEYWORDS' => array(
            'DISALLOWED_BEFORE' => "(?<![\.\-a-zA-Z0-9_\$\#:])",
            'DISALLOWED_AFTER' =>  "(?![\.\-a-zA-Z0-9_%=\\/:])",
            2 => array(
                'SPACE_AS_WHITESPACE' => false
                )
            )
        )
);

?>