/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.gjt.sp.jedit.gui.HistoryModelSaver;
import org.gjt.sp.jedit.gui.MutableListModel;

public class HistoryModel
extends DefaultListModel
implements MutableListModel {
    private int max;
    private static int defaultMax;
    private int maxSize;
    private static int defaultMaxSize;
    private final String name;
    private static Map<String, HistoryModel> models;
    private static boolean modified;
    private static HistoryModelSaver saver;

    public HistoryModel(String string) {
        this.name = string;
        this.max = -1;
        this.maxSize = -1;
    }

    public void addItem(String string) {
        int n;
        int n2;
        if (string == null || string.length() == 0) {
            return;
        }
        int n3 = this.indexOf(string);
        if (n3 == 0) {
            return;
        }
        if (n3 != -1) {
            this.removeElementAt(n3);
        }
        int n4 = n2 = this.maxSize == -1 ? defaultMaxSize : this.maxSize;
        if (string.length() > n2) {
            return;
        }
        int n5 = this.getCurrentSize();
        while (n5 + string.length() > n2) {
            n5 -= this.getItem(this.getSize() - 1).length();
            this.removeElementAt(this.getSize() - 1);
        }
        this.insertElementAt(string, 0);
        int n6 = n = this.max >= 0 ? this.max : defaultMax;
        while (this.getSize() > n) {
            this.removeElementAt(this.getSize() - 1);
        }
    }

    @Override
    public void insertElementAt(Object object, int n) {
        modified = true;
        super.insertElementAt(object, n);
    }

    public String getItem(int n) {
        return (String)this.elementAt(n);
    }

    @Override
    public boolean removeElement(Object object) {
        modified = true;
        return super.removeElement(object);
    }

    @Override
    public void removeAllElements() {
        modified = true;
        super.removeAllElements();
    }

    public String getName() {
        return this.name;
    }

    public static HistoryModel getModel(String string) {
        HistoryModel historyModel;
        if (models == null) {
            models = Collections.synchronizedMap(new HashMap());
        }
        if ((historyModel = models.get(string)) == null) {
            historyModel = new HistoryModel(string);
            models.put(string, historyModel);
        }
        return historyModel;
    }

    public static void loadHistory() {
        if (saver != null) {
            models = saver.load(models);
        }
    }

    public static void saveHistory() {
        if (saver != null && modified && saver.save(models)) {
            modified = false;
        }
    }

    public void setMax(int n) {
        this.max = n;
    }

    public int getMax() {
        return this.max;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public static void setDefaultMax(int n) {
        defaultMax = n;
    }

    public static int getDefaultMax() {
        return defaultMax;
    }

    public static void setDefaultMaxSize(int n) {
        defaultMaxSize = n;
    }

    public static int getDefaultMaxSize() {
        return defaultMaxSize;
    }

    public static void setSaver(HistoryModelSaver historyModelSaver) {
        saver = historyModelSaver;
    }

    private int getCurrentSize() {
        int n = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            n += this.getItem(i).length();
        }
        return n;
    }
}

