/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.HyperSearchNode;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.ThreadUtilities;

public class HyperSearchResult
implements HyperSearchNode {
    public String path;
    public Buffer buffer;
    public int line;
    public String str;
    public Occur occur;
    public int occurCount;

    @Override
    public Buffer getBuffer(View view) {
        if (this.buffer == null) {
            this.buffer = jEdit.openFile(view, this.path);
        }
        return this.buffer;
    }

    public Selection[] getSelection() {
        if (this.buffer == null) {
            return null;
        }
        Selection[] selectionArray = new Selection[this.occurCount];
        Occur occur = this.occur;
        int n = 0;
        while (occur != null) {
            int n2 = occur.startPos.getOffset();
            int n3 = occur.endPos.getOffset();
            Selection.Range range = new Selection.Range(n2, n3);
            selectionArray[n++] = range;
            occur = occur.next;
        }
        return selectionArray;
    }

    @Override
    public void goTo(EditPane editPane) {
        new GotoDelayed(editPane);
    }

    public String toString() {
        return this.str;
    }

    HyperSearchResult(Buffer buffer, int n) {
        this.path = buffer.getPath();
        if (!buffer.isTemporary()) {
            this.bufferOpened(buffer);
        }
        this.line = n;
        this.str = n + 1 + ": " + buffer.getLineText(n).replace('\t', ' ').trim();
    }

    void bufferOpened(Buffer buffer) {
        this.buffer = buffer;
        Occur occur = this.occur;
        while (occur != null) {
            occur.bufferOpened();
            occur = occur.next;
        }
    }

    void bufferClosed() {
        this.buffer = null;
        Occur occur = this.occur;
        while (occur != null) {
            occur.bufferClosed();
            occur = occur.next;
        }
    }

    void addOccur(int n, int n2) {
        Occur occur = new Occur(n, n2);
        occur.next = this.occur;
        this.occur = occur;
        ++this.occurCount;
    }

    boolean pathEquals(String string) {
        return string.equals(MiscUtilities.resolveSymlinks(this.path));
    }

    public boolean equals(Object object) {
        if (!(object instanceof HyperSearchResult)) {
            return false;
        }
        HyperSearchResult hyperSearchResult = (HyperSearchResult)object;
        return this.pathEquals(hyperSearchResult.path) && this.line == hyperSearchResult.line && this.buffer.equals(hyperSearchResult.buffer);
    }

    public class GotoDelayed
    implements Runnable {
        private final EditPane editPane;
        private volatile boolean loadedEventReceived = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GotoDelayed(EditPane editPane) {
            this.editPane = editPane;
            EditBus.addToBus(this);
            HyperSearchResult.this.buffer = HyperSearchResult.this.getBuffer(editPane.getView());
            if (HyperSearchResult.this.buffer == null) {
                EditBus.removeFromBus(this);
                return;
            }
            editPane.setBuffer(HyperSearchResult.this.buffer);
            GotoDelayed gotoDelayed = this;
            synchronized (gotoDelayed) {
                if (!this.loadedEventReceived && HyperSearchResult.this.buffer.isLoaded()) {
                    this.bufferLoaded();
                }
            }
        }

        @Override
        public void run() {
            Selection[] selectionArray = HyperSearchResult.this.getSelection();
            if (selectionArray == null) {
                return;
            }
            JEditTextArea jEditTextArea = this.editPane.getTextArea();
            if (jEditTextArea.isMultipleSelectionEnabled()) {
                jEditTextArea.addToSelection(selectionArray);
            } else {
                jEditTextArea.setSelection(selectionArray);
            }
            jEditTextArea.moveCaretPosition(HyperSearchResult.this.occur.endPos.getOffset());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bufferLoaded() {
            GotoDelayed gotoDelayed = this;
            synchronized (gotoDelayed) {
                if (!this.loadedEventReceived) {
                    EditBus.removeFromBus(this);
                    this.loadedEventReceived = true;
                    ThreadUtilities.runInDispatchThread(this);
                }
            }
        }

        @EditBus.EBHandler
        public void handleBufferUpdate(BufferUpdate bufferUpdate) {
            if (bufferUpdate.getWhat() == BufferUpdate.LOADED && bufferUpdate.getBuffer() == HyperSearchResult.this.buffer) {
                this.bufferLoaded();
            }
        }
    }

    public class Occur {
        public int start;
        public int end;
        public Position startPos;
        public Position endPos;
        public Occur next;

        Occur(int n, int n2) {
            this.start = n;
            this.end = n2;
            if (HyperSearchResult.this.buffer != null && !HyperSearchResult.this.buffer.isTemporary()) {
                this.bufferOpened();
            }
        }

        void bufferOpened() {
            this.startPos = HyperSearchResult.this.buffer.createPosition(Math.min(HyperSearchResult.this.buffer.getLength(), this.start));
            this.endPos = HyperSearchResult.this.buffer.createPosition(Math.min(HyperSearchResult.this.buffer.getLength(), this.end));
        }

        void bufferClosed() {
            this.start = this.startPos.getOffset();
            this.end = this.endPos.getOffset();
            this.endPos = null;
            this.startPos = null;
        }
    }
}

