/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import java.math.BigDecimal;
import java.math.BigInteger;

public class PrecisionDecimal {
    public static final PrecisionDecimal PI = new PrecisionDecimal(Math.PI);
    public static final PrecisionDecimal LNBASE = new PrecisionDecimal(Math.E);
    private int exponent = 0;
    private int accuracy = 0;
    private final BigInteger intVal;

    private static int exponentPos(String s) {
        int ret = s.indexOf(83);
        if (ret == -1) {
            ret = s.indexOf(101);
        }
        if (ret == -1) {
            ret = s.indexOf(69);
        }
        return ret;
    }

    public PrecisionDecimal(double v) {
        this(Double.toString(v));
    }

    public PrecisionDecimal(String s) {
        int sp = PrecisionDecimal.exponentPos(s);
        if (sp >= 0) {
            this.exponent = Integer.parseInt(s.substring(sp + 1));
            s = s.substring(0, PrecisionDecimal.exponentPos(s));
        }
        this.intVal = new BigDecimal(s).unscaledValue();
        int pp = s.indexOf(46);
        if (pp >= 0) {
            if (sp >= 0) {
                if (pp < sp) {
                    this.accuracy = sp - pp - 1;
                }
            } else {
                this.accuracy = s.length() - pp - 1;
            }
        } else {
            this.accuracy = 0;
        }
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public int getExponent() {
        return this.exponent;
    }

    public BigInteger getUnscaledValue() {
        return this.intVal;
    }

    public String toString() {
        return this.layoutChars(false);
    }

    private String layoutChars(boolean isIli1) {
        int scale = this.getAccuracy();
        char[] ac = this.intVal.abs().toString().toCharArray();
        StringBuilder stringbuilder = new StringBuilder(ac.length + 14);
        if (this.intVal.signum() < 0) {
            stringbuilder.append('-');
        }
        if (scale > 0) {
            int i = scale - ac.length;
            if (i >= 0) {
                stringbuilder.append('0');
                stringbuilder.append('.');
                while (i > 0) {
                    stringbuilder.append('0');
                    --i;
                }
                stringbuilder.append(ac);
            } else {
                stringbuilder.append(ac, 0, -i);
                stringbuilder.append('.');
                stringbuilder.append(ac, -i, scale);
            }
        } else if (scale < 0) {
            stringbuilder.append(ac[0]);
            if (ac.length > 1) {
                stringbuilder.append('.');
                stringbuilder.append(ac, 1, ac.length - 1);
            }
        } else {
            stringbuilder.append(ac);
        }
        if (this.exponent != 0) {
            stringbuilder.append(isIli1 ? (char)'S' : 'e');
            stringbuilder.append(Integer.toString(this.exponent));
        }
        return stringbuilder.toString();
    }

    public String toIli1String() {
        return this.layoutChars(true);
    }

    public double doubleValue() {
        return Double.parseDouble(this.layoutChars(false));
    }

    public int compareTo(PrecisionDecimal other) {
        if (this.exponent == other.exponent && this.accuracy == other.accuracy) {
            return this.intVal.compareTo(other.intVal);
        }
        int i = this.intVal.signum() - other.intVal.signum();
        if (i != 0) {
            return i <= 0 ? -1 : 1;
        }
        return Double.compare(this.doubleValue(), other.doubleValue());
    }

    public static void main(String[] args) {
        PrecisionDecimal.test("1");
        PrecisionDecimal.test("1.0");
        PrecisionDecimal.test("1e1");
        PrecisionDecimal.test("10.0e1");
        PrecisionDecimal.test("10.00e1");
        PrecisionDecimal.test("10.0e-2");
        PrecisionDecimal.test("0.000000000000000");
        PrecisionDecimal.test("9999999999999999.000000000000000");
        PrecisionDecimal.test("99999999999999990000000000000000");
    }

    private static void test(String valStr) {
        PrecisionDecimal test1 = new PrecisionDecimal(valStr);
        System.out.println(valStr + ": Accuracy " + test1.getAccuracy() + ", Exponent " + test1.getExponent() + ", unscaledValue " + test1.intVal);
        System.out.println(valStr + ": " + test1.toString() + ", double " + test1.doubleValue());
    }
}

