/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ssh.LogListener;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHUserInfo;

public abstract class SSHBase
extends Task
implements LogListener {
    private static final int SSH_PORT = 22;
    private String host;
    private String knownHosts;
    private int port = 22;
    private boolean failOnError = true;
    private boolean verbose;
    private final SSHUserInfo userInfo = new SSHUserInfo();

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setFailonerror(boolean failure) {
        this.failOnError = failure;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setUsername(String username) {
        this.userInfo.setName(username);
    }

    public void setPassword(String password) {
        this.userInfo.setPassword(password);
    }

    public void setKeyfile(String keyfile) {
        this.userInfo.setKeyfile(keyfile);
    }

    public void setPassphrase(String passphrase) {
        this.userInfo.setPassphrase(passphrase);
    }

    public void setKnownhosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public void setTrust(boolean yesOrNo) {
        this.userInfo.setTrust(yesOrNo);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void init() throws BuildException {
        super.init();
        this.knownHosts = System.getProperty("user.home") + "/.ssh/known_hosts";
        this.port = 22;
    }

    protected Session openSession() throws JSchException {
        JSch jsch = new JSch();
        final SSHBase base = this;
        if (this.verbose) {
            JSch.setLogger((Logger)new Logger(){

                public boolean isEnabled(int level) {
                    return true;
                }

                public void log(int level, String message) {
                    base.log(message, 2);
                }
            });
        }
        if (null != this.userInfo.getKeyfile()) {
            jsch.addIdentity(this.userInfo.getKeyfile());
        }
        if (!this.userInfo.getTrust() && this.knownHosts != null) {
            this.log("Using known hosts: " + this.knownHosts, 4);
            jsch.setKnownHosts(this.knownHosts);
        }
        Session session = jsch.getSession(this.userInfo.getName(), this.host, this.port);
        session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
        session.setUserInfo((UserInfo)this.userInfo);
        this.log("Connecting to " + this.host + ":" + this.port);
        session.connect();
        return session;
    }

    protected SSHUserInfo getUserInfo() {
        return this.userInfo;
    }
}

