/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.appui.welcome;

import com.sun.tools.visualvm.modules.appui.welcome.FixedImagePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

class HorizontalImagePanel
extends FixedImagePanel {
    private Dimension minSize;
    private Dimension maxSize;

    public HorizontalImagePanel(Image img) {
        super(img);
        this.minSize = new Dimension(0, this.imageSize.height);
        this.maxSize = new Dimension(Integer.MAX_VALUE, this.imageSize.height);
    }

    public Dimension getPreferredSize() {
        Component[] childComponents = this.getComponents();
        if (childComponents.length == 0) {
            return this.minSize;
        }
        int minWidth = 0;
        for (Component component : childComponents) {
            int minChildComponentWidth = component.getMinimumSize().width;
            if (minWidth >= minChildComponentWidth) continue;
            minWidth = minChildComponentWidth;
        }
        return new Dimension(minWidth, this.imageSize.height);
    }

    public Dimension getMaximumSize() {
        return this.maxSize;
    }

    protected void paintComponent(Graphics graphics) {
        int compEnd = this.getSize().width;
        for (int drawEnd = 0; drawEnd < compEnd; drawEnd += this.imageSize.width) {
            graphics.drawImage(this.image, drawEnd, 0, this);
        }
    }
}

