/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.query.QuerySearchResult;

public class PercolateShardResponse
extends BroadcastShardResponse {
    private static final BytesRef[] EMPTY_MATCHES = new BytesRef[0];
    private static final float[] EMPTY_SCORES = new float[0];
    private static final List<Map<String, HighlightField>> EMPTY_HL = Collections.emptyList();
    private long count;
    private float[] scores;
    private BytesRef[] matches;
    private List<Map<String, HighlightField>> hls;
    private byte percolatorTypeId;
    private int requestedSize;
    private InternalAggregations aggregations;
    private List<SiblingPipelineAggregator> pipelineAggregators;

    PercolateShardResponse() {
        this.hls = new ArrayList<Map<String, HighlightField>>();
    }

    public PercolateShardResponse(BytesRef[] matches, List<Map<String, HighlightField>> hls, long count, float[] scores, PercolateContext context, ShardId shardId) {
        super(shardId);
        this.matches = matches;
        this.hls = hls;
        this.count = count;
        this.scores = scores;
        this.percolatorTypeId = context.percolatorTypeId;
        this.requestedSize = context.size();
        QuerySearchResult result = context.queryResult();
        if (result != null) {
            if (result.aggregations() != null) {
                this.aggregations = (InternalAggregations)result.aggregations();
            }
            this.pipelineAggregators = result.pipelineAggregators();
        }
    }

    public PercolateShardResponse(BytesRef[] matches, long count, float[] scores, PercolateContext context, ShardId shardId) {
        this(matches, EMPTY_HL, count, scores, context, shardId);
    }

    public PercolateShardResponse(BytesRef[] matches, List<Map<String, HighlightField>> hls, long count, PercolateContext context, ShardId shardId) {
        this(matches, hls, count, EMPTY_SCORES, context, shardId);
    }

    public PercolateShardResponse(long count, PercolateContext context, ShardId shardId) {
        this(EMPTY_MATCHES, EMPTY_HL, count, EMPTY_SCORES, context, shardId);
    }

    public PercolateShardResponse(PercolateContext context, ShardId shardId) {
        this(EMPTY_MATCHES, EMPTY_HL, 0L, EMPTY_SCORES, context, shardId);
    }

    public BytesRef[] matches() {
        return this.matches;
    }

    public float[] scores() {
        return this.scores;
    }

    public long count() {
        return this.count;
    }

    public int requestedSize() {
        return this.requestedSize;
    }

    public List<Map<String, HighlightField>> hls() {
        return this.hls;
    }

    public InternalAggregations aggregations() {
        return this.aggregations;
    }

    public List<SiblingPipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    public byte percolatorTypeId() {
        return this.percolatorTypeId;
    }

    public boolean isEmpty() {
        return this.percolatorTypeId == 0;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.percolatorTypeId = in.readByte();
        this.requestedSize = in.readVInt();
        this.count = in.readVLong();
        this.matches = new BytesRef[in.readVInt()];
        for (i = 0; i < this.matches.length; ++i) {
            this.matches[i] = in.readBytesRef();
        }
        this.scores = new float[in.readVInt()];
        for (i = 0; i < this.scores.length; ++i) {
            this.scores[i] = in.readFloat();
        }
        int size = in.readVInt();
        for (int i2 = 0; i2 < size; ++i2) {
            int mSize = in.readVInt();
            HashMap<String, HighlightField> fields = new HashMap<String, HighlightField>();
            for (int j = 0; j < mSize; ++j) {
                fields.put(in.readString(), HighlightField.readHighlightField(in));
            }
            this.hls.add(fields);
        }
        this.aggregations = InternalAggregations.readOptionalAggregations(in);
        if (in.readBoolean()) {
            int pipelineAggregatorsSize = in.readVInt();
            ArrayList<SiblingPipelineAggregator> pipelineAggregators = new ArrayList<SiblingPipelineAggregator>(pipelineAggregatorsSize);
            for (int i3 = 0; i3 < pipelineAggregatorsSize; ++i3) {
                BytesReference type = in.readBytesReference();
                PipelineAggregator pipelineAggregator = PipelineAggregatorStreams.stream(type).readResult(in);
                pipelineAggregators.add((SiblingPipelineAggregator)pipelineAggregator);
            }
            this.pipelineAggregators = pipelineAggregators;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.percolatorTypeId);
        out.writeVLong(this.requestedSize);
        out.writeVLong(this.count);
        out.writeVInt(this.matches.length);
        BytesRef[] bytesRefArray = this.matches;
        int n = bytesRefArray.length;
        for (int i$ = 0; i$ < n; ++i$) {
            BytesRef match = bytesRefArray[i$];
            out.writeBytesRef(match);
        }
        out.writeVLong(this.scores.length);
        for (float score : this.scores) {
            out.writeFloat(score);
        }
        out.writeVInt(this.hls.size());
        for (Map<String, HighlightField> map : this.hls) {
            out.writeVInt(map.size());
            for (Map.Entry<String, HighlightField> entry : map.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        }
        out.writeOptionalStreamable(this.aggregations);
        if (this.pipelineAggregators == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.pipelineAggregators.size());
            for (PipelineAggregator pipelineAggregator : this.pipelineAggregators) {
                out.writeBytesReference(pipelineAggregator.type().stream());
                pipelineAggregator.writeTo(out);
            }
        }
    }
}

